/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.selection;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.rinorsi.cadeditor.client.ClientConfiguration;
import com.github.rinorsi.cadeditor.client.screen.model.selection.ListSelectionFilter;
import com.github.rinorsi.cadeditor.client.screen.model.selection.ListSelectionScreenModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SelectableListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.view.selection.ListSelectionScreenView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ListSelectionScreenController
extends AbstractController<ListSelectionScreenModel, ListSelectionScreenView> {
    private ListSelectionFilter activeFilter;

    public ListSelectionScreenController(ListSelectionScreenModel model, ListSelectionScreenView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        ((ListSelectionScreenView)this.view).getHeaderLabel().setLabel((class_2561)ModTexts.title(ModTexts.choose(((ListSelectionScreenModel)this.model).getTitle())));
        ((ListSelectionScreenView)this.view).getSearchField().textProperty().addListener(this::filter);
        this.setupFilterButton();
        if (((ListSelectionScreenModel)this.model).isMultiSelect()) {
            ((ListSelectionScreenModel)this.model).getElements().forEach(item -> this.initializeSelectableItem((ListSelectionElementModel)item));
        } else {
            ((ListSelectionScreenModel)this.model).getElements().forEach(item -> {
                if (item.getId().toString().equals(((ListSelectionScreenModel)this.model).getInitialValue())) {
                    ((ListSelectionScreenView)this.view).getListView().setFocusedElement((ListSelectionElementModel)item);
                }
            });
            ((ListSelectionScreenView)this.view).getListView().focusedElementProperty().addListener(this::refreshButton);
        }
        ((ListSelectionScreenView)this.view).getCancelButton().onAction(Guapi.getScreenHandler()::hideScene);
        if (((ListSelectionScreenModel)this.model).isMultiSelect()) {
            ((ListSelectionScreenView)this.view).getDoneButton().onAction(() -> {
                if (((ListSelectionScreenModel)this.model).getMultiAction() != null) {
                    List selectedIds = ((ListSelectionScreenModel)this.model).getElements().stream().filter(SelectableListSelectionElementModel.class::isInstance).map(SelectableListSelectionElementModel.class::cast).filter(SelectableListSelectionElementModel::isSelected).map(item -> ((ListSelectionElementModel)((Object)item)).getId()).collect(Collectors.toCollection(() -> new ArrayList()));
                    ((ListSelectionScreenModel)this.model).getMultiAction().accept(selectedIds);
                }
                Guapi.getScreenHandler().hideScene();
            });
        } else {
            ((ListSelectionScreenView)this.view).getDoneButton().onAction(() -> {
                ((ListSelectionScreenModel)this.model).getAction().accept(((ListSelectionElementModel)((ListSelectionScreenView)this.view).getListView().getFocusedElement()).getId().toString());
                Guapi.getScreenHandler().hideScene();
            });
        }
        this.refreshButton();
        this.filter("");
    }

    private void setupFilterButton() {
        List<ListSelectionFilter> filters = ((ListSelectionScreenModel)this.model).getFilters();
        if (filters == null || filters.isEmpty()) {
            ((ListSelectionScreenView)this.view).getFilterButton().setVisible(false);
            ((ListSelectionScreenView)this.view).getFilterButton().setMinWidth(0);
            ((ListSelectionScreenView)this.view).getFilterButton().setPrefWidth(0);
            ((ListSelectionScreenView)this.view).getFilterButton().setMaxWidth(0);
            return;
        }
        ((ListSelectionScreenView)this.view).getFilterButton().setVisible(true);
        ((ListSelectionScreenView)this.view).getFilterButton().setMinWidth(80);
        ((ListSelectionScreenView)this.view).getFilterButton().setPrefWidth(100);
        ((ListSelectionScreenView)this.view).getFilterButton().setMaxWidth(140);
        ((ListSelectionScreenView)this.view).getFilterButton().getValues().setAll((Collection<ListSelectionFilter>)filters);
        ((ListSelectionScreenView)this.view).getFilterButton().setTextFactory(ListSelectionFilter::label);
        Optional<ListSelectionFilter> initial = filters.stream().filter((? super T filter) -> filter.getId().equals(((ListSelectionScreenModel)this.model).getInitialFilterId())).findFirst();
        this.activeFilter = initial.orElse(filters.get(0));
        ((ListSelectionScreenView)this.view).getFilterButton().setValue(this.activeFilter);
        ((ListSelectionScreenView)this.view).getFilterButton().valueProperty().addListener(() -> {
            this.activeFilter = ((ListSelectionScreenView)this.view).getFilterButton().getValue();
            this.filter(((ListSelectionScreenView)this.view).getSearchField().getText());
        });
    }

    private void filter(String filter) {
        ((ListSelectionScreenView)this.view).getListView().getItems().setAll((Collection<ListSelectionElementModel>)((ListSelectionScreenModel)this.model).getElements().stream().filter((? super T item) -> this.activeFilter == null || this.activeFilter.test((ListSelectionElementModel)item)).filter((? super T item) -> item.matches(filter)).limit(ClientConfiguration.INSTANCE.getSelectionScreenMaxItems()).toList());
        this.refreshButton();
    }

    private void refreshButton() {
        if (((ListSelectionScreenModel)this.model).isMultiSelect()) {
            boolean anySelected = ((ListSelectionScreenModel)this.model).getElements().stream().filter(SelectableListSelectionElementModel.class::isInstance).map(SelectableListSelectionElementModel.class::cast).anyMatch(SelectableListSelectionElementModel::isSelected);
            ((ListSelectionScreenView)this.view).getDoneButton().setDisable(!anySelected);
        } else {
            ((ListSelectionScreenView)this.view).getDoneButton().setDisable(((ListSelectionScreenView)this.view).getListView().getFocusedElement() == null);
        }
    }

    private void initializeSelectableItem(ListSelectionElementModel item) {
        if (item instanceof SelectableListSelectionElementModel) {
            SelectableListSelectionElementModel selectable = (SelectableListSelectionElementModel)((Object)item);
            class_2960 id = item.getId();
            selectable.setSelected(((ListSelectionScreenModel)this.model).getInitiallySelected().contains(id));
            selectable.selectedProperty().addListener(this::refreshButton);
        }
    }
}

