/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.screen.model.StandardEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityEquipmentCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityGeneralCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityMountCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntitySpawnSettingsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityStatusEffectsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityTamingCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityVillagerDataCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityVillagerTradeCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.player.EntityPlayerAbilitiesCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.player.EntityPlayerEnderChestCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.player.EntityPlayerInventoryCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.player.EntityPlayerPositionCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.player.EntityPlayerStatsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.player.EntityPlayerStatusEffectsCategoryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3988;
import net.minecraft.class_5146;
import net.minecraft.class_6025;

public class EntityEditorModel
extends StandardEditorModel {
    public EntityEditorModel(EntityEditorContext context) {
        super(context);
    }

    public EntityEditorContext getContext() {
        return (EntityEditorContext)super.getContext();
    }

    @Override
    public void save() {
        boolean hadPermission = this.getContext().hasPermission();
        super.save();
        if (hadPermission && this.getContext().hasPermission()) {
            ClientUtil.showMessage((class_2561)ModTexts.Messages.successUpdate(ModTexts.ENTITY));
        }
    }

    @Override
    protected void setupCategories() {
        this.getCategories().add(new EntityGeneralCategoryModel(this));
        class_1297 entity = this.getContext().getEntity();
        if (entity instanceof class_1309) {
            this.getCategories().add(new EntityEquipmentCategoryModel(this));
            if (!(entity instanceof class_1657)) {
                this.getCategories().add(new EntityStatusEffectsCategoryModel(this));
            }
            if (this.isTamable(entity)) {
                this.getCategories().add(new EntityTamingCategoryModel(this));
            }
            if (this.hasMountData(entity)) {
                this.getCategories().add(new EntityMountCategoryModel(this));
            }
        }
        if (entity instanceof class_1308) {
            this.getCategories().add(new EntitySpawnSettingsCategoryModel(this));
        }
        if (entity instanceof class_3988) {
            this.getCategories().add(new EntityVillagerDataCategoryModel(this));
            this.getCategories().add(new EntityVillagerTradeCategoryModel(this));
        }
        if (this.isPlayerEntity()) {
            this.getCategories().add(new EntityPlayerInventoryCategoryModel(this));
            this.getCategories().add(new EntityPlayerEnderChestCategoryModel(this));
            this.getCategories().add(new EntityPlayerStatsCategoryModel(this));
            this.getCategories().add(new EntityPlayerAbilitiesCategoryModel(this));
            this.getCategories().add(new EntityPlayerPositionCategoryModel(this));
            this.getCategories().add(new EntityPlayerStatusEffectsCategoryModel(this));
        }
    }

    private boolean isPlayerEntity() {
        class_2487 components;
        class_1297 entity = this.getContext().getEntity();
        if (entity instanceof class_1657) {
            return true;
        }
        class_2487 tag = this.getContext().getTag();
        if (tag == null) {
            return false;
        }
        String id = tag.method_10558("id");
        if ("minecraft:player".equals(id) || "player".equals(id)) {
            return true;
        }
        if (tag.method_10573("EnderItems", 9) || tag.method_10573("abilities", 10) || tag.method_10573("playerGameType", 3) || tag.method_10573("recipeBook", 10)) {
            return true;
        }
        return tag.method_10573("components", 10) && (components = tag.method_10562("components")).method_10573("minecraft:profile", 10);
    }

    private boolean hasMountData(class_1297 entity) {
        if (entity instanceof class_5146) {
            return true;
        }
        class_2487 tag = this.getContext().getTag();
        if (tag == null) {
            return false;
        }
        return tag.method_10545("Saddle") || tag.method_10545("Saddled") || tag.method_10573("SaddleItem", 10) || tag.method_10573("Passengers", 9) || tag.method_10545("Leash") || tag.method_10545("LeashHolder") || tag.method_10545("ChestedHorse");
    }

    private boolean isTamable(class_1297 entity) {
        if (entity instanceof class_1321 || entity instanceof class_6025) {
            return true;
        }
        class_2487 tag = this.getContext().getTag();
        if (tag == null) {
            return false;
        }
        return tag.method_10573("Tame", 1) || tag.method_10573("Owner", 8) || tag.method_10545("OwnerUUID") || tag.method_10573("OwnerUUIDMost", 4) || tag.method_10573("OwnerUUIDLeast", 4);
    }
}

