/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.debug.DebugLog;
import com.github.rinorsi.cadeditor.client.screen.model.StandardEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.EditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.FoodComponentState;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemAttributeModifiersCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemBannerPatternCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemBlockListCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemBucketEntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemBundleContentsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemContainerGridCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemContainerLootCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemCrossbowCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemCustomDataCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemDisplayCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemDyeableCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEnchantmentsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemFireworkStarCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemFireworksCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemFoodEffectsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemFoodPropertiesCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemGeneralCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemHideFlagsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemInstrumentCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemLodestoneCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemMapCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemMapDecorationsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemOminousBottleCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemPotDecorationsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemPotionEffectsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemProfileCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemSpawnEggCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemSuspiciousStewEffectsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemToolCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemTrimCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemWritableBookPagesCategoryModel;
import com.github.rinorsi.cadeditor.client.util.CompatFood;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1738;
import net.minecraft.class_1746;
import net.minecraft.class_1747;
import net.minecraft.class_1759;
import net.minecraft.class_1764;
import net.minecraft.class_1766;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1812;
import net.minecraft.class_1819;
import net.minecraft.class_1826;
import net.minecraft.class_1833;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2325;
import net.minecraft.class_2377;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3708;
import net.minecraft.class_4174;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemEditorModel
extends StandardEditorModel {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String KEY_COMPONENTS = "components";
    private static final String KEY_LEGACY_TAG = "tag";
    private static final String TOMBSTONE_PREFIX = "!";
    private static final String FOOD_COMPONENT_KEY = "minecraft:food";
    private static final Set<String> DELETE_IF_ABSENT_KEYS = Set.of("minecraft:hide_tooltip", "minecraft:hide_additional_tooltip", "minecraft:tooltip_display", "minecraft:enchantment_glint_override", "minecraft:custom_name");
    private static final int MIN_NUTRITION = 0;
    private static final int MAX_DURATION_TICKS = 72000;
    private static final int MAX_AMPLIFIER = 255;
    private static final float MIN_EAT_SECONDS = 0.05f;
    private final FoodComponentState foodState = new FoodComponentState();
    private boolean desiredFoodEnabled;
    private ItemGeneralCategoryModel generalCategory;
    private ItemFoodPropertiesCategoryModel foodPropertiesCategory;
    private ItemFoodEffectsCategoryModel foodEffectsCategory;

    public ItemEditorModel(ItemEditorContext context) {
        super(context);
    }

    public ItemEditorContext getContext() {
        return (ItemEditorContext)super.getContext();
    }

    @Override
    public void initalize() {
        super.initalize();
        this.getCategories().forEach(category -> category.initalize());
    }

    @Override
    protected void setupCategories() {
        this.generalCategory = new ItemGeneralCategoryModel(this);
        this.getCategories().add(this.generalCategory);
        this.getCategories().add(new ItemDisplayCategoryModel(this));
        this.getCategories().add(new ItemEnchantmentsCategoryModel(this));
        class_1799 stack = this.getContext().getItemStack();
        class_1792 item = stack.method_7909();
        this.getCategories().add(new ItemAttributeModifiersCategoryModel(this));
        this.getCategories().add(new ItemHideFlagsCategoryModel(this));
        if (stack.method_31573(class_3489.field_48803) || stack.method_57826(class_9334.field_49644)) {
            this.getCategories().add(new ItemDyeableCategoryModel(this));
        }
        if (item instanceof class_1826) {
            class_1826 spawnEgg = (class_1826)item;
            this.getCategories().add(new ItemSpawnEggCategoryModel(this, spawnEgg));
        }
        if (stack.method_57826(class_9334.field_50077) || item instanceof class_1766) {
            this.getCategories().add(new ItemToolCategoryModel(this));
        }
        if (item instanceof class_1806 || stack.method_57826(class_9334.field_49646) || stack.method_57826(class_9334.field_49645) || stack.method_57826(class_9334.field_49647) || stack.method_57826(class_9334.field_49648)) {
            this.getCategories().add(new ItemMapCategoryModel(this));
            this.getCategories().add(new ItemMapDecorationsCategoryModel(this));
        }
        if (item instanceof class_1764 || stack.method_57826(class_9334.field_49649)) {
            this.getCategories().add(new ItemCrossbowCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_49650) || item == class_1802.field_27023) {
            this.getCategories().add(new ItemBundleContentsCategoryModel(this));
        }
        if (item instanceof class_1759 || stack.method_57826(class_9334.field_49614)) {
            this.getCategories().add(new ItemLodestoneCategoryModel(this));
        }
        if (item == class_1802.field_8766) {
            this.getCategories().add(new ItemSuspiciousStewEffectsCategoryModel(this));
        }
        if (item == class_1802.field_8575) {
            this.getCategories().add(new ItemProfileCategoryModel(this));
        }
        boolean isContainerBlockItem = false;
        if (item instanceof class_1747) {
            class_1747 bi = (class_1747)item;
            class_2248 block = bi.method_7711();
            boolean bl = isContainerBlockItem = block instanceof class_2480 || block instanceof class_2281 || block instanceof class_3708 || block instanceof class_2315 || block instanceof class_2325 || block instanceof class_2377;
        }
        if (stack.method_57826(class_9334.field_49622) || isContainerBlockItem) {
            this.getCategories().add(new ItemContainerGridCategoryModel(this));
            if (stack.method_57826(class_9334.field_49626) || isContainerBlockItem) {
                this.getCategories().add(new ItemContainerLootCategoryModel(this));
            }
        }
        if (stack.method_57826(class_9334.field_49607) || item instanceof class_1738) {
            this.getCategories().add(new ItemTrimCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_49619) || stack.method_57826(class_9334.field_49620) || item instanceof class_1746 || item instanceof class_1819) {
            this.getCategories().add(new ItemBannerPatternCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_49610) || item instanceof class_1785) {
            this.getCategories().add(new ItemBucketEntityCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_49612) || item == class_1802.field_39057) {
            this.getCategories().add(new ItemInstrumentCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_49621) || item == class_1802.field_42699) {
            this.getCategories().add(new ItemPotDecorationsCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_49615) || item == class_1802.field_8450) {
            this.getCategories().add(new ItemFireworkStarCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_49616) || item == class_1802.field_8639) {
            this.getCategories().add(new ItemFireworksCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_50238) || item == class_1802.field_50140) {
            this.getCategories().add(new ItemOminousBottleCategoryModel(this));
        }
        if (stack.method_57826(class_9334.field_49628)) {
            this.getCategories().add(new ItemCustomDataCategoryModel(this));
        }
        if (item == class_1802.field_8674) {
            this.getCategories().add(new ItemWritableBookPagesCategoryModel(this));
        }
        this.getCategories().add(new ItemBlockListCategoryModel((class_2561)ModTexts.CAN_DESTROY, this, "CanDestroy"));
        this.foodState.loadFrom(stack);
        this.desiredFoodEnabled = this.foodState.isEnabled();
        if (item instanceof class_1812 || item instanceof class_1833) {
            this.getCategories().add(new ItemPotionEffectsCategoryModel(this));
        }
        if (this.desiredFoodEnabled) {
            this.attachFoodCategories();
        }
        if (item instanceof class_1747) {
            this.getCategories().add(new ItemBlockListCategoryModel((class_2561)ModTexts.CAN_PLACE_ON, this, "CanPlaceOn"));
        }
    }

    @Override
    public void apply() {
        ItemEditorContext context = this.getContext();
        super.apply();
        this.applyFoodComponent();
        class_2487 stagedLegacy = ItemEditorModel.copyLegacyPayload(context.getTag());
        class_7225.class_7874 registryAccess = this.getRegistryAccess();
        class_2520 rebuilt = context.getItemStack().method_57376(registryAccess, (class_2520)new class_2487());
        if (rebuilt instanceof class_2487) {
            class_2487 compound = (class_2487)rebuilt;
            if (stagedLegacy != null && !stagedLegacy.method_33133()) {
                compound.method_10566(KEY_LEGACY_TAG, (class_2520)stagedLegacy);
            } else {
                compound.method_10551(KEY_LEGACY_TAG);
            }
            context.setTag(compound);
            class_1799 parsed = class_1799.method_57359((class_7225.class_7874)registryAccess, (class_2487)compound);
            context.setItemStack(parsed.method_7960() ? context.getItemStack().method_7972() : parsed);
        }
    }

    public FoodComponentState getFoodState() {
        return this.foodState;
    }

    public void enableFoodComponent() {
        if (this.desiredFoodEnabled) {
            return;
        }
        this.foodState.prepareForInitialEnable(this.getContext().getItemStack());
        this.desiredFoodEnabled = true;
        this.applyFoodComponent();
        this.attachFoodCategories();
        if (this.generalCategory != null) {
            this.generalCategory.syncFoodToggle();
        }
    }

    public void disableFoodComponent() {
        if (!this.desiredFoodEnabled) {
            return;
        }
        this.desiredFoodEnabled = false;
        this.applyFoodComponent();
        this.detachFoodCategories();
        if (this.generalCategory != null) {
            this.generalCategory.syncFoodToggle();
        }
    }

    public void applyFoodComponent() {
        class_1799 stack = this.getContext().getItemStack();
        if (this.desiredFoodEnabled) {
            this.writeFoodComponent(stack);
        } else {
            stack.method_57381(class_9334.field_50075);
            this.foodState.updateOriginalUsingConvertsTo(Optional.empty());
            DebugLog.infoKey("cadeditor.debug.food.removed", this.describeStackForLogs(stack));
        }
        this.syncContextSnapshot(stack);
    }

    private void writeFoodComponent(class_1799 stack) {
        try {
            class_4174 properties = this.buildSafeFoodProperties();
            stack.method_57379(class_9334.field_50075, (Object)properties);
            DebugLog.infoKey("cadeditor.debug.food.applied", this.describeStackForLogs(stack), properties.comp_2491(), Float.valueOf(properties.comp_2492()), properties.comp_2493(), Float.valueOf(properties.comp_2494()), properties.comp_2495());
        }
        catch (Throwable t) {
            LOGGER.error("Building FoodProperties failed, fallback to no-effects. Cause: {}", (Object)t.toString());
            class_4174 safe = new class_4174(Math.max(0, this.foodState.getNutrition()), Math.max(0.0f, this.foodState.getSaturation()), this.foodState.isAlwaysEat(), Math.max(0.05f, this.foodState.getEatSeconds()), this.foodState.resolveUsingConvertsTo(), List.of());
            stack.method_57379(class_9334.field_50075, (Object)safe);
        }
    }

    private class_4174 buildSafeFoodProperties() {
        int nutrition = Math.max(0, this.foodState.getNutrition());
        if (nutrition != this.foodState.getNutrition()) {
            this.foodState.setNutrition(nutrition);
        }
        float saturation = Math.max(0.0f, this.foodState.getSaturation());
        float eatSeconds = Math.max(0.05f, this.foodState.getEatSeconds());
        Optional<class_1799> convertsTo = this.foodState.resolveUsingConvertsTo();
        List<class_4174.class_9423> effects = this.sanitizeEffects(this.foodState.copyEffectsForComponent());
        class_4174 props = new class_4174(nutrition, saturation, this.foodState.isAlwaysEat(), eatSeconds, convertsTo, effects);
        this.foodState.updateOriginalUsingConvertsTo(convertsTo);
        return props;
    }

    private List<class_4174.class_9423> sanitizeEffects(List<class_4174.class_9423> raw) {
        if (raw == null || raw.isEmpty()) {
            return List.of();
        }
        ArrayList out = new ArrayList(raw.size());
        for (class_4174.class_9423 pe : raw) {
            try {
                class_6880 effHolder;
                class_1293 inst;
                float p;
                if (pe == null || !((p = pe.comp_2497()) > 0.0f)) continue;
                if (p > 1.0f) {
                    p = 1.0f;
                }
                if ((inst = pe.comp_2496()) == null || (effHolder = inst.method_5579()) == null) continue;
                int dur = Math.max(1, Math.min(inst.method_5584(), 72000));
                int amp = Math.max(0, Math.min(inst.method_5578(), 255));
                boolean ambient = inst.method_5591();
                boolean showParticles = inst.method_5581();
                boolean showIcon = inst.method_5592();
                class_1293 rebuilt = new class_1293(effHolder, dur, amp, ambient, showParticles, showIcon);
                CompatFood.makePossibleEffect(rebuilt, p).ifPresent(out::add);
            }
            catch (Throwable t) {
                LOGGER.warn("Skip invalid food effect {} due to {}", (Object)String.valueOf(pe), (Object)t.toString());
            }
        }
        return out.isEmpty() ? List.of() : List.copyOf(out);
    }

    public void handleStackReplaced(class_1799 newStack) {
        class_1799 stack = newStack == null ? class_1799.field_8037 : newStack.method_7972();
        this.syncContextSnapshot(stack);
        this.desiredFoodEnabled = this.foodState.isEnabled();
        CategoryModel previousSelection = this.getSelectedCategory();
        Class<?> previousCategoryClass = previousSelection == null ? null : previousSelection.getClass();
        this.getCategories().clear();
        this.setupCategories();
        this.getCategories().forEach(category -> category.initalize());
        if (!this.getCategories().isEmpty()) {
            EditorCategoryModel toSelect = (EditorCategoryModel)this.getCategories().get(0);
            if (previousCategoryClass != null) {
                for (EditorCategoryModel category2 : this.getCategories()) {
                    if (category2.getClass() != previousCategoryClass) continue;
                    toSelect = category2;
                    break;
                }
            }
            this.setSelectedCategory(toSelect);
        }
        if (this.generalCategory != null) {
            this.generalCategory.syncFoodToggle();
        }
    }

    private void attachFoodCategories() {
        this.detachFoodCategories();
        this.foodPropertiesCategory = new ItemFoodPropertiesCategoryModel(this);
        this.foodEffectsCategory = new ItemFoodEffectsCategoryModel(this);
        int insertIndex = this.findFoodInsertIndex();
        this.getCategories().add(insertIndex, this.foodPropertiesCategory);
        this.getCategories().add(insertIndex + 1, this.foodEffectsCategory);
        this.foodPropertiesCategory.initalize();
        this.foodEffectsCategory.initalize();
    }

    private void detachFoodCategories() {
        boolean wasSelected;
        boolean bl = wasSelected = this.getSelectedCategory() == this.foodPropertiesCategory || this.getSelectedCategory() == this.foodEffectsCategory;
        if (this.foodPropertiesCategory != null) {
            this.getCategories().remove(this.foodPropertiesCategory);
        }
        if (this.foodEffectsCategory != null) {
            this.getCategories().remove(this.foodEffectsCategory);
        }
        if (wasSelected && !this.getCategories().isEmpty()) {
            this.setSelectedCategory((CategoryModel)this.getCategories().get(0));
        }
        this.foodPropertiesCategory = null;
        this.foodEffectsCategory = null;
    }

    private int findFoodInsertIndex() {
        for (int i = 0; i < this.getCategories().size(); ++i) {
            if (!((EditorCategoryModel)this.getCategories().get(i)).getName().equals((Object)ModTexts.CAN_PLACE_ON)) continue;
            return i;
        }
        return this.getCategories().size();
    }

    private void syncContextSnapshot(class_1799 stack) {
        class_2487 oldRoot;
        class_2487 legacy;
        ItemEditorContext context = this.getContext();
        class_7225.class_7874 registryAccess = this.getRegistryAccess();
        class_2520 saved = stack.method_57376(registryAccess, (class_2520)new class_2487());
        if (!(saved instanceof class_2487)) {
            return;
        }
        class_2487 compound = (class_2487)saved;
        if (!this.desiredFoodEnabled) {
            ItemEditorModel.ensureComponentsTag(compound).method_10566("!minecraft:food", (class_2520)new class_2487());
        }
        if ((legacy = ItemEditorModel.copyLegacyPayload(oldRoot = context.getTag())) != null && !legacy.method_33133()) {
            compound.method_10566(KEY_LEGACY_TAG, (class_2520)legacy);
        } else {
            compound.method_10551(KEY_LEGACY_TAG);
        }
        Set<String> doNotCopyBack = this.desiredFoodEnabled ? Collections.emptySet() : Set.of(FOOD_COMPONENT_KEY);
        compound = ItemEditorModel.mergeComponentsPreservingUnknown(oldRoot, compound, doNotCopyBack);
        if (this.desiredFoodEnabled && !ItemEditorModel.hasComponent(compound, FOOD_COMPONENT_KEY)) {
            ItemEditorModel.ensureComponentsTag(compound).method_10566(FOOD_COMPONENT_KEY, (class_2520)this.buildMinimalFoodNbt());
        }
        context.setTag(compound);
        class_1799 parsed = class_1799.method_57359((class_7225.class_7874)registryAccess, (class_2487)compound);
        if (!parsed.method_7960()) {
            if (this.desiredFoodEnabled && parsed.method_57824(class_9334.field_50075) == null) {
                this.writeFoodComponent(parsed);
            } else if (!this.desiredFoodEnabled && parsed.method_57824(class_9334.field_50075) != null) {
                parsed.method_57381(class_9334.field_50075);
            }
            context.setItemStack(parsed);
            this.foodState.loadFrom(parsed.method_7972());
            this.foodState.setEnabled(this.desiredFoodEnabled);
        } else {
            class_1799 fallback = stack.method_7972();
            if (this.desiredFoodEnabled && fallback.method_57824(class_9334.field_50075) == null) {
                this.writeFoodComponent(fallback);
            } else if (!this.desiredFoodEnabled && fallback.method_57824(class_9334.field_50075) != null) {
                fallback.method_57381(class_9334.field_50075);
            }
            context.setItemStack(fallback);
            this.foodState.loadFrom(fallback);
            this.foodState.setEnabled(this.desiredFoodEnabled);
        }
    }

    private class_2487 buildMinimalFoodNbt() {
        float eatSeconds;
        class_2487 food = new class_2487();
        int nutrition = Math.max(0, this.foodState.getNutrition());
        if (nutrition != this.foodState.getNutrition()) {
            this.foodState.setNutrition(nutrition);
        }
        food.method_10569("nutrition", nutrition);
        food.method_10548("saturation", Math.max(0.0f, this.foodState.getSaturation()));
        if (this.foodState.isAlwaysEat()) {
            food.method_10556("can_always_eat", true);
        }
        if ((eatSeconds = Math.max(0.05f, this.foodState.getEatSeconds())) != 1.6f) {
            food.method_10548("eat_seconds", eatSeconds);
        }
        return food;
    }

    private static class_2487 mergeComponentsPreservingUnknown(class_2487 oldRoot, class_2487 newRoot, Set<String> keysNotToCopy) {
        class_2487 merged = newRoot.method_10553();
        if (!merged.method_10573(KEY_COMPONENTS, 10)) {
            if (oldRoot != null && oldRoot.method_10573(KEY_COMPONENTS, 10)) {
                merged.method_10566(KEY_COMPONENTS, (class_2520)oldRoot.method_10562(KEY_COMPONENTS).method_10553());
            }
            return merged;
        }
        class_2487 newComps = merged.method_10562(KEY_COMPONENTS);
        if (oldRoot != null && oldRoot.method_10573(KEY_COMPONENTS, 10)) {
            class_2487 oldComps = oldRoot.method_10562(KEY_COMPONENTS);
            for (String oldKey : oldComps.method_10541()) {
                class_2487 c;
                class_2520 oldVal;
                boolean isUnitLike;
                boolean respectDeletion;
                if (oldKey.startsWith(TOMBSTONE_PREFIX) || keysNotToCopy != null && keysNotToCopy.contains(oldKey)) continue;
                boolean explicitlyRemoved = newComps.method_10545(TOMBSTONE_PREFIX + oldKey);
                boolean explicitlySet = newComps.method_10545(oldKey);
                if (explicitlyRemoved || explicitlySet || (respectDeletion = (isUnitLike = (oldVal = oldComps.method_10580(oldKey)) instanceof class_2487 && (c = (class_2487)oldVal).method_33133()) || DELETE_IF_ABSENT_KEYS.contains(oldKey))) continue;
                newComps.method_10566(oldKey, oldVal.method_10707());
            }
        }
        return merged;
    }

    protected class_7225.class_7874 getRegistryAccess() {
        return ClientUtil.registryAccess();
    }

    private String describeStackForLogs(class_1799 stack) {
        if (stack.method_7960()) {
            return "<empty>";
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return String.valueOf(id) + " tag=" + this.stackTagForLogs(stack);
    }

    private String stackTagForLogs(class_1799 stack) {
        if (stack.method_7960()) {
            return "<empty>";
        }
        class_2520 saved = stack.method_57376(this.getRegistryAccess(), (class_2520)new class_2487());
        if (!(saved instanceof class_2487)) {
            return "<empty>";
        }
        class_2487 compound = (class_2487)saved;
        Set<String> doNotCopyBack = this.desiredFoodEnabled ? Collections.emptySet() : Set.of(FOOD_COMPONENT_KEY);
        class_2487 merged = ItemEditorModel.mergeComponentsPreservingUnknown(this.getContext().getTag(), compound.method_10553(), doNotCopyBack);
        return merged.toString();
    }

    private static class_2487 copyLegacyPayload(class_2487 container) {
        if (container == null || !container.method_10573(KEY_LEGACY_TAG, 10)) {
            return null;
        }
        class_2487 legacy = container.method_10562(KEY_LEGACY_TAG);
        if (legacy.method_33133()) {
            return null;
        }
        return legacy.method_10553();
    }

    private static boolean hasComponent(class_2487 root, String key) {
        return root != null && root.method_10573(KEY_COMPONENTS, 10) && root.method_10562(KEY_COMPONENTS).method_10545(key);
    }

    private static class_2487 ensureComponentsTag(class_2487 root) {
        if (!root.method_10573(KEY_COMPONENTS, 10)) {
            root.method_10566(KEY_COMPONENTS, (class_2520)new class_2487());
        }
        return root.method_10562(KEY_COMPONENTS);
    }
}

