/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.block;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.BlockEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.block.BlockEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ItemContainerSlotEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7225;

public class BlockContainerGridCategoryModel
extends BlockEditorCategoryModel {
    public BlockContainerGridCategoryModel(BlockEditorModel parent) {
        super((class_2561)ModTexts.CONTAINER_GRID, parent);
    }

    @Override
    protected void setupEntries() {
        class_2487 tag = this.getData();
        if (tag == null) {
            return;
        }
        List<class_1799> slots = this.readItemSlots(tag);
        if (slots.isEmpty()) {
            this.getEntries().add(new ItemContainerSlotEntryModel(this, class_1799.field_8037));
            return;
        }
        for (class_1799 st : slots) {
            this.getEntries().add(new ItemContainerSlotEntryModel(this, st));
        }
    }

    private List<class_1799> readItemSlots(class_2487 tag) {
        int slot;
        class_2487 it;
        int i;
        ArrayList<class_1799> out = new ArrayList<class_1799>();
        if (!tag.method_10573("Items", 9)) {
            return out;
        }
        class_2499 list = tag.method_10554("Items", 10);
        int maxSlot = -1;
        for (i = 0; i < list.size(); ++i) {
            it = list.method_10602(i);
            int n = slot = it.method_10573("Slot", 1) ? Byte.toUnsignedInt(it.method_10571("Slot")) : i;
            if (slot <= maxSlot) continue;
            maxSlot = slot;
        }
        if (maxSlot < 0) {
            return out;
        }
        for (i = 0; i <= maxSlot; ++i) {
            out.add(class_1799.field_8037);
        }
        for (i = 0; i < list.size(); ++i) {
            it = list.method_10602(i);
            slot = it.method_10573("Slot", 1) ? Byte.toUnsignedInt(it.method_10571("Slot")) : i;
            class_1799 parsed = class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)it);
            if (slot >= 0 && slot < out.size()) {
                out.set(slot, parsed);
                continue;
            }
            out.add(parsed);
        }
        return out;
    }

    @Override
    public boolean canAddEntryInList() {
        return true;
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return new ItemContainerSlotEntryModel(this, class_1799.field_8037);
    }

    @Override
    public void apply() {
        super.apply();
        class_2487 tag = this.getData();
        if (tag == null) {
            return;
        }
        class_2499 items = new class_2499();
        int idx = 0;
        for (EntryModel model : this.getEntries()) {
            if (!(model instanceof ItemContainerSlotEntryModel)) continue;
            ItemContainerSlotEntryModel entry = (ItemContainerSlotEntryModel)model;
            class_1799 stack = entry.getItemStack();
            if (stack.method_7960()) {
                ++idx;
                continue;
            }
            class_2487 itemTag = (class_2487)stack.method_57376(ClientUtil.registryAccess(), (class_2520)new class_2487());
            itemTag.method_10567("Slot", (byte)idx);
            items.add((Object)itemTag);
            ++idx;
        }
        if (items.isEmpty()) {
            tag.method_10551("Items");
        } else {
            tag.method_10566("Items", (class_2520)items);
        }
    }
}

