/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.block;

import com.github.rinorsi.cadeditor.client.screen.model.BlockEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.block.BlockEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.LootTableSelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class BlockContainerLootCategoryModel
extends BlockEditorCategoryModel {
    private LootTableSelectionEntryModel tableEntry;
    private StringEntryModel seedEntry;

    public BlockContainerLootCategoryModel(BlockEditorModel parent) {
        super((class_2561)ModTexts.CONTAINER_LOOT, parent);
    }

    @Override
    protected void setupEntries() {
        class_2487 tag = this.getData();
        String table = "";
        String seed = "";
        if (tag != null) {
            if (tag.method_10573("LootTable", 8)) {
                table = tag.method_10558("LootTable");
            }
            if (tag.method_10573("LootTableSeed", 4)) {
                seed = Long.toString(tag.method_10537("LootTableSeed"));
            }
        }
        this.tableEntry = new LootTableSelectionEntryModel(this, table, v -> {});
        this.seedEntry = new StringEntryModel((CategoryModel)this, ModTexts.SEED, seed, v -> {});
        this.getEntries().add(this.tableEntry);
        this.getEntries().add(this.seedEntry);
    }

    @Override
    public void apply() {
        super.apply();
        class_2487 tag = this.getData();
        if (tag == null) {
            return;
        }
        String table = Optional.ofNullable((String)this.tableEntry.getValue()).orElse("").trim();
        String seedRaw = Optional.ofNullable((String)this.seedEntry.getValue()).orElse("").trim();
        if (table.isEmpty()) {
            tag.method_10551("LootTable");
            tag.method_10551("LootTableSeed");
            return;
        }
        tag.method_10582("LootTable", table);
        if (seedRaw.isEmpty()) {
            tag.method_10551("LootTableSeed");
        } else {
            try {
                long s = Long.parseLong(seedRaw);
                tag.method_10544("LootTableSeed", s);
            }
            catch (Exception ex) {
                this.seedEntry.setValid(false);
                return;
            }
        }
        if (tag.method_10573("Items", 9)) {
            tag.method_10551("Items");
        }
    }
}

