/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.EntityEquipmentEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class EntityEquipmentCategoryModel
extends EntityCategoryModel {
    private static final String HAND_ITEMS_TAG = "HandItems";
    private static final String HAND_DROPS_TAG = "HandDropChances";
    private static final String ARMOR_ITEMS_TAG = "ArmorItems";
    private static final String ARMOR_DROPS_TAG = "ArmorDropChances";
    public static final float DEFAULT_DROP_CHANCE = 0.085f;
    public static final float DROP_EPSILON = 1.0E-4f;
    private final List<EntityEquipmentEntryModel> equipmentEntries = new ArrayList<EntityEquipmentEntryModel>();

    public EntityEquipmentCategoryModel(EntityEditorModel editor) {
        super((class_2561)ModTexts.ENTITY_EQUIPMENT, editor);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().clear();
        this.equipmentEntries.clear();
        for (Slot slot : Slot.values()) {
            class_1799 stack = this.readItem(slot);
            float dropChance = this.readDropChance(slot);
            EntityEquipmentEntryModel entry = new EntityEquipmentEntryModel(this, slot, stack, dropChance);
            this.equipmentEntries.add(entry);
            this.getEntries().add(entry);
        }
    }

    private class_1799 readItem(Slot slot) {
        class_2487 data = this.getData();
        if (!data.method_10573(slot.itemListTag, 9)) {
            return class_1799.field_8037;
        }
        class_2499 list = data.method_10554(slot.itemListTag, 10);
        if (slot.index >= list.size()) {
            return class_1799.field_8037;
        }
        class_2520 tag = list.method_10534(slot.index);
        if (!(tag instanceof class_2487)) {
            return class_1799.field_8037;
        }
        class_2487 compound = (class_2487)tag;
        return class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)compound);
    }

    private float readDropChance(Slot slot) {
        class_2487 data = this.getData();
        if (!data.method_10573(slot.dropChanceListTag, 9)) {
            return slot.defaultDropChance;
        }
        class_2499 list = data.method_10554(slot.dropChanceListTag, 5);
        if (slot.index >= list.size()) {
            return slot.defaultDropChance;
        }
        class_2520 tag = list.method_10534(slot.index);
        if (tag instanceof class_2494) {
            class_2494 floatTag = (class_2494)tag;
            return floatTag.method_10700();
        }
        return slot.defaultDropChance;
    }

    @Override
    public void apply() {
        super.apply();
        this.writeToTag();
    }

    private void writeToTag() {
        class_2499 handItems = new class_2499();
        class_2499 handDropChances = new class_2499();
        class_2499 armorItems = new class_2499();
        class_2499 armorDropChances = new class_2499();
        boolean hasHandItems = false;
        boolean hasArmorItems = false;
        boolean customHandDropChance = false;
        boolean customArmorDropChance = false;
        for (EntityEquipmentEntryModel entry : this.equipmentEntries) {
            Slot slot = entry.getSlot();
            class_2487 itemTag = entry.getItemStack().method_31574(class_1802.field_8600) ? new class_2487() : entry.createItemTag();
            class_2494 dropTag = class_2494.method_23244((float)entry.getDropChance());
            if (slot.isHand()) {
                handItems.add((Object)itemTag);
                handDropChances.add((Object)dropTag);
                if (!itemTag.method_33133()) {
                    hasHandItems = true;
                }
                if (entry.isDefaultDropChance()) continue;
                customHandDropChance = true;
                continue;
            }
            armorItems.add((Object)itemTag);
            armorDropChances.add((Object)dropTag);
            if (!itemTag.method_33133()) {
                hasArmorItems = true;
            }
            if (entry.isDefaultDropChance()) continue;
            customArmorDropChance = true;
        }
        class_2487 data = this.getData();
        if (hasHandItems) {
            data.method_10566(HAND_ITEMS_TAG, (class_2520)handItems);
        } else {
            data.method_10551(HAND_ITEMS_TAG);
        }
        if (customHandDropChance && hasHandItems) {
            data.method_10566(HAND_DROPS_TAG, (class_2520)handDropChances);
        } else {
            data.method_10551(HAND_DROPS_TAG);
        }
        if (hasArmorItems) {
            data.method_10566(ARMOR_ITEMS_TAG, (class_2520)armorItems);
        } else {
            data.method_10551(ARMOR_ITEMS_TAG);
        }
        if (customArmorDropChance && hasArmorItems) {
            data.method_10566(ARMOR_DROPS_TAG, (class_2520)armorDropChances);
        } else {
            data.method_10551(ARMOR_DROPS_TAG);
        }
    }

    public String formatDropChance(float value) {
        return String.format(Locale.ROOT, "%.3f", Float.valueOf(value));
    }

    public static enum Slot {
        MAIN_HAND("HandItems", "HandDropChances", 0, true, () -> ModTexts.MAIN_HAND.method_27661()),
        OFF_HAND("HandItems", "HandDropChances", 1, true, () -> ModTexts.OFF_HAND.method_27661()),
        FEET("ArmorItems", "ArmorDropChances", 0, false, () -> ModTexts.FEET.method_27661()),
        LEGS("ArmorItems", "ArmorDropChances", 1, false, () -> ModTexts.LEGS.method_27661()),
        CHEST("ArmorItems", "ArmorDropChances", 2, false, () -> ModTexts.CHEST.method_27661()),
        HEAD("ArmorItems", "ArmorDropChances", 3, false, () -> ModTexts.HEAD.method_27661());

        private final String itemListTag;
        private final String dropChanceListTag;
        private final int index;
        private final boolean hand;
        private final Supplier<class_5250> labelSupplier;
        private final float defaultDropChance;

        private Slot(String itemListTag, String dropChanceListTag, int index, boolean hand, Supplier<class_5250> labelSupplier) {
            this(itemListTag, dropChanceListTag, index, hand, labelSupplier, 0.085f);
        }

        private Slot(String itemListTag, String dropChanceListTag, int index, boolean hand, Supplier<class_5250> labelSupplier, float defaultDropChance) {
            this.itemListTag = itemListTag;
            this.dropChanceListTag = dropChanceListTag;
            this.index = index;
            this.hand = hand;
            this.labelSupplier = labelSupplier;
            this.defaultDropChance = defaultDropChance;
        }

        public boolean isHand() {
            return this.hand;
        }

        public class_5250 label() {
            return this.labelSupplier.get();
        }

        public float defaultDropChance() {
            return this.defaultDropChance;
        }
    }
}

