/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ReadOnlyStringEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.TextEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class EntityGeneralCategoryModel
extends EntityCategoryModel {
    private static final String HEALTH_TAG = "Health";
    private static final String ATTRIBUTES_TAG = "attributes";
    private static final String ATTRIBUTE_ID_TAG = "id";
    private static final String ATTRIBUTE_BASE_TAG = "base";
    private static final String MAX_HEALTH_ATTRIBUTE_ID = "minecraft:generic.max_health";

    public EntityGeneralCategoryModel(EntityEditorModel model) {
        super((class_2561)ModTexts.GENERAL, model);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, ModTexts.HEALTH, this.getData().method_10583(HEALTH_TAG), this::setHealth));
        this.getEntries().add(new TextEntryModel((CategoryModel)this, ModTexts.CUSTOM_NAME, this.getCustomName(), this::setCustomName));
        String playerUuid = this.resolvePlayerUuid();
        if (playerUuid != null) {
            this.getEntries().add(new ReadOnlyStringEntryModel(this, ModTexts.gui("uuid"), playerUuid));
        }
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.ALWAYS_SHOW_NAME, this.getData().method_10577("CustomNameVisible"), b -> this.putBooleanOrRemove("CustomNameVisible", (boolean)b)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.INVULNERABLE, this.getData().method_10577("Invulnerable"), b -> this.getData().method_10556("Invulnerable", b.booleanValue())));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.SILENT, this.getData().method_10577("Silent"), b -> this.putBooleanOrRemove("Silent", (boolean)b)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.NO_GRAVITY, this.getData().method_10577("NoGravity"), b -> this.putBooleanOrRemove("NoGravity", (boolean)b)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.GLOWING, this.getData().method_10577("Glowing"), b -> this.putBooleanOrRemove("Glowing", (boolean)b)));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.FIRE, this.getData().method_10568("Fire"), s -> this.getData().method_10575("Fire", s.shortValue())));
    }

    private String resolvePlayerUuid() {
        class_1297 class_12972 = this.getEntity();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return player.method_5667().toString();
        }
        class_2487 data = this.getData();
        if (data != null) {
            String uuid;
            class_2487 profile;
            class_2487 components;
            if (data.method_25928("UUID")) {
                return data.method_25926("UUID").toString();
            }
            if (data.method_10573("UUIDMost", 4) && data.method_10573("UUIDLeast", 4)) {
                return new UUID(data.method_10537("UUIDMost"), data.method_10537("UUIDLeast")).toString();
            }
            if (data.method_10573("components", 10) && (components = data.method_10562("components")).method_10573("minecraft:profile", 10) && (profile = components.method_10562("minecraft:profile")).method_10573(ATTRIBUTE_ID_TAG, 8) && !(uuid = profile.method_10558(ATTRIBUTE_ID_TAG)).isBlank()) {
                return uuid;
            }
            String id = data.method_10558(ATTRIBUTE_ID_TAG);
            if (("minecraft:player".equals(id) || "player".equals(id)) && class_310.method_1551().field_1724 != null) {
                return class_310.method_1551().field_1724.method_5667().toString();
            }
        }
        return null;
    }

    private class_5250 getCustomName() {
        String s = this.getData().method_10558("CustomName");
        if (s.isEmpty()) {
            return null;
        }
        class_5250 component = class_2561.class_2562.method_10877((String)s, (class_7225.class_7874)ClientUtil.registryAccess());
        return component == null ? null : component.method_27661();
    }

    private void setCustomName(class_5250 value) {
        if (value != null && !value.getString().isEmpty()) {
            this.getData().method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)value, (class_7225.class_7874)ClientUtil.registryAccess()));
        } else if (this.getData().method_10558("CustomName").isEmpty()) {
            this.getData().method_10551("CustomName");
        } else {
            this.getData().method_10582("CustomName", "");
        }
    }

    private void putBooleanOrRemove(String tagName, boolean value) {
        if (value) {
            this.getData().method_10556(tagName, true);
        } else {
            this.getData().method_10551(tagName);
        }
    }

    private void setHealth(float health) {
        this.getData().method_10548(HEALTH_TAG, health);
        this.updateMaxHealthAttribute(health);
    }

    private void updateMaxHealthAttribute(float health) {
        class_2487 data = this.getData();
        class_2499 attributes = data.method_10554(ATTRIBUTES_TAG, 10);
        class_2487 maxHealthAttribute = null;
        for (int i = 0; i < attributes.size(); ++i) {
            class_2487 attribute = attributes.method_10602(i);
            if (!MAX_HEALTH_ATTRIBUTE_ID.equals(attribute.method_10558(ATTRIBUTE_ID_TAG))) continue;
            maxHealthAttribute = attribute;
            break;
        }
        if (maxHealthAttribute == null) {
            maxHealthAttribute = new class_2487();
            maxHealthAttribute.method_10582(ATTRIBUTE_ID_TAG, MAX_HEALTH_ATTRIBUTE_ID);
            attributes.add((Object)maxHealthAttribute);
        }
        maxHealthAttribute.method_10549(ATTRIBUTE_BASE_TAG, (double)health);
        data.method_10566(ATTRIBUTES_TAG, (class_2520)attributes);
    }
}

