/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ActionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.DoubleEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntityEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.EntitySingleItemEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class EntityMountCategoryModel
extends EntityCategoryModel {
    private BooleanEntryModel saddledEntry;
    private EntitySingleItemEntryModel saddleItemEntry;
    private BooleanEntryModel chestedEntry;
    private StringEntryModel leashHolderEntry;
    private BooleanEntryModel leashAnchorEntry;
    private DoubleEntryModel leashXEntry;
    private DoubleEntryModel leashYEntry;
    private DoubleEntryModel leashZEntry;
    private IntegerEntryModel temperEntry;
    private IntegerEntryModel strengthEntry;
    private int passengerListStart = -1;

    public EntityMountCategoryModel(EntityEditorModel editor) {
        super((class_2561)ModTexts.ENTITY_MOUNT, editor);
    }

    @Override
    protected void setupEntries() {
        class_2487 data = this.getData();
        if (data == null) {
            return;
        }
        this.temperEntry = null;
        this.strengthEntry = null;
        boolean saddled = data.method_10577("Saddled") || data.method_10577("Saddle");
        class_1799 saddleStack = this.readSaddleItem(data);
        boolean chestedHorse = data.method_10577("ChestedHorse");
        String leashHolder = this.readLeashHolder(data);
        class_2487 leashTag = data.method_10573("Leash", 10) ? data.method_10562("Leash").method_10553() : null;
        boolean hasLeashAnchor = leashTag != null && (leashTag.method_10545("X") || leashTag.method_10545("Y") || leashTag.method_10545("Z"));
        double leashX = leashTag != null && leashTag.method_10545("X") ? leashTag.method_10574("X") : 0.0;
        double leashY = leashTag != null && leashTag.method_10545("Y") ? leashTag.method_10574("Y") : 0.0;
        double leashZ = leashTag != null && leashTag.method_10545("Z") ? leashTag.method_10574("Z") : 0.0;
        this.saddledEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.SADDLED, saddled, value -> {});
        this.saddleItemEntry = new EntitySingleItemEntryModel(this, ModTexts.SADDLE_ITEM, saddleStack);
        this.chestedEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.CHESTED_HORSE, chestedHorse, value -> {});
        this.leashHolderEntry = new StringEntryModel((CategoryModel)this, ModTexts.LEASH_HOLDER, leashHolder, value -> {});
        this.leashAnchorEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.LEASH_ANCHOR, hasLeashAnchor, value -> {});
        this.leashXEntry = new DoubleEntryModel((CategoryModel)this, ModTexts.LEASH_POS_X, leashX, value -> {});
        this.leashYEntry = new DoubleEntryModel((CategoryModel)this, ModTexts.LEASH_POS_Y, leashY, value -> {});
        this.leashZEntry = new DoubleEntryModel((CategoryModel)this, ModTexts.LEASH_POS_Z, leashZ, value -> {});
        this.getEntries().add(this.saddledEntry);
        this.getEntries().add(this.chestedEntry);
        this.getEntries().add(this.saddleItemEntry);
        if (this.hasTemper()) {
            int temper = data.method_10573("Temper", 3) ? data.method_10550("Temper") : 0;
            this.temperEntry = new IntegerEntryModel((CategoryModel)this, ModTexts.MOUNT_TEMPER, temper, value -> {});
            this.getEntries().add(this.temperEntry);
        }
        if (this.hasStrength()) {
            int strength = data.method_10573("Strength", 3) ? data.method_10550("Strength") : 1;
            this.strengthEntry = new IntegerEntryModel((CategoryModel)this, ModTexts.MOUNT_STRENGTH, strength, value -> {});
            this.getEntries().add(this.strengthEntry);
        }
        this.getEntries().add(this.leashHolderEntry);
        this.getEntries().add(new ActionEntryModel(this, (class_2561)ModTexts.USE_SELF_UUID, this::setLeashHolderSelf));
        this.getEntries().add(this.leashAnchorEntry);
        this.getEntries().add(this.leashXEntry);
        this.getEntries().add(this.leashYEntry);
        this.getEntries().add(this.leashZEntry);
        this.passengerListStart = this.getEntries().size();
        class_2499 passengers = data.method_10554("Passengers", 10);
        for (class_2520 tag : passengers) {
            if (!(tag instanceof class_2487)) continue;
            class_2487 passengerTag = (class_2487)tag;
            this.getEntries().add(this.createPassengerEntry(passengerTag));
        }
    }

    private void setLeashHolderSelf() {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        this.leashHolderEntry.setValue(class_310.method_1551().field_1724.method_5667().toString());
    }

    private EntityEntryModel createPassengerEntry(class_2487 passengerTag) {
        class_1299 type = null;
        String id = passengerTag.method_10558("id");
        if (!id.isEmpty()) {
            type = class_1299.method_5898((String)id).orElse(null);
        }
        return new EntityEntryModel((CategoryModel)this, type, passengerTag, value -> {});
    }

    private class_1799 readSaddleItem(class_2487 data) {
        if (data.method_10573("SaddleItem", 10)) {
            class_2487 saddleTag = data.method_10562("SaddleItem");
            return class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)saddleTag);
        }
        return class_1799.field_8037;
    }

    private String readLeashHolder(class_2487 data) {
        String value;
        if (data.method_25928("LeashHolder")) {
            return data.method_25926("LeashHolder").toString();
        }
        if (data.method_10573("LeashHolder", 8) && !(value = data.method_10558("LeashHolder")).isBlank()) {
            return value;
        }
        return "";
    }

    @Override
    public int getEntryListStart() {
        return this.passengerListStart;
    }

    @Override
    public boolean canAddEntryInList() {
        return true;
    }

    @Override
    public EntityEntryModel createNewListEntry() {
        return this.createPassengerEntry(new class_2487());
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.PASSENGERS;
    }

    @Override
    public void apply() {
        super.apply();
        class_2487 data = this.getData();
        if (data == null) {
            return;
        }
        this.applySaddleData(data);
        this.applyChestData(data);
        this.applyMountStats(data);
        this.applyLeashData(data);
        this.applyPassengers(data);
    }

    private void applySaddleData(class_2487 data) {
        boolean saddled = Boolean.TRUE.equals(this.saddledEntry.getValue());
        class_1799 saddleStack = this.saddleItemEntry.getItemStack();
        if (saddled && saddleStack.method_7960()) {
            saddleStack = new class_1799((class_1935)class_1802.field_8175);
            this.saddleItemEntry.setItemStack(saddleStack.method_7972());
        }
        if (saddled) {
            data.method_10556("Saddle", true);
            data.method_10556("Saddled", true);
            class_2487 saddleTag = (class_2487)saddleStack.method_57376(ClientUtil.registryAccess(), (class_2520)new class_2487());
            data.method_10566("SaddleItem", (class_2520)saddleTag);
        } else {
            data.method_10551("Saddle");
            data.method_10551("Saddled");
            data.method_10551("SaddleItem");
            if (!saddleStack.method_7960()) {
                this.saddleItemEntry.setItemStack(class_1799.field_8037);
            }
        }
    }

    private void applyMountStats(class_2487 data) {
        Integer value;
        if (this.temperEntry != null) {
            value = (Integer)this.temperEntry.getValue();
            if (value == null) {
                data.method_10551("Temper");
            } else {
                data.method_10569("Temper", this.clamp(value, 0, 100));
            }
        }
        if (this.strengthEntry != null) {
            value = (Integer)this.strengthEntry.getValue();
            if (value == null) {
                data.method_10551("Strength");
            } else {
                data.method_10569("Strength", this.clamp(value, 1, 5));
            }
        }
    }

    private void applyChestData(class_2487 data) {
        if (Boolean.TRUE.equals(this.chestedEntry.getValue())) {
            data.method_10556("ChestedHorse", true);
        } else {
            data.method_10551("ChestedHorse");
        }
    }

    private void applyLeashData(class_2487 data) {
        String leashHolder = EntityMountCategoryModel.normalize((String)this.leashHolderEntry.getValue());
        if (leashHolder.isEmpty()) {
            data.method_10551("LeashHolder");
        } else if (EntityMountCategoryModel.isUuidString(leashHolder)) {
            data.method_25927("LeashHolder", UUID.fromString(leashHolder));
        } else {
            data.method_10582("LeashHolder", leashHolder);
        }
        boolean anchorEnabled = Boolean.TRUE.equals(this.leashAnchorEntry.getValue());
        if (!anchorEnabled) {
            data.method_10551("Leash");
            return;
        }
        class_2487 leash = data.method_10573("Leash", 10) ? data.method_10562("Leash") : new class_2487();
        leash.method_10549("X", ((Double)this.leashXEntry.getValue()).doubleValue());
        leash.method_10549("Y", ((Double)this.leashYEntry.getValue()).doubleValue());
        leash.method_10549("Z", ((Double)this.leashZEntry.getValue()).doubleValue());
        data.method_10566("Leash", (class_2520)leash);
    }

    private void applyPassengers(class_2487 data) {
        class_2499 passengers = new class_2499();
        int listStart = this.getEntryListStart();
        if (listStart >= 0) {
            for (int i = listStart; i < this.getEntries().size(); ++i) {
                EntityEntryModel passenger;
                class_2487 tag;
                EntryModel entry = (EntryModel)this.getEntries().get(i);
                if (!(entry instanceof EntityEntryModel) || (tag = (passenger = (EntityEntryModel)entry).copyValue()).method_33133()) continue;
                passengers.add((Object)tag);
            }
        }
        if (passengers.isEmpty()) {
            data.method_10551("Passengers");
        } else {
            data.method_10566("Passengers", (class_2520)passengers);
        }
    }

    private static String normalize(String value) {
        return value == null ? "" : value.trim();
    }

    private static boolean isUuidString(String value) {
        if (value == null || value.isBlank()) {
            return false;
        }
        try {
            UUID.fromString(value);
            return true;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    private boolean hasTemper() {
        if (this.getEntity() instanceof class_1496) {
            return true;
        }
        class_2487 data = this.getData();
        return data != null && data.method_10573("Temper", 3);
    }

    private boolean hasStrength() {
        if (this.getEntity() instanceof class_1501) {
            return true;
        }
        class_2487 data = this.getData();
        return data != null && data.method_10573("Strength", 3);
    }

    private int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

