/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class EntityStatusEffectsCategoryModel
extends EntityCategoryModel {
    private static final class_2561 TITLE = class_2561.method_43471((String)"cadeditor.gui.player_effects");
    private static final String EFFECTS_TAG = "ActiveEffects";

    public EntityStatusEffectsCategoryModel(EntityEditorModel editor) {
        super(TITLE, editor);
    }

    @Override
    protected void setupEntries() {
        class_2499 effects = this.ensureEntityTag().method_10554(EFFECTS_TAG, 10);
        for (class_2520 element : effects) {
            if (!(element instanceof class_2487)) continue;
            class_2487 compound = (class_2487)element;
            this.getEntries().add(this.createEffectEntry(compound));
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    protected boolean canAddEntryInList() {
        return true;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createEffectEntry(new class_2487());
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    public void apply() {
        super.apply();
        class_2499 list = new class_2499();
        for (EntryModel entry : this.getEntries()) {
            PotionEffectEntryModel effect;
            String id;
            if (!(entry instanceof PotionEffectEntryModel) || (id = (String)(effect = (PotionEffectEntryModel)entry).getValue()) == null || id.isBlank()) continue;
            list.add((Object)effect.toCompoundTag());
        }
        class_2487 data = this.ensureEntityTag();
        if (list.isEmpty()) {
            data.method_10551(EFFECTS_TAG);
        } else {
            data.method_10566(EFFECTS_TAG, (class_2520)list);
        }
    }

    private PotionEffectEntryModel createEffectEntry(class_2487 tag) {
        String id = "";
        int amplifier = 0;
        int duration = 20;
        boolean ambient = false;
        boolean showParticles = true;
        boolean showIcon = true;
        if (tag != null) {
            if (tag.method_10573("id", 8)) {
                id = tag.method_10558("id");
            } else if (tag.method_10573("Id", 1)) {
                id = Integer.toString(Byte.toUnsignedInt(tag.method_10571("Id")));
            }
            int n = amplifier = tag.method_10573("amplifier", 3) ? tag.method_10550("amplifier") : tag.method_10550("Amplifier");
            if (tag.method_10573("duration", 3)) {
                duration = Math.max(1, tag.method_10550("duration"));
            } else if (tag.method_10573("Duration", 3)) {
                duration = Math.max(1, tag.method_10550("Duration"));
            }
            ambient = tag.method_10573("ambient", 1) ? tag.method_10577("ambient") : tag.method_10577("Ambient");
            boolean bl = showParticles = !tag.method_10573("show_particles", 1) || tag.method_10577("show_particles");
            if (tag.method_10573("ShowParticles", 1)) {
                showParticles = tag.method_10577("ShowParticles");
            }
            boolean bl2 = showIcon = !tag.method_10573("show_icon", 1) || tag.method_10577("show_icon");
            if (tag.method_10573("ShowIcon", 1)) {
                showIcon = tag.method_10577("ShowIcon");
            }
        }
        return new PotionEffectEntryModel(this, id, amplifier, duration, ambient, showParticles, showIcon, updated -> {});
    }

    private class_2487 ensureEntityTag() {
        EntityEditorContext context = this.getContext();
        class_2487 data = context.getTag();
        if (data == null) {
            data = new class_2487();
            context.setTag(data);
        }
        return data;
    }
}

