/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ActionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class EntityTamingCategoryModel
extends EntityCategoryModel {
    private BooleanEntryModel tameEntry;
    private BooleanEntryModel sittingEntry;
    private BooleanEntryModel sittingPoseEntry;
    private StringEntryModel ownerNameEntry;
    private StringEntryModel ownerUuidEntry;

    public EntityTamingCategoryModel(EntityEditorModel model) {
        super((class_2561)ModTexts.ENTITY_TAMING, model);
    }

    @Override
    protected void setupEntries() {
        class_2487 data = this.getData();
        if (data == null) {
            return;
        }
        boolean tame = data.method_10577("Tame");
        boolean sitting = data.method_10577("Sitting");
        boolean inSittingPose = data.method_10577("InSittingPose");
        String ownerName = this.readOwnerName(data);
        String ownerUuid = this.readOwnerUuid(data);
        this.tameEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.TAME, tame, value -> {});
        this.ownerNameEntry = new StringEntryModel((CategoryModel)this, ModTexts.OWNER_NAME, ownerName, value -> {});
        this.ownerUuidEntry = new StringEntryModel((CategoryModel)this, ModTexts.OWNER_UUID, ownerUuid, value -> {});
        this.sittingEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.SITTING, sitting, value -> {});
        this.sittingPoseEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.IN_SITTING_POSE, inSittingPose, value -> {});
        this.getEntries().add(this.tameEntry);
        this.getEntries().add(this.ownerNameEntry);
        this.getEntries().add(this.ownerUuidEntry);
        this.getEntries().add(new ActionEntryModel(this, (class_2561)ModTexts.USE_SELF_UUID, this::useClientUuid));
        this.getEntries().add(this.sittingEntry);
        this.getEntries().add(this.sittingPoseEntry);
    }

    private void useClientUuid() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        UUID uuid = player.method_5667();
        this.ownerUuidEntry.setValue(uuid.toString());
        this.tameEntry.setValue(true);
    }

    private String readOwnerName(class_2487 data) {
        String value;
        if (data.method_10573("Owner", 8) && !EntityTamingCategoryModel.isUuidString(value = data.method_10558("Owner"))) {
            return value;
        }
        if (data.method_10573("OwnerName", 8)) {
            return data.method_10558("OwnerName");
        }
        return "";
    }

    private String readOwnerUuid(class_2487 data) {
        String raw;
        if (data.method_25928("OwnerUUID")) {
            return data.method_25926("OwnerUUID").toString();
        }
        if (data.method_25928("Owner")) {
            return data.method_25926("Owner").toString();
        }
        if (data.method_10573("OwnerUUIDMost", 4) && data.method_10573("OwnerUUIDLeast", 4)) {
            return new UUID(data.method_10537("OwnerUUIDMost"), data.method_10537("OwnerUUIDLeast")).toString();
        }
        if (data.method_10573("OwnerUUID", 8)) {
            return data.method_10558("OwnerUUID");
        }
        if (data.method_10573("Owner", 8) && EntityTamingCategoryModel.isUuidString(raw = data.method_10558("Owner"))) {
            return raw;
        }
        return "";
    }

    private static boolean isUuidString(String value) {
        if (value == null || value.isBlank()) {
            return false;
        }
        try {
            UUID.fromString(value);
            return true;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Override
    public void apply() {
        boolean hasOwnerData;
        super.apply();
        class_2487 data = this.getData();
        if (data == null) {
            return;
        }
        boolean tame = Boolean.TRUE.equals(this.tameEntry.getValue());
        String ownerName = EntityTamingCategoryModel.normalize((String)this.ownerNameEntry.getValue());
        String ownerUuid = EntityTamingCategoryModel.normalize((String)this.ownerUuidEntry.getValue());
        boolean bl = hasOwnerData = !ownerName.isEmpty() || !ownerUuid.isEmpty();
        if (!hasOwnerData) {
            tame = false;
        }
        this.applyTameState(data, tame);
        this.applyOwnerName(data, ownerName);
        this.applyOwnerUuid(data, ownerUuid);
        if (!tame) {
            this.removeBooleanTag(data, "Sitting");
            this.removeBooleanTag(data, "InSittingPose");
        } else {
            this.applyBooleanTag(data, "Sitting", Boolean.TRUE.equals(this.sittingEntry.getValue()));
            this.applyBooleanTag(data, "InSittingPose", Boolean.TRUE.equals(this.sittingPoseEntry.getValue()));
        }
    }

    private void applyTameState(class_2487 data, boolean tame) {
        if (tame) {
            data.method_10556("Tame", true);
        } else {
            data.method_10551("Tame");
        }
    }

    private void applyOwnerName(class_2487 data, String ownerName) {
        if (ownerName.isEmpty()) {
            data.method_10551("OwnerName");
            if (data.method_10573("Owner", 8) && !EntityTamingCategoryModel.isUuidString(data.method_10558("Owner"))) {
                data.method_10551("Owner");
            }
            return;
        }
        data.method_10582("Owner", ownerName);
        data.method_10582("OwnerName", ownerName);
    }

    private void applyOwnerUuid(class_2487 data, String ownerUuid) {
        this.removeOwnerUuid(data);
        if (ownerUuid.isEmpty()) {
            return;
        }
        if (EntityTamingCategoryModel.isUuidString(ownerUuid)) {
            UUID uuid = UUID.fromString(ownerUuid);
            data.method_25927("OwnerUUID", uuid);
            data.method_25927("Owner", uuid);
        } else {
            data.method_10582("OwnerUUID", ownerUuid);
        }
    }

    private void removeOwnerUuid(class_2487 data) {
        if (data.method_25928("OwnerUUID") || data.method_10573("OwnerUUID", 8)) {
            data.method_10551("OwnerUUID");
        }
        if (data.method_10573("OwnerUUIDMost", 4)) {
            data.method_10551("OwnerUUIDMost");
        }
        if (data.method_10573("OwnerUUIDLeast", 4)) {
            data.method_10551("OwnerUUIDLeast");
        }
        if (data.method_25928("Owner") || data.method_10573("Owner", 8) && EntityTamingCategoryModel.isUuidString(data.method_10558("Owner"))) {
            data.method_10551("Owner");
        }
    }

    private void applyBooleanTag(class_2487 data, String key, boolean value) {
        if (value) {
            data.method_10556(key, true);
        } else {
            this.removeBooleanTag(data, key);
        }
    }

    private void removeBooleanTag(class_2487 data, String key) {
        if (data.method_10545(key)) {
            data.method_10551(key);
        }
    }

    private static String normalize(String value) {
        return value == null ? "" : value.trim();
    }
}

