/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerProfessionSelectionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerTypeSelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class EntityVillagerDataCategoryModel
extends EntityCategoryModel {
    private static final String VILLAGER_DATA_TAG = "VillagerData";
    private String professionId = "minecraft:none";
    private String typeId = "minecraft:plains";
    private int level = 1;

    public EntityVillagerDataCategoryModel(EntityEditorModel editor) {
        super((class_2561)ModTexts.VILLAGER_DATA, editor);
    }

    @Override
    protected void setupEntries() {
        class_2487 data = this.getData();
        class_2487 villagerData = data.method_10573(VILLAGER_DATA_TAG, 10) ? data.method_10562(VILLAGER_DATA_TAG) : new class_2487();
        this.professionId = EntityVillagerDataCategoryModel.normalizeId(villagerData.method_10558("profession"), "minecraft:none");
        this.typeId = EntityVillagerDataCategoryModel.normalizeId(villagerData.method_10558("type"), "minecraft:plains");
        this.level = villagerData.method_10573("level", 3) ? villagerData.method_10550("level") : 1;
        this.getEntries().add(new VillagerProfessionSelectionEntryModel((CategoryModel)this, ModTexts.VILLAGER_PROFESSION, this.professionId, value -> {
            this.professionId = EntityVillagerDataCategoryModel.normalizeId(value, "minecraft:none");
        }));
        this.getEntries().add(new VillagerTypeSelectionEntryModel((CategoryModel)this, ModTexts.VILLAGER_TYPE, this.typeId, value -> {
            this.typeId = EntityVillagerDataCategoryModel.normalizeId(value, "minecraft:plains");
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.VILLAGER_LEVEL, EntityVillagerDataCategoryModel.clampLevel(this.level), value -> {
            this.level = EntityVillagerDataCategoryModel.clampLevel(value);
        }, value -> value >= 1 && value <= 5));
    }

    @Override
    public void apply() {
        super.apply();
        this.writeVillagerData();
    }

    private void writeVillagerData() {
        class_2487 data = this.getData();
        class_2487 villagerData = data.method_10573(VILLAGER_DATA_TAG, 10) ? data.method_10562(VILLAGER_DATA_TAG) : new class_2487();
        villagerData.method_10582("profession", EntityVillagerDataCategoryModel.normalizeId(this.professionId, "minecraft:none"));
        villagerData.method_10582("type", EntityVillagerDataCategoryModel.normalizeId(this.typeId, "minecraft:plains"));
        villagerData.method_10569("level", EntityVillagerDataCategoryModel.clampLevel(this.level));
        data.method_10566(VILLAGER_DATA_TAG, (class_2520)villagerData);
    }

    private static String normalizeId(String value, String defaultValue) {
        Object result;
        Object object = result = value == null || value.isBlank() ? defaultValue : value;
        if (!((String)result).contains(":")) {
            result = "minecraft:" + (String)result;
        }
        return result;
    }

    private static int clampLevel(int level) {
        if (level < 1) {
            return 1;
        }
        if (level > 5) {
            return 5;
        }
        return level;
    }
}

