/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.AddListEntryEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerTradeEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerTradeItemsEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.VillagerTradeValuesEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class EntityVillagerTradeCategoryModel
extends EntityCategoryModel {
    private static final String OFFERS_TAG = "Offers";
    private static final String RECIPES_TAG = "Recipes";
    private int tradeListStartIndex = -1;
    private class_2487 offersExtra = new class_2487();
    private final List<VillagerTradeEntryModel> tradeEntries = new ArrayList<VillagerTradeEntryModel>();

    public EntityVillagerTradeCategoryModel(EntityEditorModel editor) {
        super((class_2561)ModTexts.VILLAGER_TRADES, editor);
    }

    @Override
    protected void setupEntries() {
        this.tradeListStartIndex = 0;
        this.tradeEntries.clear();
        class_2487 data = this.getData();
        class_2487 offers = data.method_10573(OFFERS_TAG, 10) ? data.method_10562(OFFERS_TAG).method_10553() : new class_2487();
        this.offersExtra = offers.method_10553();
        this.offersExtra.method_10551(RECIPES_TAG);
        class_2499 recipes = offers.method_10573(RECIPES_TAG, 9) ? offers.method_10554(RECIPES_TAG, 10) : new class_2499();
        for (int i = 0; i < recipes.size(); ++i) {
            VillagerTradeEntryModel trade = new VillagerTradeEntryModel(this, recipes.method_10602(i));
            this.tradeEntries.add(trade);
            this.appendTradeEntries(trade);
        }
    }

    @Override
    public int getEntryListStart() {
        return this.tradeListStartIndex;
    }

    @Override
    protected boolean canAddEntryInList() {
        return true;
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.TRADE_ADD;
    }

    @Override
    public int getEntryHeight() {
        return 210;
    }

    @Override
    public void apply() {
        super.apply();
        this.writeOffers();
    }

    @Override
    public void addEntryInList() {
        VillagerTradeEntryModel trade = new VillagerTradeEntryModel(this, null);
        this.tradeEntries.add(trade);
        this.insertTradeEntries(this.tradeEntries.size() - 1, trade);
        this.updateEntryListIndexes();
    }

    @Override
    public void moveEntryUp(int index) {
        if (index <= 0 || index >= this.tradeEntries.size()) {
            return;
        }
        this.swapTrades(index, index - 1);
    }

    @Override
    public void moveEntryDown(int index) {
        if (index < 0 || index >= this.tradeEntries.size() - 1) {
            return;
        }
        this.swapTrades(index, index + 1);
    }

    @Override
    public void deleteEntry(int index) {
        if (index < 0 || index >= this.tradeEntries.size()) {
            return;
        }
        int baseIndex = this.getTradeItemsIndex(index);
        this.getEntries().remove(baseIndex + 1);
        this.getEntries().remove(baseIndex);
        this.tradeEntries.remove(index);
        this.updateEntryListIndexes();
    }

    @Override
    public void updateEntryListIndexes() {
        int size = this.tradeEntries.size();
        int entryCount = this.getEntries().size();
        for (int i = 0; i < size; ++i) {
            VillagerTradeEntryModel trade = this.tradeEntries.get(i);
            trade.setListSize(size);
            trade.setListIndex(i);
            int baseIndex = this.getTradeItemsIndex(i);
            if (entryCount <= baseIndex + 1) {
                return;
            }
            EntryModel itemsEntry = (EntryModel)this.getEntries().get(baseIndex);
            EntryModel valuesEntry = (EntryModel)this.getEntries().get(baseIndex + 1);
            itemsEntry.setListSize(size);
            itemsEntry.setListIndex(i);
            valuesEntry.setListSize(size);
            valuesEntry.setListIndex(i);
        }
    }

    private void writeOffers() {
        class_2499 recipeList = new class_2499();
        for (VillagerTradeEntryModel trade : this.tradeEntries) {
            if (trade.getResultItem().method_7960() || !trade.isValid()) continue;
            recipeList.add((Object)trade.toCompoundTag());
        }
        if (!recipeList.isEmpty() || !this.offersExtra.method_33133()) {
            class_2487 offers = this.offersExtra.method_10553();
            if (!recipeList.isEmpty()) {
                offers.method_10566(RECIPES_TAG, (class_2520)recipeList);
            } else {
                offers.method_10551(RECIPES_TAG);
            }
            this.getData().method_10566(OFFERS_TAG, (class_2520)offers);
        } else {
            this.getData().method_10551(OFFERS_TAG);
        }
    }

    private void appendTradeEntries(VillagerTradeEntryModel trade) {
        this.getEntries().add(new VillagerTradeItemsEntryModel(trade));
        this.getEntries().add(new VillagerTradeValuesEntryModel(trade));
    }

    private void insertTradeEntries(int tradeIndex, VillagerTradeEntryModel trade) {
        EntryModel last;
        int baseIndex = this.getTradeItemsIndex(tradeIndex);
        int size = this.getEntries().size();
        if (this.canAddEntryInList() && size > 0 && (last = (EntryModel)this.getEntries().get(size - 1)) instanceof AddListEntryEntryModel && baseIndex >= size - 1) {
            baseIndex = size - 1;
        }
        this.getEntries().add(baseIndex, new VillagerTradeItemsEntryModel(trade));
        this.getEntries().add(baseIndex + 1, new VillagerTradeValuesEntryModel(trade));
    }

    private void swapTrades(int from, int to) {
        if (from == to) {
            return;
        }
        EntryModel fromItems = (EntryModel)this.getEntries().get(this.getTradeItemsIndex(from));
        EntryModel fromValues = (EntryModel)this.getEntries().get(this.getTradeItemsIndex(from) + 1);
        EntryModel toItems = (EntryModel)this.getEntries().get(this.getTradeItemsIndex(to));
        EntryModel toValues = (EntryModel)this.getEntries().get(this.getTradeItemsIndex(to) + 1);
        this.getEntries().set(this.getTradeItemsIndex(from), toItems);
        this.getEntries().set(this.getTradeItemsIndex(from) + 1, toValues);
        this.getEntries().set(this.getTradeItemsIndex(to), fromItems);
        this.getEntries().set(this.getTradeItemsIndex(to) + 1, fromValues);
        VillagerTradeEntryModel tradeFrom = this.tradeEntries.get(from);
        this.tradeEntries.set(from, this.tradeEntries.get(to));
        this.tradeEntries.set(to, tradeFrom);
        this.updateEntryListIndexes();
    }

    private int getTradeItemsIndex(int tradeIndex) {
        return this.tradeListStartIndex + tradeIndex * 2;
    }
}

