/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity.player;

import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import net.minecraft.class_1297;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2842;
import net.minecraft.class_746;

public class EntityPlayerAbilitiesCategoryModel
extends EntityCategoryModel {
    private static final String ABILITIES_TAG = "abilities";
    private boolean invulnerable;
    private boolean mayFly;
    private boolean flying;
    private boolean mayBuild;
    private boolean instabuild;
    private float flySpeed;
    private float walkSpeed;

    public EntityPlayerAbilitiesCategoryModel(EntityEditorModel editor) {
        super((class_2561)class_2561.method_43471((String)"cadeditor.gui.player_abilities"), editor);
    }

    @Override
    protected void setupEntries() {
        class_2487 abilities = this.ensurePlayerTag().method_10562(ABILITIES_TAG);
        this.invulnerable = abilities.method_10577("invulnerable");
        this.mayFly = abilities.method_10577("mayfly");
        this.flying = abilities.method_10577("flying");
        this.mayBuild = !abilities.method_10545("mayBuild") || abilities.method_10577("mayBuild");
        this.instabuild = abilities.method_10577("instabuild");
        this.flySpeed = abilities.method_10545("flySpeed") ? abilities.method_10583("flySpeed") : 0.05f;
        this.walkSpeed = abilities.method_10545("walkSpeed") ? abilities.method_10583("walkSpeed") : 0.1f;
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.ability_invulnerable"), this.invulnerable, value -> {
            this.invulnerable = value;
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.ability_mayfly"), this.mayFly, value -> {
            this.mayFly = value;
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.ability_flying"), this.flying, value -> {
            this.flying = value;
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.ability_may_build"), this.mayBuild, value -> {
            this.mayBuild = value;
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.ability_instabuild"), this.instabuild, value -> {
            this.instabuild = value;
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.ability_walk_speed"), this.walkSpeed, value -> {
            this.walkSpeed = EntityPlayerAbilitiesCategoryModel.clampSpeed(value.floatValue());
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.ability_fly_speed"), this.flySpeed, value -> {
            this.flySpeed = EntityPlayerAbilitiesCategoryModel.clampSpeed(value.floatValue());
        }));
    }

    @Override
    public void apply() {
        super.apply();
        class_2487 data = this.ensurePlayerTag();
        class_2487 abilities = new class_2487();
        abilities.method_10556("invulnerable", this.invulnerable);
        abilities.method_10556("mayfly", this.mayFly);
        abilities.method_10556("flying", this.flying && this.mayFly);
        abilities.method_10556("mayBuild", this.mayBuild);
        abilities.method_10556("instabuild", this.instabuild);
        abilities.method_10548("walkSpeed", EntityPlayerAbilitiesCategoryModel.clampSpeed(this.walkSpeed));
        abilities.method_10548("flySpeed", EntityPlayerAbilitiesCategoryModel.clampSpeed(this.flySpeed));
        data.method_10566(ABILITIES_TAG, (class_2520)abilities);
        this.syncPlayerInstance();
    }

    private void syncPlayerInstance() {
        class_1657 p;
        class_1657 player;
        class_1297 class_12972 = this.getEntity();
        class_1657 class_16572 = player = class_12972 instanceof class_1657 ? (p = (class_1657)class_12972) : null;
        if (player == null) {
            return;
        }
        class_1656 abilities = player.method_31549();
        abilities.field_7480 = this.invulnerable;
        abilities.field_7478 = this.mayFly;
        abilities.field_7479 = this.flying && this.mayFly;
        abilities.field_7476 = this.mayBuild;
        abilities.field_7477 = this.instabuild;
        abilities.method_7250(EntityPlayerAbilitiesCategoryModel.clampSpeed(this.walkSpeed));
        abilities.method_7248(EntityPlayerAbilitiesCategoryModel.clampSpeed(this.flySpeed));
        player.method_7355();
        if (player instanceof class_746) {
            class_746 localPlayer = (class_746)player;
            if (localPlayer.field_3944 != null) {
                localPlayer.field_3944.method_52787((class_2596)new class_2842(abilities));
            }
        }
    }

    private static float clampSpeed(float value) {
        return Math.max(0.0f, Math.min(value, 1.0f));
    }

    private class_2487 ensurePlayerTag() {
        class_2487 data = this.getData();
        if (data == null) {
            data = new class_2487();
            this.getContext().setTag(data);
        }
        return data;
    }
}

