/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity.player;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.PlayerInventorySlotEntryModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class EntityPlayerEnderChestCategoryModel
extends EntityCategoryModel {
    private static final String ENDER_ITEMS_TAG = "EnderItems";
    private static final int ENDER_SLOT_COUNT = 27;
    private final List<PlayerInventorySlotEntryModel> slotEntries = new ArrayList<PlayerInventorySlotEntryModel>();

    public EntityPlayerEnderChestCategoryModel(EntityEditorModel editor) {
        super((class_2561)class_2561.method_43471((String)"cadeditor.gui.ender_chest"), editor);
    }

    @Override
    protected void setupEntries() {
        this.slotEntries.clear();
        List<class_1799> slots = this.readEnderSlots();
        for (int slot = 0; slot < slots.size(); ++slot) {
            class_5250 label = class_2561.method_43469((String)"cadeditor.gui.ender_chest.slot", (Object[])new Object[]{slot + 1});
            PlayerInventorySlotEntryModel entry = new PlayerInventorySlotEntryModel(this, (class_2561)label, slot, slots.get(slot));
            this.slotEntries.add(entry);
            this.getEntries().add(entry);
        }
    }

    @Override
    public void apply() {
        super.apply();
        this.writeEnderItems();
        this.syncPlayerInstance();
    }

    private List<class_1799> readEnderSlots() {
        ArrayList<class_1799> slots = new ArrayList<class_1799>(Collections.nCopies(27, class_1799.field_8037));
        class_2487 data = this.getData();
        if (data == null) {
            return slots;
        }
        class_2499 list = data.method_10554(ENDER_ITEMS_TAG, 10);
        for (class_2520 element : list) {
            class_2487 compound;
            int slot;
            if (!(element instanceof class_2487) || (slot = Byte.toUnsignedInt((compound = (class_2487)element).method_10571("Slot"))) < 0 || slot >= 27) continue;
            slots.set(slot, class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)compound.method_10553()));
        }
        return slots;
    }

    private void writeEnderItems() {
        class_2487 data = this.ensurePlayerTag();
        class_2499 list = new class_2499();
        for (PlayerInventorySlotEntryModel entry : this.slotEntries) {
            class_1799 stack = entry.getItemStack();
            if (stack.method_7960()) continue;
            class_2487 tag = (class_2487)stack.method_57376(ClientUtil.registryAccess(), (class_2520)new class_2487());
            tag.method_10567("Slot", (byte)entry.getSlotId());
            list.add((Object)tag);
        }
        if (!list.isEmpty()) {
            data.method_10566(ENDER_ITEMS_TAG, (class_2520)list);
        } else {
            data.method_10551(ENDER_ITEMS_TAG);
        }
    }

    private void syncPlayerInstance() {
        class_1657 player = this.resolvePlayerEntity();
        if (player == null) {
            return;
        }
        for (PlayerInventorySlotEntryModel entry : this.slotEntries) {
            player.method_7274().method_5447(entry.getSlotId(), entry.getItemStack().method_7972());
        }
    }

    private class_1657 resolvePlayerEntity() {
        class_1657 player;
        class_1297 class_12972 = this.getEntity();
        return class_12972 instanceof class_1657 ? (player = (class_1657)class_12972) : null;
    }

    private class_2487 ensurePlayerTag() {
        class_2487 data = this.getData();
        if (data == null) {
            data = new class_2487();
            this.getContext().setTag(data);
        }
        return data;
    }
}

