/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity.player;

import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.DoubleEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class EntityPlayerPositionCategoryModel
extends EntityCategoryModel {
    private double posX;
    private double posY;
    private double posZ;
    private double motionX;
    private double motionY;
    private double motionZ;
    private float rotY;
    private float rotX;
    private int fireTicks;
    private int airTicks;
    private float fallDistance;

    public EntityPlayerPositionCategoryModel(EntityEditorModel editor) {
        super((class_2561)class_2561.method_43471((String)"cadeditor.gui.player_position"), editor);
    }

    @Override
    protected void setupEntries() {
        this.readValues();
        this.getEntries().add(new DoubleEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_pos_x"), this.posX, value -> {
            this.posX = value;
        }));
        this.getEntries().add(new DoubleEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_pos_y"), this.posY, value -> {
            this.posY = value;
        }));
        this.getEntries().add(new DoubleEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_pos_z"), this.posZ, value -> {
            this.posZ = value;
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_rot_yaw"), this.rotY, value -> {
            this.rotY = value.floatValue();
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_rot_pitch"), this.rotX, value -> {
            this.rotX = value.floatValue();
        }));
        this.getEntries().add(new DoubleEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_motion_x"), this.motionX, value -> {
            this.motionX = value;
        }));
        this.getEntries().add(new DoubleEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_motion_y"), this.motionY, value -> {
            this.motionY = value;
        }));
        this.getEntries().add(new DoubleEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_motion_z"), this.motionZ, value -> {
            this.motionZ = value;
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_fire"), this.fireTicks, value -> {
            this.fireTicks = Math.max(0, value);
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_air"), this.airTicks, value -> {
            this.airTicks = Math.max(0, value);
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.player_fall_distance"), this.fallDistance, value -> {
            this.fallDistance = Math.max(0.0f, value.floatValue());
        }));
    }

    @Override
    public void apply() {
        super.apply();
        this.writeValues();
        this.syncPlayerInstance();
    }

    private void readValues() {
        class_2499 motionList;
        class_2499 rotList;
        class_2487 data = this.ensurePlayerTag();
        class_2499 posList = data.method_10554("Pos", 6);
        if (posList.size() == 3) {
            this.posX = posList.method_10611(0);
            this.posY = posList.method_10611(1);
            this.posZ = posList.method_10611(2);
        }
        if ((rotList = data.method_10554("Rotation", 5)).size() == 2) {
            this.rotY = rotList.method_10604(0);
            this.rotX = rotList.method_10604(1);
        }
        if ((motionList = data.method_10554("Motion", 6)).size() == 3) {
            this.motionX = motionList.method_10611(0);
            this.motionY = motionList.method_10611(1);
            this.motionZ = motionList.method_10611(2);
        }
        this.fireTicks = data.method_10550("Fire");
        this.airTicks = data.method_10550("Air");
        this.fallDistance = data.method_10573("FallDistance", 5) ? data.method_10583("FallDistance") : 0.0f;
    }

    private void writeValues() {
        class_2487 data = this.ensurePlayerTag();
        class_2499 pos = new class_2499();
        pos.add((Object)class_2489.method_23241((double)this.posX));
        pos.add((Object)class_2489.method_23241((double)this.posY));
        pos.add((Object)class_2489.method_23241((double)this.posZ));
        data.method_10566("Pos", (class_2520)pos);
        class_2499 rotation = new class_2499();
        rotation.add((Object)class_2494.method_23244((float)this.rotY));
        rotation.add((Object)class_2494.method_23244((float)this.rotX));
        data.method_10566("Rotation", (class_2520)rotation);
        class_2499 motion = new class_2499();
        motion.add((Object)class_2489.method_23241((double)this.motionX));
        motion.add((Object)class_2489.method_23241((double)this.motionY));
        motion.add((Object)class_2489.method_23241((double)this.motionZ));
        data.method_10566("Motion", (class_2520)motion);
        data.method_10569("Fire", Math.max(0, this.fireTicks));
        data.method_10569("Air", Math.max(0, this.airTicks));
        if (this.fallDistance > 0.0f) {
            data.method_10548("FallDistance", this.fallDistance);
        } else {
            data.method_10551("FallDistance");
        }
    }

    private void syncPlayerInstance() {
        class_1297 entity = this.getEntity();
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        player.method_5814(this.posX, this.posY, this.posZ);
        player.method_18800(this.motionX, this.motionY, this.motionZ);
        player.method_36456(this.rotY);
        player.method_36457(this.rotX);
        player.method_5847(this.rotY);
        player.method_5636(this.rotY);
        player.method_20803(Math.max(0, this.fireTicks));
        player.method_5855(Math.max(0, this.airTicks));
        player.field_6017 = Math.max(0.0f, this.fallDistance);
    }

    private class_2487 ensurePlayerTag() {
        class_2487 data = this.getData();
        if (data == null) {
            data = new class_2487();
            this.getContext().setTag(data);
        }
        return data;
    }
}

