/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity.player;

import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.mixin.FoodDataAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class EntityPlayerStatsCategoryModel
extends EntityCategoryModel {
    private static final String XP_LEVEL_TAG = "XpLevel";
    private static final String XP_TOTAL_TAG = "XpTotal";
    private static final String XP_PROGRESS_TAG = "XpP";
    private static final String FOOD_LEVEL_TAG = "foodLevel";
    private static final String FOOD_SATURATION_TAG = "foodSaturationLevel";
    private static final String FOOD_EXHAUSTION_TAG = "foodExhaustionLevel";
    private static final String ABSORPTION_TAG = "AbsorptionAmount";
    private static final String SLEEPING_TAG = "Sleeping";
    private int xpLevel;
    private int xpTotal;
    private float xpProgress;
    private int foodLevel;
    private float foodSaturation;
    private float foodExhaustion;
    private float absorption;
    private boolean sleeping;

    public EntityPlayerStatsCategoryModel(EntityEditorModel editor) {
        super((class_2561)class_2561.method_43471((String)"cadeditor.gui.player_stats"), editor);
    }

    @Override
    protected void setupEntries() {
        class_2487 data = this.ensurePlayerTag();
        this.xpLevel = data.method_10550(XP_LEVEL_TAG);
        this.xpTotal = data.method_10550(XP_TOTAL_TAG);
        this.xpProgress = data.method_10545(XP_PROGRESS_TAG) ? data.method_10583(XP_PROGRESS_TAG) : 0.0f;
        this.foodLevel = data.method_10545(FOOD_LEVEL_TAG) ? data.method_10550(FOOD_LEVEL_TAG) : 20;
        this.foodSaturation = data.method_10545(FOOD_SATURATION_TAG) ? data.method_10583(FOOD_SATURATION_TAG) : 5.0f;
        this.foodExhaustion = data.method_10545(FOOD_EXHAUSTION_TAG) ? data.method_10583(FOOD_EXHAUSTION_TAG) : 0.0f;
        this.absorption = data.method_10545(ABSORPTION_TAG) ? data.method_10583(ABSORPTION_TAG) : 0.0f;
        this.sleeping = data.method_10577(SLEEPING_TAG);
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.xp_level"), this.xpLevel, value -> {
            this.xpLevel = Math.max(0, value);
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.xp_total"), this.xpTotal, value -> {
            this.xpTotal = Math.max(0, value);
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.xp_progress"), this.xpProgress, value -> {
            this.xpProgress = EntityPlayerStatsCategoryModel.clamp(value.floatValue(), 0.0f, 1.0f);
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.food_level"), this.foodLevel, value -> {
            this.foodLevel = EntityPlayerStatsCategoryModel.clampInt(value, 0, 20);
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.food_saturation"), this.foodSaturation, value -> {
            this.foodSaturation = Math.max(0.0f, value.floatValue());
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.food_exhaustion"), this.foodExhaustion, value -> {
            this.foodExhaustion = Math.max(0.0f, value.floatValue());
        }));
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.absorption"), this.absorption, value -> {
            this.absorption = Math.max(0.0f, value.floatValue());
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, class_2561.method_43471((String)"cadeditor.gui.sleeping"), this.sleeping, value -> {
            this.sleeping = value;
        }));
    }

    @Override
    public void apply() {
        super.apply();
        class_2487 data = this.ensurePlayerTag();
        data.method_10569(XP_LEVEL_TAG, Math.max(0, this.xpLevel));
        data.method_10569(XP_TOTAL_TAG, Math.max(0, this.xpTotal));
        data.method_10548(XP_PROGRESS_TAG, EntityPlayerStatsCategoryModel.clamp(this.xpProgress, 0.0f, 1.0f));
        data.method_10569(FOOD_LEVEL_TAG, EntityPlayerStatsCategoryModel.clampInt(this.foodLevel, 0, 20));
        data.method_10548(FOOD_SATURATION_TAG, Math.max(0.0f, this.foodSaturation));
        data.method_10548(FOOD_EXHAUSTION_TAG, Math.max(0.0f, this.foodExhaustion));
        if (this.absorption > 0.0f) {
            data.method_10548(ABSORPTION_TAG, this.absorption);
        } else {
            data.method_10551(ABSORPTION_TAG);
        }
        data.method_10556(SLEEPING_TAG, this.sleeping);
        this.syncPlayerInstance();
    }

    private void syncPlayerInstance() {
        class_1657 p;
        class_1657 player;
        class_1297 class_12972 = this.getEntity();
        class_1657 class_16572 = player = class_12972 instanceof class_1657 ? (p = (class_1657)class_12972) : null;
        if (player == null) {
            return;
        }
        player.field_7520 = Math.max(0, this.xpLevel);
        player.field_7495 = Math.max(0, this.xpTotal);
        player.field_7510 = EntityPlayerStatsCategoryModel.clamp(this.xpProgress, 0.0f, 1.0f);
        class_1702 foodData = player.method_7344();
        int clampedFood = EntityPlayerStatsCategoryModel.clampInt(this.foodLevel, 0, 20);
        float clampedSaturation = Math.max(0.0f, this.foodSaturation);
        float clampedExhaustion = Math.max(0.0f, this.foodExhaustion);
        foodData.method_7580(clampedFood);
        foodData.method_7581(clampedSaturation);
        if (foodData instanceof FoodDataAccessor) {
            FoodDataAccessor accessor = (FoodDataAccessor)foodData;
            accessor.cadeditor$setExhaustionLevel(clampedExhaustion);
        } else {
            class_2487 foodSyncTag = new class_2487();
            foodSyncTag.method_10569(FOOD_LEVEL_TAG, clampedFood);
            foodSyncTag.method_10548(FOOD_SATURATION_TAG, clampedSaturation);
            foodSyncTag.method_10548(FOOD_EXHAUSTION_TAG, clampedExhaustion);
            foodData.method_7584(foodSyncTag);
        }
        player.method_6073(Math.max(0.0f, this.absorption));
        if (this.sleeping) {
            player.method_18402(player.method_24515());
        } else {
            player.method_18400();
        }
    }

    private static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    private static int clampInt(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private class_2487 ensurePlayerTag() {
        class_2487 data = this.getData();
        if (data == null) {
            data = new class_2487();
            this.getContext().setTag(data);
        }
        return data;
    }
}

