/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BlockSelectionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4550;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6538;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class ItemBlockListCategoryModel
extends ItemEditorCategoryModel {
    private final String tagName;
    private class_2499 newBlocks;

    public ItemBlockListCategoryModel(class_2561 name, ItemEditorModel editor, String tagName) {
        super(name, editor);
        this.tagName = tagName;
    }

    @Override
    protected void setupEntries() {
        class_2499 nbtList = this.getTag().method_10554(this.tagName, 8);
        if (!nbtList.isEmpty()) {
            nbtList.stream().map(class_2520::method_10714).map(this::createBlockEntry).forEach(this.getEntries()::add);
            return;
        }
        class_2487 data = this.getData();
        if (data.method_10573("components", 10)) {
            class_2487 comp;
            String key;
            class_2487 components = data.method_10562("components");
            String string = key = "CanDestroy".equals(this.tagName) ? "minecraft:can_break" : "minecraft:can_place_on";
            if (components.method_10573(key, 10) && (comp = components.method_10562(key)).method_10573("predicates", 9)) {
                class_2499 preds = comp.method_10554("predicates", 10);
                for (class_2520 predicateTag : preds) {
                    class_2487 predicate;
                    if (!(predicateTag instanceof class_2487) || !(predicate = (class_2487)predicateTag).method_10545("blocks")) continue;
                    this.readComponentBlocks(predicate.method_10580("blocks"));
                }
            }
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createBlockEntry("");
    }

    private EntryModel createBlockEntry(String id) {
        return new BlockSelectionEntryModel((CategoryModel)this, null, id, this::addBlock);
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.BLOCK;
    }

    @Override
    public void apply() {
        this.newBlocks = new class_2499();
        super.apply();
        if (!this.newBlocks.isEmpty()) {
            this.getOrCreateTag().method_10566(this.tagName, (class_2520)this.newBlocks);
        } else if (this.getOrCreateTag().method_10545(this.tagName)) {
            this.getOrCreateTag().method_10551(this.tagName);
        }
        class_1799 stack = this.getParent().getContext().getItemStack();
        ArrayList predicates = new ArrayList();
        Optional lookupOpt = ClientUtil.registryAccess().method_46759(class_7924.field_41254);
        if (lookupOpt.isPresent()) {
            class_7225.class_7226 lookup = (class_7225.class_7226)lookupOpt.get();
            for (class_2520 t : this.newBlocks) {
                class_2519 s;
                class_2960 rl;
                if (!(t instanceof class_2519) || (rl = class_2960.method_12829((String)(s = (class_2519)t).method_10714())) == null) continue;
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)rl);
                Optional holder = lookup.method_46746(key);
                holder.ifPresent(h -> predicates.add(new class_4550(Optional.of(class_6885.method_40246((class_6880[])new class_6880[]{h})), Optional.empty(), Optional.empty())));
            }
        }
        class_6538 predicate = predicates.isEmpty() ? null : new class_6538(predicates, true);
        boolean isDestroy = "CanDestroy".equals(this.tagName);
        if (predicate != null) {
            if (isDestroy) {
                stack.method_57379(class_9334.field_49635, (Object)predicate);
            } else {
                stack.method_57379(class_9334.field_49634, (Object)predicate);
            }
        } else if (isDestroy) {
            stack.method_57381(class_9334.field_49635);
        } else {
            stack.method_57381(class_9334.field_49634);
        }
    }

    private void addBlock(String id) {
        if (id == null) {
            return;
        }
        String trimmed = id.trim();
        if (!trimmed.isEmpty()) {
            this.newBlocks.add((Object)class_2519.method_23256((String)trimmed));
        }
    }

    private void readComponentBlocks(class_2520 blocksTag) {
        if (blocksTag == null) {
            return;
        }
        if (blocksTag instanceof class_2519) {
            class_2519 stringTag = (class_2519)blocksTag;
            this.addComponentBlock(stringTag.method_10714());
            return;
        }
        if (blocksTag instanceof class_2499) {
            class_2499 listTag = (class_2499)blocksTag;
            for (class_2520 element : listTag) {
                this.readComponentBlocks(element);
            }
            return;
        }
        if (blocksTag instanceof class_2487) {
            class_2487 compoundTag = (class_2487)blocksTag;
            if (compoundTag.method_10573("id", 8)) {
                this.addComponentBlock(compoundTag.method_10558("id"));
            }
            if (compoundTag.method_10573("tag", 8)) {
                this.addComponentBlock("#" + compoundTag.method_10558("tag"));
            }
            if (compoundTag.method_10545("blocks")) {
                this.readComponentBlocks(compoundTag.method_10580("blocks"));
            }
        }
    }

    private void addComponentBlock(String id) {
        if (id != null && !id.isEmpty()) {
            this.getEntries().add(this.createBlockEntry(id));
        }
    }
}

