/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EnumEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ItemBucketEntityCategoryModel
extends ItemEditorCategoryModel {
    private boolean advancedMode;
    private String snbtData = "";
    private AxolotlVariant axolotlVariant = AxolotlVariant.LEUCISTIC;
    private TropicalPattern tropicalPattern = TropicalPattern.KOB;
    private class_1767 tropicalBodyColor = class_1767.field_7952;
    private class_1767 tropicalPatternColor = class_1767.field_7946;
    private BooleanEntryModel advancedToggleEntry;
    private EnumEntryModel<AxolotlVariant> axolotlEntry;
    private EnumEntryModel<TropicalPattern> tropicalPatternEntry;
    private EnumEntryModel<class_1767> tropicalBodyEntry;
    private EnumEntryModel<class_1767> tropicalPatternEntryColor;
    private StringEntryModel snbtEntry;

    public ItemBucketEntityCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.BUCKET_ENTITY, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_1792 item = stack.method_7909();
        class_9279 data = (class_9279)stack.method_57824(class_9334.field_49610);
        this.snbtData = data != null ? data.method_57461().toString() : "";
        this.advancedMode = false;
        this.advancedToggleEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.BUCKET_USE_ADVANCED, this.advancedMode, value -> {
            this.advancedMode = value != null && value != false;
        });
        this.getEntries().add(this.advancedToggleEntry);
        if (item == class_1802.field_28354) {
            if (!this.advancedMode && data != null && data.method_57461().method_10545("Variant")) {
                this.axolotlVariant = AxolotlVariant.byId(data.method_57461().method_10550("Variant"));
            }
            this.axolotlEntry = new EnumEntryModel<AxolotlVariant>((CategoryModel)this, ModTexts.BUCKET_AXOLOTL_VARIANT, AxolotlVariant.values(), this.axolotlVariant, value -> {
                this.axolotlVariant = value == null ? AxolotlVariant.LEUCISTIC : value;
            });
            this.getEntries().add(this.axolotlEntry);
        } else if (item == class_1802.field_8478) {
            if (!this.advancedMode && data != null && data.method_57461().method_10545("BucketVariantTag")) {
                int encoded = data.method_57461().method_10550("BucketVariantTag");
                this.tropicalPattern = TropicalPattern.byId(encoded >> 8 & 0xFF);
                this.tropicalBodyColor = class_1767.method_7791((int)(encoded >> 4 & 0xF));
                this.tropicalPatternColor = class_1767.method_7791((int)(encoded & 0xF));
            }
            this.tropicalPatternEntry = new EnumEntryModel<TropicalPattern>((CategoryModel)this, ModTexts.BUCKET_TROPICAL_PATTERN, TropicalPattern.values(), this.tropicalPattern, value -> {
                this.tropicalPattern = value == null ? TropicalPattern.KOB : value;
            });
            this.tropicalBodyEntry = new EnumEntryModel<class_1767>((CategoryModel)this, ModTexts.BUCKET_TROPICAL_BODY_COLOR, class_1767.values(), this.tropicalBodyColor, value -> {
                this.tropicalBodyColor = value == null ? class_1767.field_7952 : value;
            });
            this.tropicalPatternEntryColor = new EnumEntryModel<class_1767>((CategoryModel)this, ModTexts.BUCKET_TROPICAL_PATTERN_COLOR, class_1767.values(), this.tropicalPatternColor, value -> {
                this.tropicalPatternColor = value == null ? class_1767.field_7946 : value;
            });
            this.getEntries().add(this.tropicalPatternEntry);
            this.getEntries().add(this.tropicalBodyEntry);
            this.getEntries().add(this.tropicalPatternEntryColor);
        }
        this.snbtEntry = new StringEntryModel((CategoryModel)this, ModTexts.BUCKET_ENTITY_DATA, this.snbtData, value -> {
            this.snbtData = value == null ? "" : value.trim();
        });
        this.getEntries().add(this.snbtEntry);
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_1792 item = stack.method_7909();
        if (this.advancedMode) {
            if (this.snbtData.isBlank()) {
                stack.method_57381(class_9334.field_49610);
                this.snbtEntry.setValid(true);
                return;
            }
            try {
                class_2487 tag = class_2522.method_10718((String)this.snbtData);
                stack.method_57379(class_9334.field_49610, (Object)class_9279.method_57456((class_2487)tag));
                this.snbtEntry.setValid(true);
            }
            catch (Exception ex) {
                this.snbtEntry.setValid(false);
            }
            return;
        }
        class_2487 tag = new class_2487();
        if (item == class_1802.field_28354) {
            tag.method_10569("Variant", this.axolotlVariant.ordinal());
        } else if (item == class_1802.field_8478) {
            tag.method_10569("BucketVariantTag", this.encodeTropicalVariant());
        }
        if (tag.method_33133()) {
            stack.method_57381(class_9334.field_49610);
        } else {
            stack.method_57379(class_9334.field_49610, (Object)class_9279.method_57456((class_2487)tag));
        }
    }

    private int encodeTropicalVariant() {
        int patternId = this.tropicalPattern.getId() & 0xFF;
        int body = this.tropicalBodyColor.method_7789() & 0xF;
        int patternColor = this.tropicalPatternColor.method_7789() & 0xF;
        return patternId << 8 | body << 4 | patternColor;
    }

    public static enum AxolotlVariant {
        LEUCISTIC,
        WILD,
        GOLD,
        CYAN,
        BLUE;


        public static AxolotlVariant byId(int id) {
            if (id < 0 || id >= AxolotlVariant.values().length) {
                return LEUCISTIC;
            }
            return AxolotlVariant.values()[id];
        }
    }

    public static enum TropicalPattern {
        KOB(0),
        SUNSTREAK(1),
        SNOOPER(2),
        DASHER(3),
        BRINELY(4),
        SPOTTY(5),
        FLOPPER(6),
        STRIPEY(7),
        GLITTER(8),
        BLOCKFISH(9),
        BETTY(10),
        CLAYFISH(11);

        private final int id;

        private TropicalPattern(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static TropicalPattern byId(int id) {
            for (TropicalPattern pattern : TropicalPattern.values()) {
                if (pattern.id != (id & 0xFF)) continue;
                return pattern;
            }
            return KOB;
        }
    }
}

