/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class ItemContainerCategoryModel
extends ItemEditorCategoryModel {
    private final List<StringEntryModel> slotEntries = new ArrayList<StringEntryModel>();

    public ItemContainerCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.CONTAINER_CONTENTS, editor);
    }

    @Override
    protected void setupEntries() {
        this.slotEntries.clear();
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9288 contents = (class_9288)stack.method_57824(class_9334.field_49622);
        if (contents != null) {
            contents.method_57489().filter(item -> !item.method_7960()).forEach(item -> this.getEntries().add(this.createSlotEntry(this.formatSlot((class_1799)item))));
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createSlotEntry("");
    }

    private EntryModel createSlotEntry(String spec) {
        StringEntryModel entry = new StringEntryModel((CategoryModel)this, ModTexts.CONTAINER_SLOT, spec, value -> {});
        this.slotEntries.add(entry);
        return entry;
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        ArrayList<class_1799> parsed = new ArrayList<class_1799>();
        boolean hasInvalid = false;
        for (StringEntryModel entry : this.slotEntries) {
            String spec = Optional.ofNullable((String)entry.getValue()).orElse("").trim();
            if (spec.isBlank()) {
                entry.setValid(true);
                continue;
            }
            Optional<class_1799> parsedStack = this.parseSlot(spec);
            if (parsedStack.isPresent()) {
                parsed.add(parsedStack.get());
                entry.setValid(true);
                continue;
            }
            entry.setValid(false);
            hasInvalid = true;
        }
        if (hasInvalid) {
            return;
        }
        if (parsed.isEmpty()) {
            stack.method_57381(class_9334.field_49622);
        } else {
            stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(parsed));
        }
        class_2487 data = this.getData();
        if (data != null && data.method_10545("components")) {
            class_2487 components = data.method_10562("components");
            components.method_10551("minecraft:container");
            if (components.method_33133()) {
                data.method_10551("components");
            }
        }
    }

    private Optional<class_1799> parseSlot(String spec) {
        try {
            class_2487 tag = class_2522.method_10718((String)spec);
            class_1799 parsed = class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)tag);
            if (parsed.method_7960()) {
                return Optional.empty();
            }
            return Optional.of(parsed);
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private String formatSlot(class_1799 stack) {
        class_2487 tag = (class_2487)stack.method_57376(ClientUtil.registryAccess(), (class_2520)new class_2487());
        return tag.toString();
    }
}

