/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.LootTableSelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9297;
import net.minecraft.class_9334;

public class ItemContainerLootCategoryModel
extends ItemEditorCategoryModel {
    private LootTableSelectionEntryModel tableIdEntry;
    private StringEntryModel seedEntry;

    public ItemContainerLootCategoryModel(ItemEditorModel parent) {
        super((class_2561)ModTexts.CONTAINER_LOOT, parent);
    }

    @Override
    protected void setupEntries() {
        class_2487 components;
        String tableId = "";
        String seed = "";
        class_2487 data = this.getData();
        if (data != null && data.method_10573("components", 10) && (components = data.method_10562("components")).method_10573("minecraft:container_loot", 10)) {
            class_2487 loot = components.method_10562("minecraft:container_loot");
            if (loot.method_10573("loot_table", 8)) {
                tableId = loot.method_10558("loot_table");
            }
            if (loot.method_10573("seed", 4)) {
                seed = Long.toString(loot.method_10537("seed"));
            }
        }
        this.tableIdEntry = new LootTableSelectionEntryModel(this, tableId, v -> {});
        this.seedEntry = new StringEntryModel((CategoryModel)this, ModTexts.SEED, seed, v -> {});
        this.getEntries().add(this.tableIdEntry);
        this.getEntries().add(this.seedEntry);
    }

    @Override
    public int getEntryListStart() {
        return -1;
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        String idRaw = Optional.ofNullable((String)this.tableIdEntry.getValue()).orElse("").trim();
        String seedRaw = Optional.ofNullable((String)this.seedEntry.getValue()).orElse("").trim();
        if (idRaw.isEmpty()) {
            class_2487 data = this.getData();
            if (data != null && data.method_10573("components", 10)) {
                class_2487 components = data.method_10562("components");
                components.method_10551("minecraft:container_loot");
                components.method_10551("!minecraft:container_loot");
                components.method_10566("!minecraft:container", (class_2520)new class_2487());
                if (components.method_33133()) {
                    data.method_10551("components");
                }
            }
            stack.method_57381(class_9334.field_49626);
            this.tableIdEntry.setValid(true);
            this.seedEntry.setValid(true);
            return;
        }
        try {
            class_2487 data;
            class_2960 id = class_2960.method_60654((String)idRaw);
            class_2487 loot = new class_2487();
            loot.method_10582("loot_table", id.toString());
            long seedValue = 0L;
            boolean hasSeed = false;
            if (!seedRaw.isEmpty()) {
                seedValue = Long.parseLong(seedRaw);
                hasSeed = true;
            }
            if ((data = this.getData()) != null) {
                if (!data.method_10573("components", 10)) {
                    data.method_10566("components", (class_2520)new class_2487());
                }
                class_2487 components = data.method_10562("components");
                if (hasSeed) {
                    loot.method_10544("seed", seedValue);
                }
                components.method_10566("minecraft:container_loot", (class_2520)loot);
                components.method_10551("minecraft:container");
                components.method_10566("!minecraft:container", (class_2520)new class_2487());
                if (components.method_33133()) {
                    data.method_10551("components");
                }
            }
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)id);
            class_9297 seeded = new class_9297(key, hasSeed ? seedValue : 0L);
            stack.method_57379(class_9334.field_49626, (Object)seeded);
            stack.method_57381(class_9334.field_49622);
            this.tableIdEntry.setValid(true);
            this.seedEntry.setValid(true);
        }
        catch (Exception ex) {
            this.tableIdEntry.setValid(false);
            this.seedEntry.setValid(false);
        }
    }
}

