/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.TextEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ValueEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ItemDisplayCategoryModel
extends ItemEditorCategoryModel {
    private TextEntryModel itemNameEntry;
    private TextEntryModel customNameEntry;

    public ItemDisplayCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.DISPLAY, editor);
    }

    @Override
    protected void setupEntries() {
        this.itemNameEntry = new TextEntryModel((CategoryModel)this, ModTexts.ITEM_NAME, this.getItemNameOverride(), this::setItemNameOverride);
        this.customNameEntry = new TextEntryModel((CategoryModel)this, ModTexts.CUSTOM_NAME, this.getCustomName(), this::setCustomName);
        this.getEntries().add(this.itemNameEntry);
        this.getEntries().add(this.customNameEntry);
        class_9290 lore = (class_9290)this.getStack().method_57824(class_9334.field_49632);
        if (lore != null) {
            lore.comp_2400().stream().map(class_2561::method_27661).map(this::createLoreEntry).forEach(this.getEntries()::add);
        }
    }

    @Override
    public int getEntryListStart() {
        return 2;
    }

    @Override
    public class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.LORE_ADD;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createLoreEntry(null);
    }

    private EntryModel createLoreEntry(class_5250 value) {
        TextEntryModel entry = new TextEntryModel((CategoryModel)this, null, value, lore -> {});
        entry.listIndexProperty().addListener(index -> entry.setLabel(ModTexts.lore(index + 1)));
        return entry;
    }

    @Override
    public void apply() {
        super.apply();
        this.setItemNameOverride((class_5250)this.itemNameEntry.getValue());
        this.setCustomName((class_5250)this.customNameEntry.getValue());
        class_1799 stack = this.getStack();
        List<class_2561> loreLines = this.getLoreEntries().stream().map(ValueEntryModel::getValue).map(this::normalizeLoreLine).filter(v -> v != null).map(class_2561.class::cast).toList();
        if (!loreLines.isEmpty()) {
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreLines));
        } else {
            stack.method_57381(class_9334.field_49632);
        }
        class_2561 customName = (class_2561)stack.method_57824(class_9334.field_49631);
        if (customName != null && customName.getString().isEmpty()) {
            stack.method_57381(class_9334.field_49631);
        }
    }

    private class_5250 getItemNameOverride() {
        class_2561 component = (class_2561)this.getStack().method_57824(class_9334.field_50239);
        if (component != null) {
            return component.method_27661();
        }
        return class_2561.method_43471((String)this.getStack().method_7922()).method_27661();
    }

    private void setItemNameOverride(class_5250 value) {
        class_8828 lc;
        class_7417 class_74172;
        class_1799 stack = this.getStack();
        if (ItemDisplayCategoryModel.isBlank((class_2561)value)) {
            stack.method_57381(class_9334.field_50239);
            return;
        }
        class_5250 copy = value.method_27661();
        if (!copy.method_10855().isEmpty() && (class_74172 = copy.method_10851()) instanceof class_8828 && (lc = (class_8828)class_74172).comp_737().isEmpty()) {
            copy = copy.method_27694(style -> style.method_10978(Boolean.valueOf(false)));
        }
        stack.method_57379(class_9334.field_50239, (Object)copy);
    }

    private class_5250 getCustomName() {
        class_2561 component = (class_2561)this.getStack().method_57824(class_9334.field_49631);
        return component == null ? null : component.method_27661();
    }

    private void setCustomName(class_5250 value) {
        if (ItemDisplayCategoryModel.isBlank((class_2561)value)) {
            this.getStack().method_57381(class_9334.field_49631);
            return;
        }
        if (!value.getString().isEmpty()) {
            class_8828 lc;
            class_7417 class_74172;
            class_5250 copy = value.method_27661();
            if (!copy.method_10855().isEmpty() && (class_74172 = copy.method_10851()) instanceof class_8828 && (lc = (class_8828)class_74172).comp_737().isEmpty()) {
                copy = copy.method_27694(style -> style.method_10978(Boolean.valueOf(false)));
            }
            this.getStack().method_57379(class_9334.field_49631, (Object)copy);
        } else {
            this.getStack().method_57381(class_9334.field_49631);
        }
    }

    private List<TextEntryModel> getLoreEntries() {
        int start = this.getEntryListStart();
        if (start < 0) {
            return List.of();
        }
        int end = this.getEntries().size();
        if (this.canAddEntryInList()) {
            --end;
        }
        if (start >= end) {
            return List.of();
        }
        return this.getEntries().subList(start, end).stream().filter(TextEntryModel.class::isInstance).map(TextEntryModel.class::cast).toList();
    }

    private class_5250 normalizeLoreLine(class_5250 value) {
        class_8828 lc;
        class_7417 class_74172;
        if (value == null) {
            return null;
        }
        class_5250 copy = value.method_27661();
        if (copy.getString().isEmpty() && copy.method_10855().isEmpty()) {
            return null;
        }
        if (!copy.getString().isEmpty() && (class_74172 = copy.method_10851()) instanceof class_8828 && (lc = (class_8828)class_74172).comp_737().isEmpty() && !copy.method_10855().isEmpty()) {
            copy = copy.method_27694(style -> style.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068));
        }
        return copy;
    }

    private static boolean isBlank(class_2561 c) {
        return c == null || c.getString().isEmpty();
    }

    private class_1799 getStack() {
        return this.getParent().getContext().getItemStack();
    }
}

