/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ValueEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.EnchantmentEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class ItemEnchantmentsCategoryModel
extends ItemEditorCategoryModel {
    private class_2499 newEnch;

    public ItemEnchantmentsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.ENCHANTMENTS, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getStack();
        class_9304 ench = (class_9304)stack.method_57824(class_9334.field_49633);
        class_9304 stored = (class_9304)stack.method_57824(class_9334.field_49643);
        boolean any = false;
        if (ench != null && !ench.method_57543()) {
            any = true;
            ench.method_57539().stream().map(this::createEnchantment).forEach(this.getEntries()::add);
        }
        if (stored != null && !stored.method_57543()) {
            any = true;
            stored.method_57539().stream().map(this::createEnchantment).forEach(this.getEntries()::add);
        }
        if (!any && this.getData().method_10573("tag", 10) && this.getTag().method_10573("Enchantments", 9)) {
            this.getTag().method_10554("Enchantments", 10).stream().map(class_2487.class::cast).map(this::createEnchantment).forEach(this.getEntries()::add);
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.ENCHANTMENTS;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createEnchantment("", 0);
    }

    private EnchantmentEntryModel createEnchantment(Object2IntMap.Entry<class_6880<class_1887>> entry) {
        class_6880 holder = (class_6880)entry.getKey();
        String id = holder.method_40230().map(key -> key.method_29177().toString()).orElse("");
        return this.createEnchantment(id, entry.getIntValue());
    }

    private EnchantmentEntryModel createEnchantment(class_2487 tag) {
        return this.createEnchantment(tag.method_10558("id"), tag.method_10550("lvl"));
    }

    private EnchantmentEntryModel createEnchantment(String id, int level) {
        return new EnchantmentEntryModel((CategoryModel)this, id, level, this::addEnchantment);
    }

    public Set<class_2960> getExistingEnchantmentIds() {
        HashSet<class_2960> set = new HashSet<class_2960>();
        this.getEntries().stream().filter(EnchantmentEntryModel.class::isInstance).map(EnchantmentEntryModel.class::cast).map(ValueEntryModel::getValue).map(this::normalizeId).filter(Objects::nonNull).forEach(set::add);
        return set;
    }

    public void addEnchantmentEntryIfAbsent(String id, int level) {
        class_2960 rl = this.normalizeId(id);
        if (rl == null || this.getExistingEnchantmentIds().contains(rl)) {
            return;
        }
        EnchantmentEntryModel entry = this.createEnchantment(rl.toString(), level);
        int insertIndex = this.canAddEntryInList() ? Math.max(this.getEntries().size() - 1, this.getEntryListStart()) : this.getEntries().size();
        this.getEntries().add(insertIndex, entry);
        this.updateEntryListIndexes();
    }

    private class_2960 normalizeId(String id) {
        Object value = id.contains(":") ? id : "minecraft:" + id;
        return class_2960.method_12829((String)value);
    }

    private void addEnchantment(String id, int lvl) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", id);
        tag.method_10569("lvl", lvl);
        this.newEnch.add((Object)tag);
    }

    @Override
    public void apply() {
        this.newEnch = new class_2499();
        super.apply();
        class_1799 stack = this.getStack();
        Optional lookupOpt = ClientUtil.registryAccess().method_46759(class_7924.field_41265);
        if (lookupOpt.isPresent()) {
            class_7225.class_7226 lookup = (class_7225.class_7226)lookupOpt.get();
            class_9304.class_9305 mutable = new class_9304.class_9305(class_9304.field_49385);
            for (class_2520 tag : this.newEnch) {
                class_2960 rl;
                if (!(tag instanceof class_2487)) continue;
                class_2487 compoundTag = (class_2487)tag;
                String id = compoundTag.method_10558("id");
                int lvl = compoundTag.method_10550("lvl");
                if (lvl <= 0 || (rl = class_2960.method_12829((String)id)) == null) continue;
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)rl);
                lookup.method_46746(key).ifPresent(holder -> mutable.method_57547((class_6880)holder, lvl));
            }
            class_1890.method_57530((class_1799)stack, (class_9304)mutable.method_57549());
            this.clearLegacyEnchantments();
        } else if (!this.newEnch.isEmpty()) {
            this.getOrCreateTag().method_10566("Enchantments", (class_2520)this.newEnch);
        } else if (this.getData().method_10573("tag", 10) && this.getTag().method_10545("Enchantments")) {
            this.getTag().method_10551("Enchantments");
        }
    }

    private class_1799 getStack() {
        return this.getParent().getContext().getItemStack();
    }

    private void clearLegacyEnchantments() {
        class_2487 tag;
        if (this.getData().method_10573("tag", 10) && (tag = this.getTag()).method_10545("Enchantments")) {
            tag.method_10551("Enchantments");
        }
    }
}

