/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.FireworkExplosionEditor;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ActionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EnumEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.FireworkColorEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9283;
import net.minecraft.class_9334;

public class ItemFireworkStarCategoryModel
extends ItemEditorCategoryModel {
    private final FireworkExplosionEditor explosion = new FireworkExplosionEditor();
    private boolean loadedFromStack;

    public ItemFireworkStarCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.FIREWORK_STAR, editor);
    }

    @Override
    protected void setupEntries() {
        if (!this.loadedFromStack) {
            this.loadFromStack();
            this.loadedFromStack = true;
        }
        EnumEntryModel<class_9283.class_1782> shapeEntry = new EnumEntryModel<class_9283.class_1782>((CategoryModel)this, ModTexts.FIREWORK_SHAPE, class_9283.class_1782.values(), this.explosion.getShape(), this.explosion::setShape);
        BooleanEntryModel trailEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.FIREWORK_TRAIL, this.explosion.hasTrail(), this.explosion::setHasTrail);
        BooleanEntryModel twinkleEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.FIREWORK_TWINKLE, this.explosion.hasTwinkle(), this.explosion::setHasTwinkle);
        this.getEntries().add(shapeEntry);
        this.getEntries().add(trailEntry);
        this.getEntries().add(twinkleEntry);
        this.addColorEntries(this.explosion.getColors(), true);
        this.getEntries().add(new ActionEntryModel(this, (class_2561)ModTexts.FIREWORK_ADD_PRIMARY_COLOR, () -> this.addColor(this.explosion.getColors())));
        this.addColorEntries(this.explosion.getFadeColors(), false);
        this.getEntries().add(new ActionEntryModel(this, (class_2561)ModTexts.FIREWORK_ADD_FADE_COLOR, () -> this.addColor(this.explosion.getFadeColors())));
    }

    private void loadFromStack() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9283 current = (class_9283)stack.method_57824(class_9334.field_49615);
        if (current != null) {
            this.explosion.setShape(current.comp_2386());
            this.copyList(current.comp_2387(), this.explosion.getColors());
            this.copyList(current.comp_2388(), this.explosion.getFadeColors());
            this.explosion.setHasTrail(current.comp_2389());
            this.explosion.setHasTwinkle(current.comp_2390());
        } else {
            this.explosion.getColors().clear();
            this.explosion.getFadeColors().clear();
            this.explosion.setShape(class_9283.class_1782.field_7976);
            this.explosion.setHasTrail(false);
            this.explosion.setHasTwinkle(false);
        }
    }

    private void addColorEntries(List<Integer> colors, boolean primary) {
        for (int i = 0; i < colors.size(); ++i) {
            int index = i;
            FireworkColorEntryModel entry = new FireworkColorEntryModel((CategoryModel)this, primary ? ModTexts.fireworkPrimaryColor(index + 1) : ModTexts.fireworkFadeColor(index + 1), (int)colors.get(i), value -> colors.set(index, (Integer)value), () -> this.removeColor(colors, index));
            this.getEntries().add(entry);
        }
    }

    private void addColor(List<Integer> colors) {
        colors.add(Integer.MIN_VALUE);
        this.initalize();
    }

    private void removeColor(List<Integer> colors, int index) {
        if (index >= 0 && index < colors.size()) {
            colors.remove(index);
            this.initalize();
        }
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (this.explosion.getColors().isEmpty()) {
            stack.method_57381(class_9334.field_49615);
            return;
        }
        stack.method_57379(class_9334.field_49615, (Object)this.explosion.toComponent());
    }

    private void copyList(IntList source, List<Integer> destination) {
        destination.clear();
        if (source == null) {
            return;
        }
        for (int i = 0; i < source.size(); ++i) {
            destination.add(source.getInt(i));
        }
    }
}

