/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.FireworkExplosionEditor;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ActionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.AddListEntryEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EnumEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.FireworkColorEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;

public class ItemFireworksCategoryModel
extends ItemEditorCategoryModel {
    private final List<FireworkExplosionEditor> explosions = new ArrayList<FireworkExplosionEditor>();
    private int flightDuration;
    private boolean loadedFromStack;

    public ItemFireworksCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.FIREWORK_ROCKET, editor);
    }

    @Override
    protected void setupEntries() {
        if (!this.loadedFromStack) {
            this.loadFromStack();
            this.loadedFromStack = true;
        }
        IntegerEntryModel flightEntry = new IntegerEntryModel((CategoryModel)this, ModTexts.FIREWORK_FLIGHT_DURATION, this.flightDuration, value -> {
            this.flightDuration = Math.max(0, Math.min(3, value));
        }, value -> value >= 0 && value <= 3);
        this.getEntries().add(flightEntry);
        for (int i = 0; i < this.explosions.size(); ++i) {
            this.addExplosionEntries(this.explosions.get(i), i);
        }
        this.getEntries().add(new AddListEntryEntryModel(this, (class_2561)ModTexts.FIREWORK_ADD_EXPLOSION, this::addExplosion));
    }

    private void loadFromStack() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9284 data = (class_9284)stack.method_57824(class_9334.field_49616);
        this.explosions.clear();
        if (data != null) {
            this.flightDuration = data.comp_2391();
            data.comp_2392().forEach(explosion -> this.explosions.add(new FireworkExplosionEditor((class_9283)explosion)));
        } else {
            this.flightDuration = 0;
        }
    }

    private void addExplosionEntries(FireworkExplosionEditor editor, int explosionIndex) {
        this.getEntries().add(new ActionEntryModel(this, (class_2561)ModTexts.fireworkRemoveExplosion(explosionIndex + 1), () -> this.removeExplosion(explosionIndex)));
        EnumEntryModel<class_9283.class_1782> shapeEntry = new EnumEntryModel<class_9283.class_1782>((CategoryModel)this, this.labelForExplosion(ModTexts.FIREWORK_SHAPE, explosionIndex), class_9283.class_1782.values(), editor.getShape(), editor::setShape);
        BooleanEntryModel trailEntry = new BooleanEntryModel((CategoryModel)this, this.labelForExplosion(ModTexts.FIREWORK_TRAIL, explosionIndex), editor.hasTrail(), editor::setHasTrail);
        BooleanEntryModel twinkleEntry = new BooleanEntryModel((CategoryModel)this, this.labelForExplosion(ModTexts.FIREWORK_TWINKLE, explosionIndex), editor.hasTwinkle(), editor::setHasTwinkle);
        this.getEntries().add(shapeEntry);
        this.getEntries().add(trailEntry);
        this.getEntries().add(twinkleEntry);
        this.addColorSection(editor.getColors(), true, explosionIndex);
        this.addColorSection(editor.getFadeColors(), false, explosionIndex);
    }

    private void addColorSection(List<Integer> colors, boolean primary, int explosionIndex) {
        for (int i = 0; i < colors.size(); ++i) {
            int index = i;
            FireworkColorEntryModel entry = new FireworkColorEntryModel((CategoryModel)this, this.explosionColorLabel(primary, explosionIndex, index), (int)colors.get(i), value -> colors.set(index, (Integer)value), () -> this.removeColor(colors, index));
            this.getEntries().add(entry);
        }
        class_5250 addLabel = primary ? this.labelForExplosion(ModTexts.FIREWORK_ADD_PRIMARY_COLOR, explosionIndex) : this.labelForExplosion(ModTexts.FIREWORK_ADD_FADE_COLOR, explosionIndex);
        this.getEntries().add(new ActionEntryModel(this, (class_2561)addLabel, () -> this.addColor(colors)));
    }

    private class_5250 explosionColorLabel(boolean primary, int explosionIndex, int colorIndex) {
        class_5250 base = primary ? ModTexts.fireworkPrimaryColor(colorIndex + 1) : ModTexts.fireworkFadeColor(colorIndex + 1);
        return this.labelForExplosion(base, explosionIndex);
    }

    private class_5250 labelForExplosion(class_5250 base, int explosionIndex) {
        return base.method_27661().method_27693(" ").method_10852((class_2561)ModTexts.fireworkExplosion(explosionIndex + 1));
    }

    private void addColor(List<Integer> colors) {
        colors.add(Integer.MIN_VALUE);
        this.initalize();
    }

    private void removeColor(List<Integer> colors, int index) {
        if (index >= 0 && index < colors.size()) {
            colors.remove(index);
            this.initalize();
        }
    }

    private void addExplosion() {
        this.explosions.add(new FireworkExplosionEditor());
        this.initalize();
    }

    private void removeExplosion(int index) {
        if (index >= 0 && index < this.explosions.size()) {
            this.explosions.remove(index);
            this.initalize();
        }
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        List<class_9283> built = this.explosions.stream().map(FireworkExplosionEditor::toComponent).filter(explosion -> explosion.comp_2387() != null && explosion.comp_2387().size() > 0).toList();
        int clampedFlight = Math.max(0, Math.min(3, this.flightDuration));
        if (built.isEmpty() && clampedFlight == 0) {
            stack.method_57381(class_9334.field_49616);
            return;
        }
        stack.method_57379(class_9334.field_49616, (Object)new class_9284(clampedFlight, built));
    }
}

