/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.HideFlagEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class ItemHideFlagsCategoryModel
extends ItemEditorCategoryModel {
    private final EnumSet<HideFlag> selectedFlags = EnumSet.noneOf(HideFlag.class);

    public ItemHideFlagsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.HIDE_FLAGS, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        EnumSet<HideFlag> initial = EnumSet.noneOf(HideFlag.class);
        this.selectedFlags.clear();
        initial.addAll(TooltipDisplaySupport.INSTANCE.read(stack));
        initial.addAll(this.readLegacyFlags(stack));
        if (initial.isEmpty()) {
            initial.addAll(this.readComponentVisibilityFallback(stack));
        }
        initial.addAll(this.readRemovedComponents(stack));
        for (HideFlag flag : HideFlag.values()) {
            boolean selected = initial.contains((Object)flag);
            if (selected) {
                this.selectedFlags.add(flag);
            }
            this.getEntries().add(new HideFlagEntryModel((CategoryModel)this, flag, selected, value -> this.setFlag(flag, (boolean)value)));
        }
    }

    private EnumSet<HideFlag> readLegacyFlags(class_1799 stack) {
        EnumSet<HideFlag> flags;
        block3: {
            int mask;
            block4: {
                block2: {
                    flags = EnumSet.noneOf(HideFlag.class);
                    if (!stack.method_57826(class_9334.field_50074)) break block2;
                    flags.add(HideFlag.OTHER);
                    break block3;
                }
                if (!stack.method_57826(class_9334.field_49638)) break block4;
                for (HideFlag flag : HideFlag.values()) {
                    if (flag == HideFlag.OTHER) continue;
                    flags.add(flag);
                }
                break block3;
            }
            int n = mask = this.getTag() != null ? this.getTag().method_10550("HideFlags") : 0;
            if (mask == 0) break block3;
            for (HideFlag flag : HideFlag.values()) {
                if ((mask & flag.getValue()) == 0) continue;
                flags.add(flag);
            }
        }
        return flags;
    }

    @Override
    public void apply() {
        super.apply();
        this.refreshSelectedFlags();
        class_1799 stack = this.getParent().getContext().getItemStack();
        TooltipDisplaySupport.INSTANCE.clear(stack);
        stack.method_57381(class_9334.field_50074);
        stack.method_57381(class_9334.field_49638);
        EnumSet<HideFlag> storedFlags = EnumSet.copyOf(this.selectedFlags);
        EnumSet<HideFlag> componentFlags = EnumSet.copyOf(storedFlags);
        boolean hideTooltip = componentFlags.remove((Object)HideFlag.OTHER);
        LinkedHashSet hiddenComponents = new LinkedHashSet();
        for (HideFlag flag : componentFlags) {
            hiddenComponents.addAll(flag.hiddenComponents());
        }
        boolean tooltipApplied = TooltipDisplaySupport.INSTANCE.apply(stack, hideTooltip, hiddenComponents);
        if (!tooltipApplied) {
            this.applyLegacyComponentVisibility(stack, componentFlags, hideTooltip);
            this.writeLegacyMask(storedFlags);
        } else if (this.getTag() != null) {
            this.getTag().method_10551("HideFlags");
        }
        this.syncEntriesWithStack(stack);
    }

    private void refreshSelectedFlags() {
        this.selectedFlags.clear();
        for (EntryModel entry : this.getEntries()) {
            HideFlagEntryModel flagEntry;
            if (!(entry instanceof HideFlagEntryModel) || !Boolean.TRUE.equals((flagEntry = (HideFlagEntryModel)entry).getValue())) continue;
            this.selectedFlags.add(flagEntry.getHideFlag());
        }
    }

    private void syncEntriesWithStack(class_1799 stack) {
        EnumSet<HideFlag> actual = EnumSet.noneOf(HideFlag.class);
        actual.addAll(TooltipDisplaySupport.INSTANCE.read(stack));
        actual.addAll(this.readLegacyFlags(stack));
        if (actual.isEmpty()) {
            actual.addAll(this.readComponentVisibilityFallback(stack));
        }
        actual.addAll(this.readRemovedComponents(stack));
        this.selectedFlags.clear();
        this.selectedFlags.addAll(actual);
        for (EntryModel entry : this.getEntries()) {
            if (!(entry instanceof HideFlagEntryModel)) continue;
            HideFlagEntryModel flagEntry = (HideFlagEntryModel)entry;
            flagEntry.syncValue(this.selectedFlags.contains((Object)flagEntry.getHideFlag()));
        }
    }

    private EnumSet<HideFlag> readRemovedComponents(class_1799 stack) {
        class_2487 compound;
        class_2487 root;
        class_2520 saved = stack.method_57376(ClientUtil.registryAccess(), (class_2520)new class_2487());
        class_2487 class_24872 = root = saved instanceof class_2487 ? (compound = (class_2487)saved) : new class_2487();
        if (!root.method_10573("components", 10)) {
            return EnumSet.noneOf(HideFlag.class);
        }
        class_2487 components = root.method_10562("components");
        EnumSet<HideFlag> flags = EnumSet.noneOf(HideFlag.class);
        block0: for (HideFlag flag : HideFlag.values()) {
            if (flag == HideFlag.OTHER) continue;
            for (class_9331<?> type : flag.hiddenComponents()) {
                String key;
                class_2960 id = class_7923.field_49658.method_10221(type);
                if (id == null || !components.method_10545(key = "!" + String.valueOf(id))) continue;
                flags.add(flag);
                continue block0;
            }
        }
        return flags;
    }

    private void applyLegacyComponentVisibility(class_1799 stack, EnumSet<HideFlag> componentFlags, boolean hideTooltip) {
        if (hideTooltip) {
            stack.method_57379(class_9334.field_50074, (Object)class_3902.field_17274);
        } else {
            stack.method_57381(class_9334.field_50074);
        }
        this.applyComponentVisibilityFallback(stack, componentFlags);
    }

    private EnumSet<HideFlag> readComponentVisibilityFallback(class_1799 stack) {
        EnumSet<HideFlag> flags = EnumSet.noneOf(HideFlag.class);
        try {
            block6: for (HideFlag flag : HideFlag.values()) {
                if (flag == HideFlag.OTHER) continue;
                for (class_9331<?> type : flag.hiddenComponents()) {
                    Object value = stack.method_57824(type);
                    if (value == null) continue;
                    boolean show = true;
                    try {
                        Method getter = value.getClass().getMethod("showInTooltip", new Class[0]);
                        show = (Boolean)getter.invoke(value, new Object[0]);
                    }
                    catch (ReflectiveOperationException ignored) {
                        try {
                            Field field = value.getClass().getDeclaredField("showInTooltip");
                            field.setAccessible(true);
                            show = field.getBoolean(value);
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            // empty catch block
                        }
                    }
                    if (show) continue;
                    flags.add(flag);
                    continue block6;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flags;
    }

    private void writeLegacyMask(EnumSet<HideFlag> flags) {
        int mask = 0;
        for (HideFlag flag : flags) {
            mask |= flag.getValue();
        }
        if (mask != 0) {
            this.getOrCreateTag().method_10569("HideFlags", mask);
        } else if (this.getTag() != null) {
            this.getTag().method_10551("HideFlags");
        }
    }

    private void setFlag(HideFlag flag, boolean value) {
        if (value) {
            this.selectedFlags.add(flag);
        } else {
            this.selectedFlags.remove((Object)flag);
        }
    }

    private void applyComponentVisibilityFallback(class_1799 stack, Set<HideFlag> flags) {
        for (HideFlag flag : HideFlag.values()) {
            if (flag == HideFlag.OTHER) continue;
            boolean show = !flags.contains((Object)flag);
            for (class_9331<?> type : flag.hiddenComponents()) {
                ItemHideFlagsCategoryModel.setShowInTooltip(stack, type, show);
            }
        }
    }

    private static void setShowInTooltip(class_1799 stack, class_9331 type, boolean show) {
        Object value = stack.method_57824(type);
        if (value == null) {
            return;
        }
        try {
            Class<?> clazz = value.getClass();
            Boolean current = null;
            try {
                Method getter = clazz.getMethod("showInTooltip", new Class[0]);
                current = (Boolean)getter.invoke(value, new Object[0]);
            }
            catch (NoSuchMethodException ignored) {
                try {
                    Field field = clazz.getDeclaredField("showInTooltip");
                    field.setAccessible(true);
                    current = field.getBoolean(value);
                }
                catch (IllegalAccessException | NoSuchFieldException field) {
                    // empty catch block
                }
            }
            if (current != null && current == show) {
                return;
            }
            try {
                Object newVal;
                Method method = clazz.getMethod("withShowInTooltip", Boolean.TYPE);
                if (clazz.isAssignableFrom(method.getReturnType()) && (newVal = method.invoke(value, show)) != null) {
                    stack.method_57379(type, newVal);
                    return;
                }
            }
            catch (NoSuchMethodException method) {
                // empty catch block
            }
            for (Method method : clazz.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Boolean.TYPE || !clazz.isAssignableFrom(method.getReturnType())) continue;
                try {
                    Object newVal = method.invoke(value, show);
                    if (newVal == null) continue;
                    stack.method_57379(type, newVal);
                    return;
                }
                catch (ReflectiveOperationException newVal) {
                    // empty catch block
                }
            }
            if (clazz.isRecord()) {
                RecordComponent[] components = clazz.getRecordComponents();
                Object[] args = new Object[components.length];
                Class[] types = new Class[components.length];
                boolean hasShowField = false;
                for (int i = 0; i < components.length; ++i) {
                    RecordComponent rc = components[i];
                    types[i] = rc.getType();
                    Object arg = rc.getAccessor().invoke(value, new Object[0]);
                    if (rc.getName().equals("showInTooltip") && (types[i] == Boolean.TYPE || types[i] == Boolean.class)) {
                        arg = show;
                        hasShowField = true;
                    }
                    args[i] = arg;
                }
                if (hasShowField) {
                    Constructor<?> ctor = clazz.getDeclaredConstructor(types);
                    ctor.setAccessible(true);
                    Object newVal = ctor.newInstance(args);
                    stack.method_57379(type, newVal);
                }
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static enum HideFlag {
        ENCHANTMENTS(class_9334.field_49633, class_9334.field_49643),
        ATTRIBUTE_MODIFIERS(class_9334.field_49636),
        UNBREAKABLE(class_9334.field_49630),
        CAN_DESTROY(class_9334.field_49635),
        CAN_PLACE_ON(class_9334.field_49634),
        OTHER(new class_9331[0]),
        DYED(class_9334.field_49644),
        ARMOR_TRIMS(class_9334.field_49607),
        JUKEBOX(class_9334.field_52175),
        LORE(class_9334.field_49632);

        private static final Map<class_9331<?>, HideFlag> COMPONENT_TO_FLAG;
        private final Set<class_9331<?>> hiddenComponents;

        private HideFlag(class_9331<?> ... components) {
            this.hiddenComponents = Set.of(components);
        }

        public class_5250 getName() {
            return ModTexts.gui(this.name().toLowerCase(Locale.ROOT));
        }

        public int getValue() {
            return 1 << this.ordinal();
        }

        public Collection<class_9331<?>> hiddenComponents() {
            return this.hiddenComponents;
        }

        public static HideFlag fromComponent(class_9331<?> type) {
            return COMPONENT_TO_FLAG.get(type);
        }

        static {
            COMPONENT_TO_FLAG = new HashMap();
            for (HideFlag flag : HideFlag.values()) {
                for (class_9331<?> type : flag.hiddenComponents) {
                    COMPONENT_TO_FLAG.put(type, flag);
                }
            }
        }
    }

    private static final class TooltipDisplaySupport {
        static final TooltipDisplaySupport INSTANCE = new TooltipDisplaySupport();
        private final class_9331<Object> type;
        private final Constructor<?> ctor;
        private final Method hideTooltipGetter;
        private final Method hiddenComponentsGetter;

        private TooltipDisplaySupport() {
            class_9331 t = null;
            Constructor<?> c = null;
            Method mHide = null;
            Method mHidden = null;
            try {
                Field field = class_9334.class.getDeclaredField("TOOLTIP_DISPLAY");
                t = (class_9331)field.get(null);
                Class<?> displayClass = Class.forName("net.minecraft.world.item.component.TooltipDisplay");
                c = displayClass.getDeclaredConstructor(Boolean.TYPE, Set.class);
                mHide = displayClass.getMethod("hideTooltip", new Class[0]);
                mHidden = displayClass.getMethod("hiddenComponents", new Class[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            this.type = t;
            this.ctor = c;
            this.hideTooltipGetter = mHide;
            this.hiddenComponentsGetter = mHidden;
        }

        private boolean available() {
            return this.type != null && this.ctor != null && this.hideTooltipGetter != null && this.hiddenComponentsGetter != null;
        }

        private EnumSet<HideFlag> read(class_1799 stack) {
            EnumSet<HideFlag> flags = EnumSet.noneOf(HideFlag.class);
            if (!this.available()) {
                return flags;
            }
            Object value = stack.method_57824(this.type);
            if (value == null) {
                return flags;
            }
            try {
                Object hidden;
                if (((Boolean)this.hideTooltipGetter.invoke(value, new Object[0])).booleanValue()) {
                    flags.add(HideFlag.OTHER);
                }
                if ((hidden = this.hiddenComponentsGetter.invoke(value, new Object[0])) instanceof Iterable) {
                    Iterable it = (Iterable)hidden;
                    for (Object o : it) {
                        class_9331 dc;
                        HideFlag flag;
                        if (!(o instanceof class_9331) || (flag = HideFlag.fromComponent(dc = (class_9331)o)) == null) continue;
                        flags.add(flag);
                    }
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            return flags;
        }

        private boolean apply(class_1799 stack, boolean hideTooltip, Set<class_9331<?>> components) {
            if (!this.available()) {
                return false;
            }
            try {
                if (!hideTooltip && components.isEmpty()) {
                    stack.method_57381(this.type);
                } else {
                    Object value = this.ctor.newInstance(hideTooltip, Set.copyOf(components));
                    stack.method_57379(this.type, value);
                }
                return true;
            }
            catch (ReflectiveOperationException ignored) {
                return false;
            }
        }

        private void clear(class_1799 stack) {
            if (this.type != null) {
                stack.method_57381(this.type);
            }
        }
    }
}

