/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotDecorationEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_8526;
import net.minecraft.class_9334;

public class ItemPotDecorationsCategoryModel
extends ItemEditorCategoryModel {
    private PotDecorationEntryModel backEntry;
    private PotDecorationEntryModel leftEntry;
    private PotDecorationEntryModel rightEntry;
    private PotDecorationEntryModel frontEntry;

    public ItemPotDecorationsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.POT_DECORATIONS, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_8526 decorations = (class_8526)stack.method_57824(class_9334.field_49621);
        if (decorations == null) {
            decorations = class_8526.field_44707;
        }
        this.backEntry = this.createEntry(ModTexts.POT_BACK, decorations.comp_1487());
        this.leftEntry = this.createEntry(ModTexts.POT_LEFT, decorations.comp_1488());
        this.rightEntry = this.createEntry(ModTexts.POT_RIGHT, decorations.comp_1489());
        this.frontEntry = this.createEntry(ModTexts.POT_FRONT, decorations.comp_1490());
        this.getEntries().add(this.backEntry);
        this.getEntries().add(this.leftEntry);
        this.getEntries().add(this.rightEntry);
        this.getEntries().add(this.frontEntry);
    }

    private PotDecorationEntryModel createEntry(class_5250 label, Optional<class_1792> optionalItem) {
        class_1799 stack = optionalItem.map(class_1799::new).orElse(class_1799.field_8037);
        return new PotDecorationEntryModel(this, label, stack);
    }

    @Override
    public void apply() {
        super.apply();
        Optional<class_1792> back = this.toItem(this.backEntry);
        Optional<class_1792> left = this.toItem(this.leftEntry);
        Optional<class_1792> right = this.toItem(this.rightEntry);
        Optional<class_1792> front = this.toItem(this.frontEntry);
        class_8526 decorations = new class_8526(back, left, right, front);
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (decorations.equals((Object)class_8526.field_44707)) {
            stack.method_57381(class_9334.field_49621);
        } else {
            stack.method_57379(class_9334.field_49621, (Object)decorations);
        }
        this.cleanComponentTag();
    }

    private Optional<class_1792> toItem(PotDecorationEntryModel entry) {
        class_1799 stack = entry.getItemStack();
        if (stack.method_7960()) {
            entry.setValid(true);
            return Optional.empty();
        }
        entry.setValid(true);
        return Optional.of(stack.method_7909());
    }

    private void cleanComponentTag() {
        class_2487 data = this.getData();
        if (data == null || !data.method_10545("components")) {
            return;
        }
        class_2487 components = data.method_10562("components");
        components.method_10551("minecraft:pot_decorations");
        if (components.method_33133()) {
            data.method_10551("components");
        }
    }
}

