/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionSelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class ItemPotionEffectsCategoryModel
extends ItemEditorCategoryModel {
    private List<class_2487> collectedCustomEffects;
    private List<class_2487> collectedBaseEffects;
    private List<class_2487> originalBaseEffectTags = List.of();
    private int originalBaseEntryCount;
    private int currentBaseEntryCount;
    private boolean baseEffectsModified;

    public ItemPotionEffectsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.POTION_EFFECTS, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_1844 contents = (class_1844)stack.method_57824(class_9334.field_49651);
        String potionId = "";
        int customColor = Integer.MIN_VALUE;
        this.originalBaseEffectTags = List.of();
        this.originalBaseEntryCount = 0;
        if (contents != null) {
            potionId = contents.comp_2378().flatMap(h -> h.method_40230().map(k -> Optional.of(k.method_29177().toString())).orElse(Optional.empty())).orElse("");
            customColor = contents.comp_2379().orElse(Integer.MIN_VALUE);
            this.originalBaseEffectTags = this.resolveBasePotionEffects(potionId);
            this.originalBaseEntryCount = this.originalBaseEffectTags.size();
            this.originalBaseEffectTags.forEach(tag -> this.getEntries().add(this.createPotionEffectEntry((class_2487)tag, true)));
            contents.comp_2380().forEach(e -> this.getEntries().add(this.createPotionEffectEntry(ItemPotionEffectsCategoryModel.toTag(e), false)));
        } else {
            potionId = this.getTag().method_10558("Potion");
            customColor = this.getCustomPotionColor();
            this.originalBaseEffectTags = this.resolveBasePotionEffects(potionId);
            this.originalBaseEntryCount = this.originalBaseEffectTags.size();
            this.originalBaseEffectTags.forEach(tag -> this.getEntries().add(this.createPotionEffectEntry((class_2487)tag, true)));
            this.getTag().method_10554("custom_potion_effects", 10).stream().map(class_2487.class::cast).map(t -> this.createPotionEffectEntry((class_2487)t, false)).forEach(this.getEntries()::add);
        }
        this.getEntries().add(0, new PotionSelectionEntryModel(this, ModTexts.DEFAULT_POTION, potionId, customColor, p -> this.getOrCreateTag().method_10582("Potion", p), this::setCustomPotionColor));
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createPotionEffectEntry(null, false);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    @Override
    public void apply() {
        class_2960 rl;
        this.collectedCustomEffects = new ArrayList<class_2487>();
        this.collectedBaseEffects = new ArrayList<class_2487>();
        this.baseEffectsModified = false;
        this.currentBaseEntryCount = 0;
        super.apply();
        if (this.currentBaseEntryCount != this.originalBaseEntryCount) {
            this.baseEffectsModified = true;
        } else if (!this.baseEffectsModified && !ItemPotionEffectsCategoryModel.tagsEqual(this.collectedBaseEffects, this.originalBaseEffectTags)) {
            this.baseEffectsModified = true;
        }
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_7225.class_7874 registry = ClientUtil.registryAccess();
        Optional potionLookupOpt = registry.method_46759(class_7924.field_41215);
        Optional effectLookupOpt = registry.method_46759(class_7924.field_41208);
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        ArrayList<class_2487> effectiveEffects = new ArrayList<class_2487>(this.collectedCustomEffects);
        if (this.baseEffectsModified) {
            effectiveEffects.addAll(this.collectedBaseEffects);
        }
        if (effectLookupOpt.isPresent()) {
            class_7225.class_7226 effectLookup = (class_7225.class_7226)effectLookupOpt.get();
            for (Object c : effectiveEffects) {
                Optional holderOpt;
                String id = c.method_10558("id");
                rl = class_2960.method_12829((String)id);
                if (rl == null || (holderOpt = effectLookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_41208, (class_2960)rl))).isEmpty()) continue;
                int amplifier = c.method_10550("amplifier");
                int duration = c.method_10573("duration", 3) ? c.method_10550("duration") : 1;
                boolean ambient = c.method_10577("ambient");
                boolean showParticles = !c.method_10573("show_particles", 1) || c.method_10577("show_particles");
                boolean showIcon = c.method_10573("show_icon", 1) && c.method_10577("show_icon");
                effects.add(new class_1293((class_6880)holderOpt.get(), duration, amplifier, ambient, showParticles, showIcon));
            }
        }
        String potionStr = this.getOrCreateTag().method_10558("Potion");
        if (this.baseEffectsModified && !potionStr.isEmpty()) {
            Object c;
            potionStr = "";
            this.getOrCreateTag().method_10582("Potion", potionStr);
            if (!this.getEntries().isEmpty() && (c = this.getEntries().get(0)) instanceof PotionSelectionEntryModel) {
                PotionSelectionEntryModel selection = (PotionSelectionEntryModel)c;
                selection.setValue(potionStr);
                selection.apply();
            }
        }
        int customColor = this.getCustomPotionColor();
        class_1844 contents = null;
        if (potionLookupOpt.isPresent()) {
            Optional potHolder;
            class_7225.class_7226 potionLookup = (class_7225.class_7226)potionLookupOpt.get();
            rl = potionStr.isEmpty() ? class_2960.method_60654((String)"minecraft:empty") : class_2960.method_12829((String)potionStr);
            Optional<Object> pot = Optional.empty();
            if (!this.baseEffectsModified && rl != null && (potHolder = potionLookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_41215, (class_2960)rl))).isPresent()) {
                pot = Optional.of((class_6880)potHolder.get());
            }
            contents = new class_1844(pot, customColor != Integer.MIN_VALUE ? Optional.of(customColor) : Optional.empty(), effects);
        }
        if (contents != null) {
            stack.method_57379(class_9334.field_49651, contents);
        } else {
            stack.method_57381(class_9334.field_49651);
        }
        if (this.getData().method_10573("tag", 10)) {
            class_2487 tag = this.getTag();
            tag.method_10551("Potion");
            tag.method_10551("CustomPotionColor");
            tag.method_10551("custom_potion_effects");
        }
    }

    private int getCustomPotionColor() {
        return this.getTag().method_10573("CustomPotionColor", 3) ? this.getTag().method_10550("CustomPotionColor") : Integer.MIN_VALUE;
    }

    private void setCustomPotionColor(int color) {
        if (color != Integer.MIN_VALUE) {
            this.getOrCreateTag().method_10569("CustomPotionColor", color);
        } else {
            this.getOrCreateTag().method_10551("CustomPotionColor");
        }
    }

    private EntryModel createPotionEffectEntry(class_2487 tag, boolean baseEffect) {
        if (tag != null) {
            String id = tag.method_10558("id");
            int amplifier = tag.method_10550("amplifier");
            int duration = tag.method_10573("duration", 3) ? tag.method_10550("duration") : 1;
            boolean ambient = tag.method_10577("ambient");
            boolean showParticles = !tag.method_10573("show_particles", 1) || tag.method_10577("show_particles");
            boolean showIcon = tag.method_10577("show_icon");
            return new PotionEffectEntryModel(this, id, amplifier, duration, ambient, showParticles, showIcon, this::collectPotionEffect, baseEffect, tag);
        }
        String defaultId = class_1294.field_5904.method_40230().map(key -> key.method_29177().toString()).orElse("minecraft:movement_speed");
        return new PotionEffectEntryModel(this, defaultId, 0, 1, false, true, true, this::collectPotionEffect);
    }

    private void collectPotionEffect(PotionEffectEntryModel entry) {
        class_2487 tag = entry.toCompoundTag();
        if (entry.isBaseEffect()) {
            ++this.currentBaseEntryCount;
            this.collectedBaseEffects.add(tag.method_10553());
            if (entry.isModifiedFromOriginal()) {
                this.baseEffectsModified = true;
            }
        } else {
            this.collectedCustomEffects.add(tag.method_10553());
        }
    }

    private List<class_2487> resolveBasePotionEffects(String potionId) {
        if (potionId == null || potionId.isEmpty()) {
            return List.of();
        }
        Optional lookupOpt = ClientUtil.registryAccess().method_46759(class_7924.field_41215);
        if (lookupOpt.isEmpty()) {
            return List.of();
        }
        class_2960 rl = class_2960.method_12829((String)potionId);
        if (rl == null) {
            return List.of();
        }
        Optional holderOpt = ((class_7225.class_7226)lookupOpt.get()).method_46746(class_5321.method_29179((class_5321)class_7924.field_41215, (class_2960)rl));
        if (holderOpt.isEmpty()) {
            return List.of();
        }
        ArrayList result = new ArrayList();
        ((class_1842)((class_6880.class_6883)holderOpt.get()).comp_349()).method_8049().forEach(effect -> result.add(ItemPotionEffectsCategoryModel.toTag(effect)));
        return List.copyOf(result);
    }

    private static boolean tagsEqual(List<class_2487> a, List<class_2487> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (Objects.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    private static class_2487 toTag(class_1293 e) {
        class_2487 tag = new class_2487();
        String id = e.method_5579().method_40230().map(k -> k.method_29177().toString()).orElse("");
        tag.method_10582("id", id);
        tag.method_10569("amplifier", e.method_5578());
        tag.method_10569("duration", e.method_5584());
        tag.method_10556("ambient", e.method_5591());
        tag.method_10556("show_particles", e.method_5581());
        tag.method_10556("show_icon", e.method_5592());
        return tag;
    }
}

