/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9298;
import net.minecraft.class_9334;

public class ItemSuspiciousStewEffectsCategoryModel
extends ItemEditorCategoryModel {
    private final List<class_9298.class_8751> stagedEffects = new ArrayList<class_9298.class_8751>();

    public ItemSuspiciousStewEffectsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.gui("suspicious_stew_effects"), editor);
    }

    @Override
    protected void setupEntries() {
        List<EffectData> effects = this.readEffects();
        if (effects.isEmpty()) {
            this.getEntries().add(this.createEffectEntry(null));
        } else {
            for (EffectData e : effects) {
                this.getEntries().add(this.createEffectEntry(e));
            }
        }
    }

    private List<EffectData> readEffects() {
        class_2487 data;
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9298 component = (class_9298)stack.method_57824(class_9334.field_49652);
        if (component != null) {
            ArrayList<EffectData> effects = new ArrayList<EffectData>();
            component.comp_2416().forEach(entry -> {
                String id = entry.comp_1838().method_40230().map(key -> key.method_29177().toString()).orElse("minecraft:empty");
                effects.add(new EffectData(id, entry.comp_1839()));
            });
            if (!effects.isEmpty()) {
                return effects;
            }
        }
        if ((data = this.getData()) == null || !data.method_10573("components", 10)) {
            return List.of();
        }
        class_2487 comps = data.method_10562("components");
        if (!comps.method_10573("minecraft:suspicious_stew_effects", 9)) {
            return List.of();
        }
        class_2499 list = comps.method_10554("minecraft:suspicious_stew_effects", 10);
        ArrayList<EffectData> out = new ArrayList<EffectData>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            class_2487 c = list.method_10602(i);
            if (!c.method_10573("id", 8)) continue;
            String id = c.method_10558("id");
            int duration = c.method_10573("duration", 3) ? c.method_10550("duration") : 160;
            out.add(new EffectData(id, duration));
        }
        return out;
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    public void apply() {
        this.stagedEffects.clear();
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (this.stagedEffects.isEmpty()) {
            stack.method_57381(class_9334.field_49652);
        } else {
            stack.method_57379(class_9334.field_49652, (Object)new class_9298(List.copyOf(this.stagedEffects)));
        }
    }

    private EntryModel createEffectEntry(EffectData data) {
        if (data != null) {
            return new PotionEffectEntryModel(this, data.id(), 0, data.duration(), false, true, true, this::collectEffect);
        }
        String defaultId = class_1294.field_5904.method_40230().map(key -> key.method_29177().toString()).orElse("minecraft:movement_speed");
        return new PotionEffectEntryModel(this, defaultId, 0, 160, false, true, true, this::collectEffect);
    }

    private void collectEffect(PotionEffectEntryModel entry) {
        class_2960 rl = class_2960.method_12829((String)((String)entry.getValue()));
        if (rl == null) {
            return;
        }
        Optional lookupOpt = ClientUtil.registryAccess().method_46759(class_7924.field_41208);
        if (lookupOpt.isEmpty()) {
            return;
        }
        Optional holder = ((class_7225.class_7226)lookupOpt.get()).method_46746(class_5321.method_29179((class_5321)class_7924.field_41208, (class_2960)rl));
        if (holder.isEmpty()) {
            return;
        }
        int duration = Math.max(1, entry.getDuration());
        this.stagedEffects.add(new class_9298.class_8751((class_6880)holder.get(), duration));
    }

    private record EffectData(String id, int duration) {
    }
}

