/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.WritableBookPagesEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9334;

public class ItemWritableBookPagesCategoryModel
extends ItemEditorCategoryModel {
    private WritableBookPagesEntryModel pagesEntry;
    private List<String> stagedPages = List.of();

    public ItemWritableBookPagesCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.gui("writable_book_content"), editor);
    }

    @Override
    protected void setupEntries() {
        List<String> pages = this.readPages();
        this.pagesEntry = new WritableBookPagesEntryModel(this, pages, this::collectPages);
        this.getEntries().add(this.pagesEntry);
    }

    @Override
    public int getEntryListStart() {
        return -1;
    }

    @Override
    public int getEntryHeight() {
        return 190;
    }

    @Override
    public EntryModel createNewListEntry() {
        return null;
    }

    @Override
    public void apply() {
        this.stagedPages = List.of();
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        List<String> pages = this.stagedPages;
        boolean hasContent = pages.stream().anyMatch(text -> !text.isBlank());
        if (!hasContent) {
            stack.method_57381(class_9334.field_49653);
            pages = List.of();
        } else {
            List<class_9262> filterables = pages.stream().limit(100L).map(text -> class_9262.method_57137((Object)this.sanitizePage((String)text))).toList();
            stack.method_57379(class_9334.field_49653, (Object)new class_9301(filterables));
        }
        this.writeLegacyPages(pages);
    }

    private List<String> readPages() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        ArrayList<String> result = new ArrayList<String>();
        class_9301 content = (class_9301)stack.method_57824(class_9334.field_49653);
        if (content != null) {
            content.method_57517(false).limit(100L).map(this::sanitizePage).forEach(result::add);
        }
        if (!result.isEmpty()) {
            return result;
        }
        class_2487 data = this.getData();
        if (data == null || !data.method_10573("tag", 10)) {
            return result;
        }
        class_2487 tag = data.method_10562("tag");
        if (!tag.method_10573("pages", 9)) {
            return result;
        }
        class_2499 list = tag.method_10554("pages", 8);
        for (int i = 0; i < list.size() && result.size() < 100; ++i) {
            result.add(this.sanitizePage(list.method_10608(i)));
        }
        return result;
    }

    private void collectPages(List<String> pages) {
        ArrayList sanitized = new ArrayList(pages.size());
        pages.stream().limit(100L).map(this::sanitizePage).forEach(sanitized::add);
        this.stagedPages = List.copyOf(sanitized);
    }

    private void writeLegacyPages(List<String> pages) {
        class_2487 data = this.getData();
        if (data == null) {
            return;
        }
        if (pages.isEmpty()) {
            if (data.method_10573("tag", 10)) {
                class_2487 tag = data.method_10562("tag");
                tag.method_10551("pages");
                if (tag.method_33133()) {
                    data.method_10551("tag");
                }
            }
            return;
        }
        if (!data.method_10573("tag", 10)) {
            data.method_10566("tag", (class_2520)new class_2487());
        }
        class_2487 tag = data.method_10562("tag");
        class_2499 list = new class_2499();
        pages.stream().limit(100L).map(this::sanitizePage).map(class_2519::method_23256).forEach(arg_0 -> list.add(arg_0));
        tag.method_10566("pages", (class_2520)list);
    }

    private String sanitizePage(String text) {
        String value;
        String string = value = text == null ? "" : text.replace("\r", "");
        if (value.length() > 1024) {
            return value.substring(0, 1024);
        }
        return value;
    }
}

