/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.entity;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityEquipmentCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5250;

public class EntityEquipmentEntryModel
extends EntryModel {
    private final EntityEquipmentCategoryModel category;
    private final EntityEquipmentCategoryModel.Slot slot;
    private final ObjectProperty<class_1799> itemProperty;
    private final ObjectProperty<Float> dropChanceProperty;
    private class_1799 defaultItem;
    private float defaultDropChance;

    public EntityEquipmentEntryModel(EntityEquipmentCategoryModel category, EntityEquipmentCategoryModel.Slot slot, class_1799 stack, float dropChance) {
        super(category);
        this.category = category;
        this.slot = slot;
        this.defaultItem = this.sanitize(stack);
        this.defaultDropChance = dropChance;
        this.itemProperty = ObjectProperty.create(this.defaultItem.method_7972());
        this.dropChanceProperty = ObjectProperty.create(Float.valueOf(dropChance));
        this.itemProperty.addListener(value -> this.invalidateIfNecessary());
        this.dropChanceProperty.addListener(value -> this.invalidateIfNecessary());
        this.invalidateIfNecessary();
    }

    public EntityEquipmentCategoryModel.Slot getSlot() {
        return this.slot;
    }

    public class_5250 getSlotLabel() {
        return this.slot.label();
    }

    public class_1799 getItemStack() {
        class_1799 current = (class_1799)this.itemProperty.getValue();
        return current == null ? class_1799.field_8037 : current;
    }

    public ObjectProperty<class_1799> itemStackProperty() {
        return this.itemProperty;
    }

    public void setItemStack(class_1799 stack) {
        class_1799 sanitized = this.sanitize(stack);
        this.itemProperty.setValue(sanitized);
        this.invalidateIfNecessary();
    }

    private class_1799 sanitize(class_1799 stack) {
        if (stack == null) {
            return class_1799.field_8037;
        }
        if (stack.method_7909() == class_1802.field_8600) {
            return new class_1799((class_1935)class_1802.field_8600);
        }
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 copy = stack.method_7972();
        if (copy.method_7947() <= 0) {
            copy.method_7939(1);
        }
        return copy;
    }

    public float getDropChance() {
        Float value = (Float)this.dropChanceProperty.getValue();
        return value == null ? this.slot.defaultDropChance() : value.floatValue();
    }

    public ObjectProperty<Float> dropChanceProperty() {
        return this.dropChanceProperty;
    }

    public void setDropChance(float chance) {
        float clamped = Math.max(0.0f, Math.min(1.0f, chance));
        this.dropChanceProperty.setValue(Float.valueOf(clamped));
        this.invalidateIfNecessary();
    }

    public String formatDropChance() {
        return this.category.formatDropChance(this.getDropChance());
    }

    public boolean isDropChanceTextValid(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        try {
            Float.parseFloat(text);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public void setDropChanceFromText(String text) {
        if (!this.isDropChanceTextValid(text)) {
            this.setValid(false);
            return;
        }
        try {
            this.setDropChance(Float.parseFloat(text));
        }
        catch (NumberFormatException ex) {
            this.setValid(false);
        }
    }

    public class_2487 createItemTag() {
        class_1799 stack = this.getItemStack();
        if (stack.method_7960()) {
            return new class_2487();
        }
        return (class_2487)stack.method_57376(ClientUtil.registryAccess(), (class_2520)new class_2487());
    }

    public void markAsDefault() {
        this.defaultItem = this.getItemStack().method_7972();
        this.defaultDropChance = this.getDropChance();
    }

    public float getDefaultDropChance() {
        return this.defaultDropChance;
    }

    @Override
    public void reset() {
        this.setItemStack(this.defaultItem.method_7972());
        this.setDropChance(this.defaultDropChance);
    }

    @Override
    public void apply() {
        this.markAsDefault();
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.ENTITY_EQUIPMENT;
    }

    private void invalidateIfNecessary() {
        Float value = (Float)this.dropChanceProperty.getValue();
        boolean valid = value != null && Float.isFinite(value.floatValue()) && value.floatValue() >= 0.0f && value.floatValue() <= 1.0f;
        this.setValid(valid);
    }

    public boolean isDefaultDropChance() {
        return Math.abs(this.getDropChance() - this.slot.defaultDropChance()) < 1.0E-4f;
    }

    @Override
    public boolean isResetable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityEquipmentEntryModel)) {
            return false;
        }
        EntityEquipmentEntryModel that = (EntityEquipmentEntryModel)o;
        return this.slot == that.slot;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.slot});
    }
}

