/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.entity;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class VillagerTradeEntryModel
extends EntryModel {
    private static final Set<String> KNOWN_KEYS = Set.of("buy", "buyB", "sell", "maxUses", "uses", "demand", "specialPrice", "priceMultiplier", "rewardExp", "xp");
    private final ObjectProperty<class_1799> primaryItemProperty;
    private final ObjectProperty<class_1799> secondaryItemProperty;
    private final ObjectProperty<class_1799> resultItemProperty;
    private final IntegerProperty maxUsesProperty;
    private final IntegerProperty usesProperty;
    private final IntegerProperty demandProperty;
    private final IntegerProperty specialPriceProperty;
    private final ObjectProperty<Float> priceMultiplierProperty;
    private final BooleanProperty rewardExpProperty;
    private final IntegerProperty xpProperty;
    private class_1799 defaultPrimaryItem;
    private class_1799 defaultSecondaryItem;
    private class_1799 defaultResultItem;
    private int defaultMaxUses;
    private int defaultUses;
    private int defaultDemand;
    private int defaultSpecialPrice;
    private float defaultPriceMultiplier;
    private boolean defaultRewardExp;
    private int defaultXp;
    private final class_2487 originalTag;
    private boolean editorFieldsValid = true;

    public VillagerTradeEntryModel(EntityCategoryModel category, class_2487 tag) {
        super(category);
        class_2487 source = tag == null ? new class_2487() : tag.method_10553();
        this.primaryItemProperty = ObjectProperty.create(VillagerTradeEntryModel.readItem(source, "buy"));
        this.secondaryItemProperty = ObjectProperty.create(VillagerTradeEntryModel.readItem(source, "buyB"));
        this.resultItemProperty = ObjectProperty.create(VillagerTradeEntryModel.readItem(source, "sell"));
        this.maxUsesProperty = IntegerProperty.create(source.method_10573("maxUses", 3) ? source.method_10550("maxUses") : 12);
        this.usesProperty = IntegerProperty.create(source.method_10573("uses", 3) ? source.method_10550("uses") : 0);
        this.demandProperty = IntegerProperty.create(source.method_10573("demand", 3) ? source.method_10550("demand") : 0);
        this.specialPriceProperty = IntegerProperty.create(source.method_10573("specialPrice", 3) ? source.method_10550("specialPrice") : 0);
        this.priceMultiplierProperty = ObjectProperty.create(Float.valueOf(source.method_10573("priceMultiplier", 5) ? source.method_10583("priceMultiplier") : 0.05f));
        this.rewardExpProperty = BooleanProperty.create(!source.method_10573("rewardExp", 1) || source.method_10577("rewardExp"));
        this.xpProperty = IntegerProperty.create(source.method_10573("xp", 3) ? source.method_10550("xp") : 0);
        this.originalTag = source;
        this.captureDefaults();
        this.setupListeners();
    }

    private void setupListeners() {
        this.primaryItemProperty.addListener(value -> this.updateValidity());
        this.resultItemProperty.addListener(value -> this.updateValidity());
        this.maxUsesProperty.addListener(value -> this.updateValidity());
        this.usesProperty.addListener(value -> this.updateValidity());
        this.priceMultiplierProperty.addListener(value -> this.updateValidity());
        this.updateValidity();
    }

    private static class_1799 readItem(class_2487 tag, String key) {
        if (!tag.method_10573(key, 10)) {
            return class_1799.field_8037;
        }
        return class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)tag.method_10562(key));
    }

    private class_1799 sanitize(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 copy = stack.method_7972();
        if (copy.method_7947() <= 0) {
            copy.method_7939(1);
        }
        return copy;
    }

    public ObjectProperty<class_1799> primaryItemProperty() {
        return this.primaryItemProperty;
    }

    public class_1799 getPrimaryItem() {
        class_1799 stack = (class_1799)this.primaryItemProperty.getValue();
        return stack == null ? class_1799.field_8037 : stack;
    }

    public void setPrimaryItem(class_1799 stack) {
        class_1799 sanitized = this.sanitize(stack);
        if (!class_1799.method_7973((class_1799)sanitized, (class_1799)this.getPrimaryItem())) {
            this.primaryItemProperty.setValue(sanitized);
        }
    }

    public ObjectProperty<class_1799> secondaryItemProperty() {
        return this.secondaryItemProperty;
    }

    public class_1799 getSecondaryItem() {
        class_1799 stack = (class_1799)this.secondaryItemProperty.getValue();
        return stack == null ? class_1799.field_8037 : stack;
    }

    public void setSecondaryItem(class_1799 stack) {
        class_1799 sanitized = this.sanitize(stack);
        if (!class_1799.method_7973((class_1799)sanitized, (class_1799)this.getSecondaryItem())) {
            this.secondaryItemProperty.setValue(sanitized);
        }
    }

    public ObjectProperty<class_1799> resultItemProperty() {
        return this.resultItemProperty;
    }

    public class_1799 getResultItem() {
        class_1799 stack = (class_1799)this.resultItemProperty.getValue();
        return stack == null ? class_1799.field_8037 : stack;
    }

    public void setResultItem(class_1799 stack) {
        class_1799 sanitized = this.sanitize(stack);
        if (!class_1799.method_7973((class_1799)sanitized, (class_1799)this.getResultItem())) {
            this.resultItemProperty.setValue(sanitized);
        }
    }

    public IntegerProperty maxUsesProperty() {
        return this.maxUsesProperty;
    }

    public int getMaxUses() {
        return this.maxUsesProperty.getValue();
    }

    public void setMaxUses(int value) {
        this.maxUsesProperty.setValue(Math.max(1, value));
    }

    public IntegerProperty usesProperty() {
        return this.usesProperty;
    }

    public int getUses() {
        return this.usesProperty.getValue();
    }

    public void setUses(int value) {
        this.usesProperty.setValue(Math.max(0, value));
    }

    public IntegerProperty demandProperty() {
        return this.demandProperty;
    }

    public int getDemand() {
        return this.demandProperty.getValue();
    }

    public void setDemand(int value) {
        this.demandProperty.setValue(value);
    }

    public IntegerProperty specialPriceProperty() {
        return this.specialPriceProperty;
    }

    public int getSpecialPrice() {
        return this.specialPriceProperty.getValue();
    }

    public void setSpecialPrice(int value) {
        this.specialPriceProperty.setValue(value);
    }

    public ObjectProperty<Float> priceMultiplierProperty() {
        return this.priceMultiplierProperty;
    }

    public float getPriceMultiplier() {
        Float value = (Float)this.priceMultiplierProperty.getValue();
        return value == null ? 0.05f : value.floatValue();
    }

    public void setPriceMultiplier(float value) {
        float sanitized = Float.isFinite(value) ? value : 0.05f;
        this.priceMultiplierProperty.setValue(Float.valueOf(sanitized));
    }

    public BooleanProperty rewardExpProperty() {
        return this.rewardExpProperty;
    }

    public boolean isRewardExp() {
        return this.rewardExpProperty.getValue();
    }

    public void setRewardExp(boolean value) {
        this.rewardExpProperty.setValue(value);
    }

    public IntegerProperty xpProperty() {
        return this.xpProperty;
    }

    public int getXp() {
        return this.xpProperty.getValue();
    }

    public void setXp(int value) {
        this.xpProperty.setValue(Math.max(0, value));
    }

    public boolean hasSecondaryItem() {
        return !this.getSecondaryItem().method_7960();
    }

    public boolean isTradeValid() {
        return this.isValid() && !this.getResultItem().method_7960() && this.getMaxUses() >= this.getUses();
    }

    public class_2487 toCompoundTag() {
        class_2487 tag = new class_2487();
        if (this.originalTag != null) {
            HashSet keys = new HashSet(this.originalTag.method_10541());
            for (String key : keys) {
                class_2520 value;
                if (KNOWN_KEYS.contains(key) || (value = this.originalTag.method_10580(key)) == null) continue;
                tag.method_10566(key, value.method_10707());
            }
        }
        tag.method_10566("buy", (class_2520)this.createItemTag(this.getPrimaryItem()));
        if (this.hasSecondaryItem()) {
            tag.method_10566("buyB", (class_2520)this.createItemTag(this.getSecondaryItem()));
        } else {
            tag.method_10551("buyB");
        }
        tag.method_10566("sell", (class_2520)this.createItemTag(this.getResultItem()));
        tag.method_10569("maxUses", Math.max(1, this.getMaxUses()));
        tag.method_10569("uses", Math.max(0, this.getUses()));
        tag.method_10569("demand", this.getDemand());
        tag.method_10569("specialPrice", this.getSpecialPrice());
        tag.method_10548("priceMultiplier", this.getPriceMultiplier());
        tag.method_10556("rewardExp", this.isRewardExp());
        tag.method_10569("xp", Math.max(0, this.getXp()));
        return tag;
    }

    private class_2487 createItemTag(class_1799 stack) {
        if (stack.method_7960()) {
            return new class_2487();
        }
        return (class_2487)stack.method_57376(ClientUtil.registryAccess(), (class_2520)new class_2487());
    }

    @Override
    public void reset() {
        this.setPrimaryItem(this.defaultPrimaryItem);
        this.setSecondaryItem(this.defaultSecondaryItem);
        this.setResultItem(this.defaultResultItem);
        this.setMaxUses(this.defaultMaxUses);
        this.setUses(this.defaultUses);
        this.setDemand(this.defaultDemand);
        this.setSpecialPrice(this.defaultSpecialPrice);
        this.setPriceMultiplier(this.defaultPriceMultiplier);
        this.setRewardExp(this.defaultRewardExp);
        this.setXp(this.defaultXp);
        this.setValid(true);
        this.setEditorFieldsValid(true);
    }

    @Override
    public void apply() {
        this.captureDefaults();
        this.setValid(true);
    }

    private void captureDefaults() {
        this.defaultPrimaryItem = this.getPrimaryItem().method_7972();
        this.defaultSecondaryItem = this.getSecondaryItem().method_7972();
        this.defaultResultItem = this.getResultItem().method_7972();
        this.defaultMaxUses = this.getMaxUses();
        this.defaultUses = this.getUses();
        this.defaultDemand = this.getDemand();
        this.defaultSpecialPrice = this.getSpecialPrice();
        this.defaultPriceMultiplier = this.getPriceMultiplier();
        this.defaultRewardExp = this.isRewardExp();
        this.defaultXp = this.getXp();
    }

    private void updateValidity() {
        Float multiplier;
        boolean valid = true;
        if (this.getResultItem().method_7960()) {
            valid = false;
        }
        if (this.getMaxUses() < 1) {
            valid = false;
        }
        if (this.getUses() < 0 || this.getUses() > this.getMaxUses()) {
            valid = false;
        }
        if ((multiplier = (Float)this.priceMultiplierProperty.getValue()) == null || !Float.isFinite(multiplier.floatValue())) {
            valid = false;
        }
        if (!this.editorFieldsValid) {
            valid = false;
        }
        this.setValid(valid);
    }

    public void setEditorFieldsValid(boolean value) {
        if (this.editorFieldsValid != value) {
            this.editorFieldsValid = value;
            this.updateValidity();
        }
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.VILLAGER_TRADE;
    }
}

