/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.DoubleProperty;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionEffectEntryModel;

public class FoodEffectEntryModel
extends PotionEffectEntryModel {
    private final DoubleProperty probabilityProperty;
    private double defaultProbability;
    private final FoodEffectConsumer foodCallback;

    public FoodEffectEntryModel(CategoryModel category, String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, double probability, FoodEffectConsumer callback) {
        super(category, id, amplifier, duration, ambient, showParticles, showIcon, entry -> {});
        this.probabilityProperty = DoubleProperty.create(probability);
        this.defaultProbability = probability;
        this.foodCallback = callback;
    }

    @Override
    public void apply() {
        this.foodCallback.consume((String)this.getValue(), this.getAmplifier(), this.getDuration(), this.isAmbient(), this.isShowParticles(), this.isShowIcon(), (float)this.getProbability());
        super.apply();
        this.defaultProbability = this.getProbability();
    }

    @Override
    public void reset() {
        super.reset();
        this.setProbability(this.defaultProbability);
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.FOOD_EFFECT;
    }

    public double getProbability() {
        return this.probabilityProperty().getValue();
    }

    public void setProbability(double value) {
        this.probabilityProperty().setValue(value);
    }

    public DoubleProperty probabilityProperty() {
        return this.probabilityProperty;
    }

    @FunctionalInterface
    public static interface FoodEffectConsumer {
        public void consume(String var1, int var2, int var3, boolean var4, boolean var5, boolean var6, float var7);
    }
}

