/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.event.ObservableValueChangeListener;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.FoodComponentState;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ItemSelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Optional;
import net.minecraft.class_1799;

public class FoodUsingConvertsToEntryModel
extends ItemSelectionEntryModel {
    private final ObjectProperty<class_1799> previewStackProperty;
    private final FoodComponentState state;

    public static FoodUsingConvertsToEntryModel create(CategoryModel category, FoodComponentState state) {
        FoodUsingConvertsToEntryModel model = new FoodUsingConvertsToEntryModel(category, state);
        model.initialize();
        return model;
    }

    private FoodUsingConvertsToEntryModel(CategoryModel category, FoodComponentState state) {
        super(category, ModTexts.gui("using_converts_to"), state.getUsingConvertsToId(), state::setUsingConvertsToId);
        this.state = state;
        this.previewStackProperty = ObjectProperty.create(class_1799.field_8037);
    }

    private void initialize() {
        this.valueProperty().addListener(new UsingConvertsToListener(this.state, this.previewStackProperty));
        this.refreshPreviewFromState();
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.FOOD_USING_CONVERTS_TO;
    }

    public ObjectProperty<class_1799> previewStackProperty() {
        return this.previewStackProperty;
    }

    public class_1799 getPreviewStack() {
        return (class_1799)this.previewStackProperty().getValue();
    }

    public void refreshPreviewFromState() {
        FoodUsingConvertsToEntryModel.updatePreviewFromState(this.state, this.previewStackProperty);
    }

    public Optional<class_1799> getEditableStack() {
        return this.state.getUsingConvertsToEditorStack();
    }

    public void useStack(class_1799 stack) {
        this.state.useCustomUsingConvertsTo(stack);
        if (!Optional.ofNullable((String)this.getValue()).orElse("").equals(this.state.getUsingConvertsToId())) {
            this.setValue(this.state.getUsingConvertsToId());
        } else {
            this.refreshPreviewFromState();
        }
    }

    public void clearStack() {
        this.state.useCustomUsingConvertsTo(class_1799.field_8037);
        this.setValue(this.state.getUsingConvertsToId());
    }

    private static void updatePreviewFromState(FoodComponentState state, ObjectProperty<class_1799> previewProperty) {
        class_1799 stack = state.getUsingConvertsToPreview().map(class_1799::method_7972).orElse(class_1799.field_8037);
        previewProperty.setValue(stack);
    }

    private static final class UsingConvertsToListener
    implements ObservableValueChangeListener<String> {
        private final FoodComponentState state;
        private final ObjectProperty<class_1799> previewProperty;

        private UsingConvertsToListener(FoodComponentState state, ObjectProperty<class_1799> previewProperty) {
            this.state = state;
            this.previewProperty = previewProperty;
        }

        @Override
        public void onValueChange(String oldValue, String newValue) {
            this.state.setUsingConvertsToId(newValue);
            FoodUsingConvertsToEntryModel.updatePreviewFromState(this.state, this.previewProperty);
        }
    }
}

