/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.screen.model.category.EditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class ItemContainerSlotEntryModel
extends EntryModel {
    private final EditorCategoryModel category;
    private class_1799 defaultStack;
    private final ObjectProperty<class_1799> stackProperty;

    public ItemContainerSlotEntryModel(EditorCategoryModel category, class_1799 stack) {
        super(category);
        this.category = category;
        this.defaultStack = this.sanitize(stack);
        this.stackProperty = ObjectProperty.create(this.defaultStack.method_7972());
        this.stackProperty.addListener(value -> this.setValid(true));
    }

    private class_1799 sanitize(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 copy = stack.method_7972();
        if (copy.method_7947() <= 0) {
            copy.method_7939(1);
        }
        return copy;
    }

    public EditorCategoryModel getContainerCategory() {
        return this.category;
    }

    public class_2561 getSlotLabel() {
        int index = Math.max(0, this.getListIndex());
        return class_2561.method_43470((String)String.format("#%02d", index + 1));
    }

    public ObjectProperty<class_1799> itemStackProperty() {
        return this.stackProperty;
    }

    public class_1799 getItemStack() {
        class_1799 current = (class_1799)this.stackProperty.getValue();
        return current == null ? class_1799.field_8037 : current;
    }

    public void setItemStack(class_1799 stack) {
        class_1799 sanitized = this.sanitize(stack);
        if (!Objects.equals(this.stackProperty.getValue(), sanitized)) {
            this.stackProperty.setValue(sanitized);
        }
    }

    @Override
    public void reset() {
        this.setItemStack(this.defaultStack.method_7972());
    }

    @Override
    public void apply() {
        this.defaultStack = this.getItemStack().method_7972();
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.CONTAINER_SLOT;
    }
}

