/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9292;
import net.minecraft.class_9428;

public class MapDecorationEntryModel
extends EntryModel {
    private final ObjectProperty<String> nameProperty = ObjectProperty.create("");
    private final ObjectProperty<String> typeProperty = ObjectProperty.create("");
    private final ObjectProperty<String> xTextProperty = ObjectProperty.create("");
    private final ObjectProperty<String> zTextProperty = ObjectProperty.create("");
    private final ObjectProperty<String> rotationTextProperty = ObjectProperty.create("");
    private String defaultName = "";
    private String defaultType = "";
    private String defaultXText = "";
    private String defaultZText = "";
    private String defaultRotationText = "";

    public MapDecorationEntryModel(ItemEditorCategoryModel category) {
        this(category, "", null);
    }

    public MapDecorationEntryModel(ItemEditorCategoryModel category, String name, class_9292.class_9293 entry) {
        super(category);
        if (name != null) {
            this.nameProperty.setValue(name);
        }
        if (entry != null) {
            entry.comp_2405().method_40230().map(class_5321::method_29177).map(class_2960::toString).ifPresent(this.typeProperty::setValue);
            this.xTextProperty.setValue(this.formatDouble(entry.comp_2406()));
            this.zTextProperty.setValue(this.formatDouble(entry.comp_2407()));
            this.rotationTextProperty.setValue(this.formatDouble(entry.comp_2408()));
        }
        this.captureDefaults();
    }

    public ObjectProperty<String> nameProperty() {
        return this.nameProperty;
    }

    public ObjectProperty<String> typeProperty() {
        return this.typeProperty;
    }

    public ObjectProperty<String> xTextProperty() {
        return this.xTextProperty;
    }

    public ObjectProperty<String> zTextProperty() {
        return this.zTextProperty;
    }

    public ObjectProperty<String> rotationTextProperty() {
        return this.rotationTextProperty;
    }

    public String getName() {
        String value = (String)this.nameProperty.getValue();
        return value == null ? "" : value.trim();
    }

    public String getTypeId() {
        String value = (String)this.typeProperty.getValue();
        if (value == null || value.trim().isEmpty()) {
            return "";
        }
        class_2960 normalized = DecorationTypeOption.normalizeId(value);
        return normalized == null ? "" : normalized.toString();
    }

    public String getXText() {
        String value = (String)this.xTextProperty.getValue();
        return value == null ? "" : value.trim();
    }

    public String getZText() {
        String value = (String)this.zTextProperty.getValue();
        return value == null ? "" : value.trim();
    }

    public String getRotationText() {
        String value = (String)this.rotationTextProperty.getValue();
        return value == null ? "" : value.trim();
    }

    public boolean isBlank() {
        return this.getName().isEmpty() && this.getTypeId().isEmpty();
    }

    public Optional<Map.Entry<String, class_9292.class_9293>> buildDecoration(class_7225.class_7226<class_9428> lookup) {
        String name = this.getName();
        String type = this.getTypeId();
        if (name.isEmpty() && type.isEmpty() && this.getXText().isEmpty() && this.getZText().isEmpty() && this.getRotationText().isEmpty()) {
            this.setValid(true);
            return Optional.empty();
        }
        if (name.isEmpty() || type.isEmpty()) {
            this.setValid(false);
            return Optional.empty();
        }
        if (lookup == null) {
            this.setValid(false);
            return Optional.empty();
        }
        class_2960 typeId = class_2960.method_12829((String)type);
        if (typeId == null) {
            this.setValid(false);
            return Optional.empty();
        }
        Optional holder = lookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_50082, (class_2960)typeId));
        if (holder.isEmpty()) {
            this.setValid(false);
            return Optional.empty();
        }
        Double parsedX = this.parseDouble(this.getXText());
        Double parsedZ = this.parseDouble(this.getZText());
        Float parsedRotation = this.parseFloat(this.getRotationText());
        if (parsedX == null || parsedZ == null || parsedRotation == null) {
            this.setValid(false);
            return Optional.empty();
        }
        class_9292.class_9293 entry = new class_9292.class_9293((class_6880)holder.get(), parsedX.doubleValue(), parsedZ.doubleValue(), parsedRotation.floatValue());
        this.setValid(true);
        return Optional.of(new AbstractMap.SimpleEntry<String, class_9292.class_9293>(name, entry));
    }

    private Double parseDouble(String value) {
        if (value.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private Float parseFloat(String value) {
        if (value.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private String formatDouble(double value) {
        if (Math.abs(value - Math.rint(value)) < 1.0E-6) {
            return Long.toString(Math.round(value));
        }
        String text = Double.toString(value);
        if (text.contains(".")) {
            while (text.endsWith("0")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    private void captureDefaults() {
        this.defaultName = this.getName();
        this.defaultType = this.getTypeId();
        this.defaultXText = this.getXText();
        this.defaultZText = this.getZText();
        this.defaultRotationText = this.getRotationText();
    }

    @Override
    public void reset() {
        this.nameProperty.setValue(this.defaultName);
        this.typeProperty.setValue(this.defaultType);
        this.xTextProperty.setValue(this.defaultXText);
        this.zTextProperty.setValue(this.defaultZText);
        this.rotationTextProperty.setValue(this.defaultRotationText);
        this.setValid(true);
    }

    @Override
    public void apply() {
        this.captureDefaults();
        this.setValid(true);
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.MAP_DECORATION;
    }

    public record DecorationTypeOption(class_2960 id, class_2561 displayName) {
        private static final List<DecorationTypeOption> DEFAULT_OPTIONS = List.of(DecorationTypeOption.of("minecraft:player"), DecorationTypeOption.of("minecraft:player_off_map"), DecorationTypeOption.of("minecraft:player_off_limits"), DecorationTypeOption.of("minecraft:player_dead"), DecorationTypeOption.of("minecraft:frame"), DecorationTypeOption.of("minecraft:red_marker"), DecorationTypeOption.of("minecraft:blue_marker"), DecorationTypeOption.of("minecraft:target_point"), DecorationTypeOption.of("minecraft:mansion"), DecorationTypeOption.of("minecraft:monument"), DecorationTypeOption.of("minecraft:banner_white"), DecorationTypeOption.of("minecraft:banner_orange"), DecorationTypeOption.of("minecraft:banner_magenta"), DecorationTypeOption.of("minecraft:banner_light_blue"), DecorationTypeOption.of("minecraft:banner_yellow"), DecorationTypeOption.of("minecraft:banner_lime"), DecorationTypeOption.of("minecraft:banner_pink"), DecorationTypeOption.of("minecraft:banner_gray"), DecorationTypeOption.of("minecraft:banner_light_gray"), DecorationTypeOption.of("minecraft:banner_cyan"), DecorationTypeOption.of("minecraft:banner_purple"), DecorationTypeOption.of("minecraft:banner_blue"), DecorationTypeOption.of("minecraft:banner_brown"), DecorationTypeOption.of("minecraft:banner_green"), DecorationTypeOption.of("minecraft:banner_red"), DecorationTypeOption.of("minecraft:banner_black"), DecorationTypeOption.of("minecraft:trial_chambers"), DecorationTypeOption.of("minecraft:pale_oak"), DecorationTypeOption.of("minecraft:wind_charge"));

        public String getResourceId() {
            return this.id.toString();
        }

        public class_2561 getDisplayName() {
            return this.displayName;
        }

        public static List<DecorationTypeOption> collect(class_7225.class_7226<class_9428> lookup) {
            if (lookup == null) {
                return DEFAULT_OPTIONS;
            }
            List<DecorationTypeOption> options = lookup.method_42017().map(holder -> DecorationTypeOption.of(holder.method_40237().method_29177())).sorted(Comparator.comparing(DecorationTypeOption::getResourceId)).toList();
            return options.isEmpty() ? DEFAULT_OPTIONS : options;
        }

        public static List<DecorationTypeOption> defaults() {
            return DEFAULT_OPTIONS;
        }

        public static DecorationTypeOption find(Collection<DecorationTypeOption> options, String resourceId) {
            if (options == null || options.isEmpty() || resourceId == null || resourceId.isBlank()) {
                return null;
            }
            class_2960 normalized = DecorationTypeOption.normalize(resourceId);
            if (normalized == null) {
                return null;
            }
            String idString = normalized.toString();
            for (DecorationTypeOption option : options) {
                if (!option.getResourceId().equals(idString)) continue;
                return option;
            }
            return null;
        }

        public static class_2960 normalizeId(String resourceId) {
            return DecorationTypeOption.normalize(resourceId);
        }

        private static class_2960 normalize(String resourceId) {
            Object value = resourceId.trim();
            if (!((String)value).contains(":")) {
                value = "minecraft:" + (String)value;
            }
            return class_2960.method_12829((String)value);
        }

        private static DecorationTypeOption of(String id) {
            class_2960 parsed = DecorationTypeOption.normalize(id);
            if (parsed == null) {
                throw new IllegalArgumentException("Invalid map decoration id: " + id);
            }
            return new DecorationTypeOption(parsed, DecorationTypeOption.toDisplayName(parsed));
        }

        private static DecorationTypeOption of(class_2960 id) {
            return new DecorationTypeOption(id, DecorationTypeOption.toDisplayName(id));
        }

        private static class_2561 toDisplayName(class_2960 id) {
            String display = id.method_12832();
            if (display == null || display.isBlank()) {
                display = id.toString();
            }
            display = display.replace(':', ' ').replace('_', ' ');
            String[] parts = display.split("\\s+");
            StringBuilder builder = new StringBuilder();
            for (String part : parts) {
                if (part.isEmpty()) continue;
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(Character.toUpperCase(part.charAt(0)));
                if (part.length() <= 1) continue;
                builder.append(part.substring(1));
            }
            return class_2561.method_43470((String)builder.toString());
        }
    }
}

