/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.SelectionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_5250;

public class PotionEffectEntryModel
extends SelectionEntryModel {
    private final IntegerProperty amplifierProperty;
    private final IntegerProperty durationProperty;
    private final BooleanProperty ambientProperty;
    private final BooleanProperty showParticlesProperty;
    private final BooleanProperty showIconProperty;
    private final BooleanProperty useSecondsProperty;
    private final PotionEffectConsumer callback;
    private boolean defaultUseSeconds;
    private final boolean baseEffect;
    private final class_2487 originalSnapshot;

    public PotionEffectEntryModel(CategoryModel category, String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, PotionEffectConsumer callback) {
        this(category, id, amplifier, duration, ambient, showParticles, showIcon, callback, false, null);
    }

    public PotionEffectEntryModel(CategoryModel category, String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, PotionEffectConsumer callback, boolean baseEffect, class_2487 originalTag) {
        super(category, (class_5250)null, id, (String s) -> {});
        this.amplifierProperty = IntegerProperty.create(amplifier);
        this.durationProperty = IntegerProperty.create(duration);
        this.ambientProperty = BooleanProperty.create(ambient);
        this.showParticlesProperty = BooleanProperty.create(showParticles);
        this.showIconProperty = BooleanProperty.create(showIcon);
        boolean useSeconds = duration % 20 == 0;
        this.useSecondsProperty = BooleanProperty.create(useSeconds);
        this.callback = callback;
        this.defaultUseSeconds = useSeconds;
        this.baseEffect = baseEffect;
        this.originalSnapshot = originalTag == null ? null : PotionEffectEntryModel.normalizeTag(originalTag);
    }

    @Override
    public void apply() {
        this.callback.consume(this);
        super.apply();
        this.defaultUseSeconds = this.isUseSeconds();
    }

    @Override
    public void reset() {
        super.reset();
        this.setUseSeconds(this.defaultUseSeconds);
    }

    public int getAmplifier() {
        return this.amplifierProperty().getValue();
    }

    public IntegerProperty amplifierProperty() {
        return this.amplifierProperty;
    }

    public void setAmplifier(int value) {
        this.amplifierProperty().setValue(value);
    }

    public int getDuration() {
        return this.durationProperty().getValue();
    }

    public IntegerProperty durationProperty() {
        return this.durationProperty;
    }

    public void setDuration(int value) {
        this.durationProperty().setValue(value);
    }

    public boolean isAmbient() {
        return this.ambientProperty().getValue();
    }

    public BooleanProperty ambientProperty() {
        return this.ambientProperty;
    }

    public void setAmbient(boolean value) {
        this.ambientProperty().setValue(value);
    }

    public boolean isShowParticles() {
        return this.showParticlesProperty().getValue();
    }

    public BooleanProperty showParticlesProperty() {
        return this.showParticlesProperty;
    }

    public void setShowParticles(boolean value) {
        this.showParticlesProperty().setValue(value);
    }

    public boolean isShowIcon() {
        return this.showIconProperty().getValue();
    }

    public BooleanProperty showIconProperty() {
        return this.showIconProperty;
    }

    public void setShowIcon(boolean value) {
        this.showIconProperty().setValue(value);
    }

    public boolean isUseSeconds() {
        return this.useSecondsProperty().getValue();
    }

    public BooleanProperty useSecondsProperty() {
        return this.useSecondsProperty;
    }

    public void setUseSeconds(boolean value) {
        this.useSecondsProperty().setValue(value);
    }

    public boolean isBaseEffect() {
        return this.baseEffect;
    }

    public boolean isModifiedFromOriginal() {
        if (!this.baseEffect) {
            return true;
        }
        if (this.originalSnapshot == null) {
            return true;
        }
        return !this.originalSnapshot.equals((Object)PotionEffectEntryModel.normalizeTag(this.toCompoundTag()));
    }

    public class_2487 toCompoundTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("id", (String)this.getValue());
        tag.method_10569("amplifier", this.getAmplifier());
        tag.method_10569("duration", this.getDuration());
        tag.method_10556("ambient", this.isAmbient());
        tag.method_10556("show_particles", this.isShowParticles());
        tag.method_10556("show_icon", this.isShowIcon());
        return tag;
    }

    private static class_2487 normalizeTag(class_2487 tag) {
        class_2487 normalized = new class_2487();
        normalized.method_10582("id", tag.method_10558("id"));
        normalized.method_10569("amplifier", tag.method_10550("amplifier"));
        normalized.method_10569("duration", tag.method_10573("duration", 3) ? tag.method_10550("duration") : 1);
        normalized.method_10556("ambient", tag.method_10577("ambient"));
        boolean showParticles = !tag.method_10573("show_particles", 1) || tag.method_10577("show_particles");
        normalized.method_10556("show_particles", showParticles);
        boolean showIcon = tag.method_10573("show_icon", 1) ? tag.method_10577("show_icon") : true;
        normalized.method_10556("show_icon", showIcon);
        return normalized;
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.POTION_EFFECT;
    }

    @Override
    public List<String> getSuggestions() {
        return ClientCache.getEffectSuggestions();
    }

    @Override
    public class_5250 getSelectionScreenTitle() {
        return ModTexts.EFFECTS;
    }

    @Override
    public List<? extends ListSelectionElementModel> getSelectionItems() {
        return ClientCache.getEffectSelectionItems();
    }

    @FunctionalInterface
    public static interface PotionEffectConsumer {
        public void consume(PotionEffectEntryModel var1);
    }
}

