/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9424;

public class ToolRuleEntryModel
extends EntryModel {
    private final List<class_2960> blockIds = new ArrayList<class_2960>();
    private final List<class_2960> tagIds = new ArrayList<class_2960>();
    private final List<class_2960> defaultBlockIds = new ArrayList<class_2960>();
    private final List<class_2960> defaultTagIds = new ArrayList<class_2960>();
    private final ObjectProperty<DropBehavior> behaviorProperty = ObjectProperty.create(DropBehavior.INHERIT);
    private DropBehavior defaultBehavior = DropBehavior.INHERIT;
    private String speedText = "";
    private Float speedValue;
    private String defaultSpeedText = "";
    private Float defaultSpeedValue;

    public ToolRuleEntryModel(ItemEditorCategoryModel category) {
        this(category, null);
    }

    public ToolRuleEntryModel(ItemEditorCategoryModel category, class_9424.class_9425 rule) {
        super(category);
        if (rule != null) {
            rule.comp_2501().method_45925().ifPresent(tagKey -> this.tagIds.add(tagKey.comp_327()));
            if (this.tagIds.isEmpty()) {
                rule.comp_2501().method_40239().map(holder -> holder.method_40230().map(class_5321::method_29177).orElse(null)).filter(id -> id != null).forEach(this.blockIds::add);
            }
            rule.comp_2502().ifPresent(value -> {
                this.speedValue = value;
                this.speedText = this.trimFloat(value.floatValue());
            });
            this.behaviorProperty.setValue(DropBehavior.fromOptional(rule.comp_2503()));
        }
        this.captureDefaults();
    }

    public List<class_2960> getBlockIds() {
        return List.copyOf(this.blockIds);
    }

    public void setBlockIds(List<class_2960> ids) {
        this.blockIds.clear();
        ids.stream().distinct().forEach(this.blockIds::add);
    }

    public List<class_2960> getTagIds() {
        return List.copyOf(this.tagIds);
    }

    public void setTagIds(List<class_2960> ids) {
        this.tagIds.clear();
        ids.stream().distinct().forEach(this.tagIds::add);
    }

    public void clearSelections() {
        this.blockIds.clear();
        this.tagIds.clear();
    }

    public DropBehavior getBehavior() {
        return (DropBehavior)((Object)this.behaviorProperty.getValue());
    }

    public ObjectProperty<DropBehavior> behaviorProperty() {
        return this.behaviorProperty;
    }

    public void setBehavior(DropBehavior behavior) {
        this.behaviorProperty.setValue(behavior == null ? DropBehavior.INHERIT : behavior);
    }

    public String getSpeedText() {
        return this.speedText;
    }

    public boolean setSpeedText(String text) {
        String trimmed;
        this.speedText = trimmed = text == null ? "" : text.trim();
        if (trimmed.isEmpty()) {
            this.speedValue = null;
            return true;
        }
        try {
            this.speedValue = Float.valueOf(Float.parseFloat(trimmed));
            return true;
        }
        catch (NumberFormatException ex) {
            this.speedValue = null;
            return false;
        }
    }

    public boolean hasSelection() {
        return !this.blockIds.isEmpty() || !this.tagIds.isEmpty();
    }

    public class_2561 getSummaryComponent() {
        if (!this.hasSelection()) {
            return ModTexts.gui("tool_rule_blocks_empty").method_27661().method_27692(class_124.field_1080);
        }
        List<class_2561> entries = this.buildSummaryEntries();
        if (entries.isEmpty()) {
            return ModTexts.gui("tool_rule_blocks_empty").method_27661().method_27692(class_124.field_1080);
        }
        class_5250 first = entries.get(0).method_27661();
        String text = first.getString();
        int maxLength = 255;
        if (text.length() > maxLength) {
            first = class_2561.method_43470((String)(text.substring(0, maxLength - 1) + "...")).method_27696(first.method_10866());
        }
        if (entries.size() > 1) {
            first.method_10852((class_2561)class_2561.method_43470((String)(" +" + (entries.size() - 1))).method_27692(class_124.field_1063));
        }
        return first;
    }

    public List<class_2561> getSummaryTooltip() {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (!this.hasSelection()) {
            tooltip.add((class_2561)ModTexts.gui("tool_rule_blocks_empty").method_27661().method_27692(class_124.field_1080));
        } else {
            this.addSectionLines(tooltip, ModTexts.gui("tool_rule_tags").method_27661(), this.tagIds, true);
            this.addSectionLines(tooltip, ModTexts.gui("tool_rule_blocks").method_27661(), this.blockIds, false);
        }
        tooltip.add((class_2561)class_2561.method_43473());
        tooltip.add((class_2561)this.buildSpeedTooltip());
        tooltip.add((class_2561)this.buildBehaviorTooltip());
        return tooltip;
    }

    private List<class_2561> buildSummaryEntries() {
        ArrayList<class_2561> entries = new ArrayList<class_2561>();
        this.tagIds.forEach(id -> entries.add((class_2561)class_2561.method_43470((String)("#" + String.valueOf(id))).method_27692(class_124.field_1075)));
        this.blockIds.forEach(id -> entries.add((class_2561)class_2561.method_43470((String)id.toString()).method_27692(class_124.field_1068)));
        return entries;
    }

    private void addSectionLines(List<class_2561> tooltip, class_5250 title, List<class_2960> ids, boolean tags) {
        if (ids.isEmpty()) {
            return;
        }
        tooltip.add((class_2561)title.method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(ids.size())).method_27692(class_124.field_1065)));
        ids.forEach(id -> {
            Object text = tags ? "#" + String.valueOf(id) : id.toString();
            tooltip.add((class_2561)class_2561.method_43470((String)("  " + (String)text)).method_27692(tags ? class_124.field_1075 : class_124.field_1068));
        });
    }

    private class_5250 buildSpeedTooltip() {
        class_5250 line = ModTexts.gui("tool_rule_speed").method_27661().method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1063));
        if (this.speedValue != null) {
            line.method_10852((class_2561)class_2561.method_43470((String)this.trimFloat(this.speedValue.floatValue())).method_27692(class_124.field_1065));
        } else if (!this.speedText.isEmpty()) {
            line.method_10852((class_2561)class_2561.method_43470((String)this.speedText).method_27692(class_124.field_1061));
        } else {
            line.method_10852((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1063));
        }
        return line;
    }

    private class_5250 buildBehaviorTooltip() {
        return ModTexts.gui("tool_rule_behavior").method_27661().method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1063)).method_10852((class_2561)((DropBehavior)((Object)this.behaviorProperty.getValue())).getText().method_27661()).method_10852((class_2561)class_2561.method_43470((String)" ").method_27692(class_124.field_1063)).method_10852((class_2561)((DropBehavior)((Object)this.behaviorProperty.getValue())).getDescription().method_27661());
    }

    public Optional<class_9424.class_9425> toRule(class_7225.class_7226<class_2248> lookup) {
        if (!this.hasSelection() || lookup == null) {
            return Optional.empty();
        }
        if (this.tagIds.size() == 1 && this.blockIds.isEmpty()) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)this.tagIds.get(0));
            Optional named = lookup.method_46733(tagKey);
            if (named.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new class_9424.class_9425((class_6885)named.get(), Optional.ofNullable(this.speedValue), ((DropBehavior)((Object)this.behaviorProperty.getValue())).toOptional()));
        }
        LinkedHashSet<class_6880> holders = new LinkedHashSet<class_6880>();
        for (class_2960 tagId : this.tagIds) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagId);
            Optional named = lookup.method_46733(tagKey);
            if (named.isEmpty()) {
                return Optional.empty();
            }
            ((class_6885.class_6888)named.get()).method_40239().forEach(holders::add);
        }
        for (class_2960 blockId : this.blockIds) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)blockId);
            Optional holder = lookup.method_46746(key);
            if (holder.isEmpty()) {
                return Optional.empty();
            }
            holders.add((class_6880)holder.get());
        }
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        class_6885.class_6886 blockSet = class_6885.method_40242(new ArrayList(holders));
        return Optional.of(new class_9424.class_9425((class_6885)blockSet, Optional.ofNullable(this.speedValue), ((DropBehavior)((Object)this.behaviorProperty.getValue())).toOptional()));
    }

    public void setFromRule(class_9424.class_9425 rule) {
        this.tagIds.clear();
        this.blockIds.clear();
        if (rule.comp_2501().method_45925().isPresent()) {
            this.tagIds.add(((class_6862)rule.comp_2501().method_45925().get()).comp_327());
        } else {
            rule.comp_2501().method_40239().map(holder -> holder.method_40230().map(class_5321::method_29177).orElse(null)).filter(id -> id != null).forEach(this.blockIds::add);
        }
        rule.comp_2502().ifPresentOrElse(value -> {
            this.speedValue = value;
            this.speedText = this.trimFloat(value.floatValue());
        }, () -> {
            this.speedValue = null;
            this.speedText = "";
        });
        this.behaviorProperty.setValue(DropBehavior.fromOptional(rule.comp_2503()));
        this.captureDefaults();
    }

    @Override
    public void reset() {
        this.blockIds.clear();
        this.blockIds.addAll(this.defaultBlockIds);
        this.tagIds.clear();
        this.tagIds.addAll(this.defaultTagIds);
        this.behaviorProperty.setValue(this.defaultBehavior);
        this.speedValue = this.defaultSpeedValue;
        this.speedText = this.defaultSpeedText;
        this.setValid(true);
    }

    @Override
    public void apply() {
        this.captureDefaults();
        this.setValid(true);
    }

    private void captureDefaults() {
        this.defaultBlockIds.clear();
        this.defaultBlockIds.addAll(this.blockIds);
        this.defaultTagIds.clear();
        this.defaultTagIds.addAll(this.tagIds);
        this.defaultBehavior = (DropBehavior)((Object)this.behaviorProperty.getValue());
        this.defaultSpeedValue = this.speedValue;
        this.defaultSpeedText = this.speedText;
    }

    private String trimFloat(float value) {
        String text = Float.toString(value);
        if (text.indexOf(46) >= 0) {
            while (text.endsWith("0")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.TOOL_RULE;
    }

    public static enum DropBehavior {
        INHERIT("inherit"),
        ALLOW("allow"),
        DENY("deny");

        private final String translationSuffix;

        private DropBehavior(String translationSuffix) {
            this.translationSuffix = translationSuffix;
        }

        public class_2561 getText() {
            return class_2561.method_43471((String)("cadeditor.gui.tool_rule_behavior." + this.translationSuffix));
        }

        public class_5250 getDescription() {
            return class_2561.method_43471((String)("cadeditor.gui.tool_rule_behavior.desc." + this.translationSuffix)).method_27692(class_124.field_1063);
        }

        public Optional<Boolean> toOptional() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Optional.empty();
                case 1 -> Optional.of(true);
                case 2 -> Optional.of(false);
            };
        }

        public static DropBehavior fromOptional(Optional<Boolean> optional) {
            if (optional.isEmpty()) {
                return INHERIT;
            }
            return optional.get() != false ? ALLOW : DENY;
        }
    }
}

