/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.view.entry.item;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.EnumButton;
import com.github.franckyi.guapi.api.node.Label;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.api.node.builder.EnumButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.LabelBuilder;
import com.github.franckyi.guapi.api.node.builder.TextFieldBuilder;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.MapDecorationEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.EntryView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;

public class MapDecorationEntryView
extends EntryView {
    private static final int LABEL_WIDTH = 110;
    private static final int FIELD_PREF_WIDTH = 180;
    private TextField nameField;
    private TextField xField;
    private TextField zField;
    private TextField rotationField;
    private EnumButton<MapDecorationEntryModel.DecorationTypeOption> typeSelector;

    @Override
    protected Node createContent() {
        return GuapiHelper.vBox(content -> {
            this.nameField = this.sizedTextField((class_2561)ModTexts.MAP_DECORATION_NAME);
            content.add(this.buildRow((class_2561)ModTexts.MAP_DECORATION_NAME, this.nameField));
            this.xField = this.sizedTextField((class_2561)ModTexts.MAP_DECORATION_X);
            content.add(this.buildRow((class_2561)ModTexts.MAP_DECORATION_X, this.xField));
            this.zField = this.sizedTextField((class_2561)ModTexts.MAP_DECORATION_Z);
            content.add(this.buildRow((class_2561)ModTexts.MAP_DECORATION_Z, this.zField));
            this.rotationField = this.sizedTextField((class_2561)ModTexts.MAP_DECORATION_ROTATION);
            content.add(this.buildRow((class_2561)ModTexts.MAP_DECORATION_ROTATION, this.rotationField));
            this.typeSelector = (EnumButton)((EnumButtonBuilder)((EnumButtonBuilder)((EnumButtonBuilder)((EnumButtonBuilder)GuapiHelper.enumButton(MapDecorationEntryModel.DecorationTypeOption.defaults()).prefHeight(16)).prefWidth(180)).maxWidth(Integer.MAX_VALUE)).textFactory(MapDecorationEntryModel.DecorationTypeOption::getDisplayName)).tooltip(new class_2561[]{ModTexts.MAP_DECORATION_TYPE});
            content.add(this.buildRow((class_2561)ModTexts.MAP_DECORATION_TYPE, this.typeSelector));
            content.spacing(4);
        }).maxWidth(Integer.MAX_VALUE);
    }

    private TextField sizedTextField(class_2561 placeholderText) {
        return ((TextFieldBuilder)((TextFieldBuilder)((TextFieldBuilder)GuapiHelper.textField().prefHeight(16)).prefWidth(180)).maxWidth(Integer.MAX_VALUE)).placeholder(placeholderText);
    }

    private Node buildRow(class_2561 labelText, Node field) {
        return GuapiHelper.hBox(row -> {
            row.add(this.createLabel(labelText));
            row.add(field, 1);
            ((HBoxBuilder)row.spacing(6)).align(GuapiHelper.CENTER_LEFT);
        }).maxWidth(Integer.MAX_VALUE);
    }

    private Label createLabel(class_2561 labelText) {
        return ((LabelBuilder)((LabelBuilder)GuapiHelper.label().label(labelText)).prefWidth(110)).textAlign(GuapiHelper.CENTER_RIGHT);
    }

    public void setTypeOptions(List<MapDecorationEntryModel.DecorationTypeOption> options) {
        MapDecorationEntryModel.DecorationTypeOption matched;
        MapDecorationEntryModel.DecorationTypeOption current = this.typeSelector.getValue();
        this.typeSelector.getValues().setAll((Collection<MapDecorationEntryModel.DecorationTypeOption>)options);
        if (options.isEmpty()) {
            this.typeSelector.setValue(null);
            return;
        }
        if (current != null && (matched = MapDecorationEntryModel.DecorationTypeOption.find(options, current.getResourceId())) != null) {
            this.typeSelector.setValue(matched);
            return;
        }
        this.typeSelector.setValue(options.get(0));
    }

    public TextField getNameField() {
        return this.nameField;
    }

    public TextField getXField() {
        return this.xField;
    }

    public TextField getZField() {
        return this.zField;
    }

    public TextField getRotationField() {
        return this.rotationField;
    }

    public EnumButton<MapDecorationEntryModel.DecorationTypeOption> getTypeSelector() {
        return this.typeSelector;
    }
}

