/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.network;

import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorRequest;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorResponse;
import com.github.rinorsi.cadeditor.common.network.AbstractEditorUpdate;
import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import com.mojang.serialization.Codec;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class BlockEditorPacket {

    public static class Update
    extends AbstractEditorUpdate<RequestData, ResponseData> {
        public static final PacketSerializer<Update> SERIALIZER = new AbstractEditorUpdate.Serializer<Update, RequestData, ResponseData>(){

            @Override
            public Update createInstance() {
                return new Update();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<ResponseData> getResponseDataSerializer() {
                return ResponseData.SERIALIZER;
            }
        };

        private Update() {
        }

        public Update(Response response, class_2680 blockState, class_2487 tag) {
            super((RequestData)response.getRequestData(), new ResponseData(blockState, tag));
        }

        public class_2338 getBlockPos() {
            return ((RequestData)this.getRequestData()).blockPos();
        }

        public class_2680 getBlockState() {
            return ((ResponseData)this.getResponseData()).blockState();
        }

        public class_2487 getTag() {
            return ((ResponseData)this.getResponseData()).tag();
        }
    }

    public static class Response
    extends AbstractEditorResponse<RequestData, ResponseData> {
        public static final PacketSerializer<Response> SERIALIZER = new AbstractEditorResponse.Serializer<Response, RequestData, ResponseData>(){

            @Override
            public Response createInstance() {
                return new Response();
            }

            @Override
            protected PacketSerializer<ResponseData> getResponseDataSerializer() {
                return ResponseData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Response() {
        }

        public Response(Request request, boolean hasPermission, class_2680 blockState, class_2487 tag) {
            super(request, hasPermission, new ResponseData(blockState, tag));
        }

        public class_2338 getBlockPos() {
            return ((RequestData)this.getRequestData()).blockPos();
        }

        public class_2680 getBlockState() {
            return ((ResponseData)this.getResponseData()).blockState();
        }

        public class_2487 getTag() {
            return ((ResponseData)this.getResponseData()).tag();
        }
    }

    public static class Request
    extends AbstractEditorRequest<RequestData> {
        public static final PacketSerializer<Request> SERIALIZER = new AbstractEditorRequest.Serializer<Request, RequestData>(){

            @Override
            public Request createInstance() {
                return new Request();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Request() {
        }

        public Request(EditorType editorType, class_2338 blockPos) {
            super(editorType, new RequestData(blockPos));
        }

        public class_2338 getBlockPos() {
            return ((RequestData)this.getRequestData()).blockPos();
        }
    }

    protected record ResponseData(class_2680 blockState, class_2487 tag) {
        private static final class_9139<class_9129, class_2680> BLOCK_STATE_STREAM_CODEC = class_9135.method_58002((Codec)class_2680.field_24734);
        public static final PacketSerializer<ResponseData> SERIALIZER = new PacketSerializer<ResponseData>(){

            @Override
            public void write(ResponseData obj, class_2540 buf) {
                class_9129 registryBuf = ResponseData.requireRegistryBuf(buf);
                BLOCK_STATE_STREAM_CODEC.encode((Object)registryBuf, (Object)obj.blockState());
                buf.method_10794((class_2520)obj.tag());
            }

            @Override
            public ResponseData read(class_2540 buf) {
                class_9129 registryBuf = ResponseData.requireRegistryBuf(buf);
                return new ResponseData((class_2680)BLOCK_STATE_STREAM_CODEC.decode((Object)registryBuf), buf.method_10798());
            }
        };

        private static class_9129 requireRegistryBuf(class_2540 buf) {
            if (buf instanceof class_9129) {
                class_9129 registryBuf = (class_9129)buf;
                return registryBuf;
            }
            throw new IllegalStateException("Block editor packets require registry-aware buffers");
        }
    }

    protected record RequestData(class_2338 blockPos) {
        public static final PacketSerializer<RequestData> SERIALIZER = new PacketSerializer<RequestData>(){

            @Override
            public void write(RequestData obj, class_2540 buf) {
                buf.method_10807(obj.blockPos());
            }

            @Override
            public RequestData read(class_2540 buf) {
                return new RequestData(buf.method_10811());
            }
        };
    }
}

