/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.mixin;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.InjectionPoint;

public final class CADEditorMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"CAD Editor");
    private static final String MIXIN_EXTRAS_BOOTSTRAP = "com.llamalad7.mixinextras.MixinExtrasBootstrap";

    public void onLoad(String mixinPackage) {
        try {
            Class<?> bootstrapClass = Class.forName(MIXIN_EXTRAS_BOOTSTRAP);
            Method initMethod = bootstrapClass.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
            this.registerUppercaseMixinExtrasAliases();
        }
        catch (ClassNotFoundException bootstrapClass) {
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            LOGGER.error("Failed to initialise Mixin Extras", (Throwable)exception);
            throw new IllegalStateException("Unable to bootstrap Mixin Extras", exception);
        }
    }

    private void registerUppercaseMixinExtrasAliases() {
        try {
            Field typesField = InjectionPoint.class.getDeclaredField("types");
            typesField.setAccessible(true);
            Map types = (Map)typesField.get(null);
            if (types == null || types.isEmpty()) {
                return;
            }
            HashMap aliases = new HashMap();
            for (Map.Entry entry : types.entrySet()) {
                String uppercaseId;
                String id = (String)entry.getKey();
                if (!id.startsWith("mixinextras:") || types.containsKey(uppercaseId = id.toUpperCase(Locale.ROOT))) continue;
                aliases.put(uppercaseId, entry.getValue());
            }
            if (aliases.isEmpty()) {
                return;
            }
            types.putAll(aliases);
            LOGGER.info("Registered {} uppercase alias(es) for Mixin Extras injection points", (Object)aliases.size());
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            LOGGER.warn("Failed to register uppercase aliases for Mixin Extras injection points", (Throwable)exception);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

