/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableObjectValue;
import com.github.franckyi.databindings.api.ObservableValue;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.event.MouseButtonEvent;
import com.github.franckyi.guapi.api.event.ScreenEvent;
import com.github.franckyi.guapi.api.event.ScreenEventListener;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.Scene;
import com.github.franckyi.guapi.api.node.ScreenEventHandler;
import com.github.franckyi.guapi.api.util.Insets;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.franckyi.guapi.base.event.ScreenEventHandlerDelegate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_332;

public abstract class AbstractScene
implements Scene {
    protected final ObjectProperty<Node> focusedProperty = ObjectProperty.create();
    protected final ObjectProperty<Node> hoveredProperty = ObjectProperty.create();
    protected final ScreenEventHandler eventHandlerDelegate = new ScreenEventHandlerDelegate();
    protected final List<Consumer<Scene>> onShowListeners = new ArrayList<Consumer<Scene>>();
    protected final List<Consumer<Scene>> onHideListeners = new ArrayList<Consumer<Scene>>();
    private final ObjectProperty<Node> rootProperty = ObjectProperty.create();
    private final BooleanProperty fullScreenProperty = BooleanProperty.create();
    private final IntegerProperty widthProperty = IntegerProperty.create(Integer.MAX_VALUE);
    private final IntegerProperty heightProperty = IntegerProperty.create(Integer.MAX_VALUE);
    private final ObjectProperty<Insets> paddingProperty = ObjectProperty.create(Insets.NONE);
    private final BooleanProperty texturedBackgroundProperty = BooleanProperty.create();
    private final BooleanProperty closeOnEscProperty = BooleanProperty.create(true);
    private final ObservableObjectValue<Node> focusedPropertyReadOnly = ObservableObjectValue.readOnly(this.focusedProperty);
    private final ObservableObjectValue<Node> hoveredPropertyReadOnly = ObservableObjectValue.readOnly(this.hoveredProperty);
    private final ObservableValue<Scene> sceneProperty = ObservableValue.unmodifiable(this);
    private final ObservableBooleanValue disabledProperty = ObservableBooleanValue.FALSE;
    protected boolean shouldUpdateChildrenPos;

    protected AbstractScene() {
        this(null);
    }

    protected AbstractScene(Node root) {
        this(root, false);
    }

    protected AbstractScene(Node root, boolean fullScreen) {
        this(root, fullScreen, false);
    }

    protected AbstractScene(Node root, boolean fullScreen, boolean texturedBackground) {
        this.rootProperty().addListener((oldVal, newVal) -> {
            if (oldVal != null && oldVal.getParent() == this) {
                oldVal.setParent(null);
                this.bindFullScreen((Node)oldVal, false);
            }
            if (newVal != null) {
                if (newVal.getParent() != null) {
                    Guapi.getDefaultLogger().error(Guapi.LOG_MARKER, "Can't set Node \"" + String.valueOf(newVal) + "\" as Scene root: node already has a Parent \"" + String.valueOf(newVal.getParent()) + "\"");
                    return;
                }
                newVal.setParent(this);
                this.bindFullScreen((Node)newVal, this.isFullScreen());
            }
        });
        this.fullScreenProperty().addListener(newVal -> {
            if (this.rootProperty().hasValue()) {
                this.bindFullScreen(this.getRoot(), (boolean)newVal);
            }
        });
        this.addListener(ScreenEventType.KEY_PRESSED, (E e) -> {
            if (e.getKeyCode() == 256 && this.isCloseOnEsc()) {
                Guapi.getScreenHandler().hideScene();
                e.consume();
            }
        });
        this.setRoot(root);
        this.setFullScreen(fullScreen);
        this.setTexturedBackground(texturedBackground);
        this.paddingProperty().addListener(this::shouldUpdateChildren);
    }

    @Override
    public ObjectProperty<Node> rootProperty() {
        return this.rootProperty;
    }

    @Override
    public BooleanProperty fullScreenProperty() {
        return this.fullScreenProperty;
    }

    @Override
    public IntegerProperty widthProperty() {
        return this.widthProperty;
    }

    @Override
    public IntegerProperty heightProperty() {
        return this.heightProperty;
    }

    @Override
    public ObjectProperty<Insets> paddingProperty() {
        return this.paddingProperty;
    }

    @Override
    public BooleanProperty texturedBackgroundProperty() {
        return this.texturedBackgroundProperty;
    }

    @Override
    public BooleanProperty closeOnEscProperty() {
        return this.closeOnEscProperty;
    }

    @Override
    public ObservableObjectValue<Node> focusedProperty() {
        return this.focusedPropertyReadOnly;
    }

    @Override
    public void askFocus(Node node) {
        this.setFocused(node);
    }

    protected void setFocused(Node value) {
        this.focusedProperty.setValue(value);
    }

    @Override
    public ObservableObjectValue<Node> hoveredProperty() {
        return this.hoveredPropertyReadOnly;
    }

    protected void setHovered(Node value) {
        this.hoveredProperty.setValue(value);
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.shouldUpdateChildrenPos) {
            this.updateChildrenPos();
            this.shouldUpdateChildrenPos = false;
        }
        if (this.rootProperty().hasValue()) {
            while (this.getRoot().preRender(guiGraphics, mouseX, mouseY, delta)) {
            }
            this.getRoot().render(guiGraphics, mouseX, mouseY, delta);
            this.getRoot().postRender(guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void shouldComputeSize() {
    }

    @Override
    public void shouldUpdateChildren() {
        this.shouldUpdateChildrenPos = true;
    }

    @Override
    public void tick() {
        if (this.rootProperty().hasValue()) {
            this.getRoot().doTick();
        }
    }

    @Override
    public void show() {
        this.onShowListeners.forEach(listener -> listener.accept(this));
    }

    @Override
    public void onShow(Consumer<Scene> listener) {
        this.onShowListeners.add(listener);
    }

    @Override
    public void hide() {
        this.onHideListeners.forEach(listener -> listener.accept(this));
    }

    @Override
    public void onHide(Consumer<Scene> listener) {
        this.onHideListeners.add(listener);
    }

    @Override
    public <E extends ScreenEvent> void handleEvent(ScreenEventType<E> target, E event) {
        if (this.getRoot() != null) {
            target.ifMouseEvent(event, (t, e) -> {
                this.getRoot().handleEvent(target, event);
                if (!e.isConsumed()) {
                    if (e instanceof MouseButtonEvent) {
                        MouseButtonEvent be = (MouseButtonEvent)e;
                        if (target == ScreenEventType.MOUSE_CLICKED && be.getButton() == 0) {
                            if (e.getTarget() != null && !e.getTarget().isDisabled() && e.getTarget().isVisible()) {
                                e.getTarget().handleEvent(ScreenEventType.ACTION, be);
                                if (!e.isConsumed()) {
                                    this.setFocused(e.getTarget());
                                }
                            } else {
                                this.setFocused(e.getTarget());
                            }
                        }
                    } else if (target == ScreenEventType.MOUSE_MOVED) {
                        this.setHovered(e.getTarget());
                    }
                }
            }, () -> {
                if (this.getFocused() != null && !this.getFocused().isDisabled()) {
                    this.getFocused().handleEvent(target, event);
                }
            });
        }
        this.eventHandlerDelegate.handleEvent(target, event);
    }

    @Override
    public <E extends ScreenEvent> void addListener(ScreenEventType<E> target, ScreenEventListener<E> listener) {
        this.eventHandlerDelegate.addListener(target, listener);
    }

    @Override
    public <E extends ScreenEvent> void removeListener(ScreenEventType<E> target, ScreenEventListener<E> listener) {
        this.eventHandlerDelegate.removeListener(target, listener);
    }

    @Override
    public ObservableValue<Scene> sceneProperty() {
        return this.sceneProperty;
    }

    @Override
    public ObservableBooleanValue disabledProperty() {
        return this.disabledProperty;
    }

    @Override
    public int getMaxChildrenWidth() {
        return this.getWidth() - this.getPadding().getHorizontal();
    }

    @Override
    public int getMaxChildrenHeight() {
        return this.getHeight() - this.getPadding().getVertical();
    }

    protected void updateChildrenPos() {
        if (this.rootProperty().hasValue()) {
            this.getRoot().setX(this.getPadding().getLeft());
            this.getRoot().setY(this.getPadding().getTop());
        }
    }

    protected void bindFullScreen(Node root, boolean bind) {
        if (bind) {
            root.prefWidthProperty().bind(this.widthProperty());
            root.prefHeightProperty().bind(this.heightProperty());
        } else {
            root.prefWidthProperty().unbind();
            root.prefHeightProperty().unbind();
        }
    }
}

