/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.KeyBindings;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.logic.ClientEditorRequestLogic;
import com.github.rinorsi.cadeditor.client.logic.ClientVaultActionLogic;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.mixin.CreativeModeInventoryScreenMixin;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_465;
import net.minecraft.class_481;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onKeyInput() {
        try {
            if (KeyBindings.getEditorKey().method_1436()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.STANDARD);
            } else if (KeyBindings.getNBTEditorKey().method_1436()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.NBT);
            } else if (KeyBindings.getSNBTEditorKey().method_1436()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.SNBT);
            } else if (KeyBindings.getVaultKey().method_1436()) {
                ModScreenHandler.openVault();
            }
        }
        catch (Exception e) {
            ClientUtil.showMessage((class_2561)ModTexts.Messages.ERROR_GENERIC);
            LOGGER.error("\u5904\u7406\u6e38\u620f\u5185\u6309\u952e\u65f6\u51fa\u9519\uff08CAD Editor\uff09", (Throwable)e);
        }
    }

    public static boolean onScreenEvent(class_465<?> screen, int keyCode, int scanCode) {
        try {
            if (KeyBindings.getEditorKey().method_1417(keyCode, scanCode)) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.STANDARD, screen);
            }
            if (KeyBindings.getNBTEditorKey().method_1417(keyCode, scanCode)) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.NBT, screen);
            }
            if (KeyBindings.getSNBTEditorKey().method_1417(keyCode, scanCode)) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.SNBT, screen);
            }
            if (KeyBindings.getVaultKey().method_1417(keyCode, scanCode)) {
                class_481 creativeScreen;
                class_1761.class_7916 type;
                if (screen instanceof class_481 && (type = ((CreativeModeInventoryScreenMixin)(creativeScreen = (class_481)screen)).getSelectedTab().method_47312()) == class_1761.class_7916.field_41055) {
                    return false;
                }
                if (!ClientVaultActionLogic.openVaultSelection(screen)) {
                    ModScreenHandler.openVault();
                }
                return true;
            }
        }
        catch (Exception e) {
            ClientUtil.showMessage((class_2561)ModTexts.Messages.ERROR_GENERIC);
            LOGGER.error("\u5904\u7406\u754c\u9762\u6309\u952e\u65f6\u51fa\u9519\uff08CAD Editor\uff09", (Throwable)e);
        }
        return false;
    }
}

