/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.rinorsi.cadeditor.common.ModTexts;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UpdateLogRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loaded;
    private static List<UpdateLogEntry> entries;
    private static String latestVersion;

    private UpdateLogRegistry() {
    }

    public static void load() {
        if (loaded) {
            return;
        }
        ArrayList<UpdateLogEntry> versions = new ArrayList<UpdateLogEntry>();
        String newest = "";
        JsonObject root = UpdateLogRegistry.readJsonObject("/versions.json");
        if (root == null) {
            root = UpdateLogRegistry.readJsonObject("/assets/cadeditor/versions.json");
        }
        if (root != null) {
            boolean first = true;
            for (Map.Entry e : root.entrySet()) {
                String version = (String)e.getKey();
                JsonObject value = ((JsonElement)e.getValue()).getAsJsonObject();
                String type = value.has("type") ? value.get("type").getAsString() : "";
                String date = value.has("date") ? value.get("date").getAsString() : "";
                String changelog = value.has("changelog") ? value.get("changelog").getAsString() : "";
                versions.add(UpdateLogRegistry.parseEntry(version, type, date, changelog));
                if (!first) continue;
                newest = version;
                first = false;
            }
        } else {
            LOGGER.warn("No versions.json found on classpath; showing CADE description only");
        }
        try {
            String cade = ModTexts.gui("cade_footer_long").getString();
            if (cade != null && !cade.isBlank() && versions.stream().noneMatch(v -> v.version().equals("CADE"))) {
                versions.add(0, new UpdateLogEntry("CADE", "", "", List.of()));
                if (newest.isEmpty()) {
                    newest = "CADE";
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        entries = List.copyOf(versions);
        latestVersion = newest;
        loaded = true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject readJsonObject(String path) {
        try (InputStream stream = UpdateLogRegistry.class.getResourceAsStream(path);){
            JsonObject jsonObject;
            if (stream == null) {
                JsonObject jsonObject2 = null;
                return jsonObject2;
            }
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            return jsonObject;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read {}", (Object)path, (Object)e);
            return null;
        }
    }

    private static UpdateLogEntry parseEntry(String version, String type, String date, String changelog) {
        EnumMap sectionMap = new EnumMap(Section.class);
        for (Section section : Section.values()) {
            sectionMap.put(section, new ArrayList());
        }
        for (String line : UpdateLogRegistry.parseChangelogLines(changelog)) {
            ParsedLine parsed = ParsedLine.fromRaw(line);
            ((List)sectionMap.get((Object)parsed.section())).add(ModTexts.updateBullet(parsed.content()));
        }
        ArrayList<SectionContent> sections = new ArrayList<SectionContent>();
        for (Section section : Section.values()) {
            List list = (List)sectionMap.get((Object)section);
            if (list.isEmpty()) continue;
            sections.add(new SectionContent(section, List.copyOf(list)));
        }
        if (sections.isEmpty()) {
            sections.add(new SectionContent(Section.MISC, List.of(ModTexts.updateBullet(ModTexts.UPDATE_LOG_EMPTY.getString()))));
        }
        return new UpdateLogEntry(version, type, date, List.copyOf(sections));
    }

    private static List<String> parseChangelogLines(String changelog) {
        if (changelog == null || changelog.isEmpty()) {
            return List.of();
        }
        String[] rawLines = changelog.split("\\r?\\n");
        ArrayList<String> lines = new ArrayList<String>();
        for (String raw : rawLines) {
            String t = raw.trim();
            if (t.isEmpty()) continue;
            if (t.startsWith("-")) {
                t = t.substring(1).trim();
            }
            if (t.isEmpty()) continue;
            lines.add(t);
        }
        return lines;
    }

    public static List<UpdateLogEntry> getEntries() {
        if (!loaded) {
            UpdateLogRegistry.load();
        }
        return entries;
    }

    public static String getLatestVersion() {
        if (!loaded) {
            UpdateLogRegistry.load();
        }
        return latestVersion;
    }

    static {
        entries = List.of();
        latestVersion = "";
    }

    public record UpdateLogEntry(String version, String type, String date, List<SectionContent> sections) {
        public class_5250 displayName() {
            if (this.isProjectDescription()) {
                return ModTexts.updateLogAboutTitle();
            }
            return ModTexts.updateVersion(this.version, this.type);
        }

        public class_5250 dateLabel() {
            if (this.isProjectDescription()) {
                return ModTexts.updateLogAboutSubtitle();
            }
            return this.date == null || this.date.isBlank() ? ModTexts.updateLogNoDate() : ModTexts.updateLogDate(this.date);
        }

        private boolean isProjectDescription() {
            return !(!"CADE".equalsIgnoreCase(this.version) || this.type != null && !this.type.isBlank() || this.date != null && !this.date.isBlank());
        }
    }

    public static enum Section {
        FEATURES("features", "\u65b0\u589e"),
        IMPROVEMENTS("improvements", "\u4f53\u9a8c", "\u4f18\u5316", "\u8c03\u6574"),
        FIXES("fixes", "\u4fee\u590d"),
        KNOWN("known", "\u5df2\u77e5", "\u8ba1\u5212"),
        MISC("misc", new String[0]);

        private final String translationKey;
        private final String[] keywords;

        private Section(String translationKey, String ... keywords) {
            this.translationKey = translationKey;
            this.keywords = keywords;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public static Section fromKeyword(String keyword) {
            if (keyword == null || keyword.isEmpty()) {
                return MISC;
            }
            String normalized = keyword.trim();
            for (Section s : Section.values()) {
                for (String k : s.keywords) {
                    if (!k.equalsIgnoreCase(normalized)) continue;
                    return s;
                }
            }
            return MISC;
        }
    }

    private record ParsedLine(Section section, String content) {
        private static ParsedLine fromRaw(String line) {
            int end;
            if (line.startsWith("[") && (end = line.indexOf(93)) > 0) {
                String keyword = line.substring(1, end);
                String remainder = line.substring(end + 1).trim();
                return new ParsedLine(Section.fromKeyword(keyword), remainder);
            }
            return new ParsedLine(Section.MISC, line);
        }
    }

    public record SectionContent(Section section, List<class_5250> lines) {
    }
}

