/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.context;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.context.EditorContext;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class ItemEditorContext
extends EditorContext<ItemEditorContext> {
    private static final Pattern SIMPLE_KEY = Pattern.compile("[a-z0-9_\\-+.]+");
    private static final Set<String> BOOLEAN_HINTS = Set.of("enchantment_glint_override", "keep_hanging", "keep_owner", "keep_on_death", "keep_on_death_loss", "creative_slot_lock", "show_in_tooltip", "show_in_additional_tooltip", "show_in_enchantment_tooltip", "show_in_tooltips", "hide_tooltip", "hide_additional_tooltip", "hide_enchantment_tooltip", "hide_tooltips", "glint_override");
    private class_1799 itemStack;

    public ItemEditorContext(class_1799 itemStack, class_2561 errorTooltip, boolean canSaveToVault, Consumer<ItemEditorContext> action) {
        super(ItemEditorContext.saveStack(itemStack), errorTooltip, canSaveToVault, action);
        this.itemStack = itemStack.method_7972();
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(class_1799 stack) {
        this.itemStack = stack;
    }

    @Override
    public void update() {
        class_1799 result = this.itemStack.method_7972();
        class_2487 edited = this.getTag();
        if (edited != null) {
            try {
                class_1799 parsed = class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)edited);
                if (!parsed.method_7960()) {
                    result = parsed;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.itemStack = result;
        this.setTag(ItemEditorContext.saveStack(result));
        super.update();
    }

    @Override
    public void saveToVault() {
        Vault.getInstance().saveItem(this.getTag());
        ClientUtil.showMessage((class_2561)ModTexts.Messages.successSavedVault(ModTexts.ITEM));
    }

    @Override
    public class_5250 getTargetName() {
        return ModTexts.ITEM;
    }

    @Override
    public String getCommandName() {
        return "/give";
    }

    @Override
    protected String getCommand() {
        return ItemEditorContext.buildGiveCommand(this.getItemStack());
    }

    private static class_2487 saveStack(class_1799 stack) {
        class_2487 compound;
        if (stack == null || stack.method_7960()) {
            class_2487 tag = new class_2487();
            tag.method_10582("id", class_7923.field_41178.method_10221((Object)class_1802.field_8162).toString());
            tag.method_10567("Count", (byte)0);
            return tag;
        }
        class_2520 tag = stack.method_57376(ClientUtil.registryAccess(), (class_2520)new class_2487());
        return tag instanceof class_2487 ? (compound = (class_2487)tag) : new class_2487();
    }

    private static String buildGiveCommand(class_1799 stack) {
        int count;
        class_2487 legacy;
        class_2487 components;
        class_2487 data = ItemEditorContext.saveStack(stack);
        String id = data.method_10558("id");
        if (id == null || id.isEmpty()) {
            id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        }
        class_2487 class_24872 = components = data.method_10573("components", 10) ? data.method_10562("components").method_10553() : new class_2487();
        if (data.method_10573("tag", 10) && !components.method_10573("minecraft:custom_data", 10) && !(legacy = data.method_10562("tag")).method_33133()) {
            components.method_10566("minecraft:custom_data", (class_2520)legacy.method_10553());
        }
        StringBuilder builder = new StringBuilder("/give @p ").append(id);
        String componentSpec = ItemEditorContext.formatComponentList(components);
        if (!componentSpec.isEmpty()) {
            builder.append(componentSpec);
        }
        if ((count = stack.method_7947()) > 1) {
            builder.append(' ').append(count);
        }
        return builder.toString();
    }

    private static String formatComponentList(class_2487 components) {
        if (components == null || components.method_33133()) {
            return "";
        }
        class_2487 normalized = ItemEditorContext.normalizeComponents(components);
        ArrayList keys = new ArrayList(normalized.method_10541());
        Collections.sort(keys);
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        boolean hasEntry = false;
        for (String key : keys) {
            String rendered;
            class_2520 value;
            if (key.startsWith("!") || (value = normalized.method_10580(key)) == null || value.method_10711() == 0 || (rendered = ItemEditorContext.formatTagValue(key, value)).isEmpty()) continue;
            joiner.add(key + "=" + rendered);
            hasEntry = true;
        }
        return hasEntry ? joiner.toString() : "";
    }

    private static class_2487 normalizeComponents(class_2487 components) {
        class_2487 attributeCompound;
        class_2499 modifiers;
        class_2487 normalized = components.method_10553();
        class_2520 attributeTag = normalized.method_10580("minecraft:attribute_modifiers");
        if (attributeTag instanceof class_2487 && !(modifiers = (attributeCompound = (class_2487)attributeTag).method_10554("modifiers", 10)).isEmpty()) {
            HashSet<UUID> usedIds = new HashSet<UUID>();
            for (class_2520 entryTag : modifiers) {
                if (!(entryTag instanceof class_2487)) continue;
                class_2487 modifier = (class_2487)entryTag;
                UUID id = ItemEditorContext.readModifierUUID(modifier);
                if (id != null && !usedIds.add(id)) {
                    id = null;
                }
                if (id == null) {
                    id = ItemEditorContext.generateModifierUUID(modifier, usedIds);
                }
                modifier.method_10582("id", id.toString());
            }
        }
        return normalized;
    }

    private static UUID generateModifierUUID(class_2487 modifier, Set<UUID> usedIds) {
        String seed = ItemEditorContext.buildModifierSeed(modifier);
        int salt = 0;
        UUID uuid;
        while (!usedIds.add(uuid = UUID.nameUUIDFromBytes((seed + "#" + salt).getBytes(StandardCharsets.UTF_8)))) {
            ++salt;
        }
        return uuid;
    }

    private static String buildModifierSeed(class_2487 modifier) {
        class_2487 copy = modifier.method_10553();
        copy.method_10551("id");
        copy.method_10551("UUID");
        copy.method_10551("uuid");
        return copy.toString();
    }

    private static UUID readModifierUUID(class_2487 modifier) {
        UUID id = ItemEditorContext.parseUuidFromTag(modifier, "id");
        if (id != null) {
            return id;
        }
        id = ItemEditorContext.parseUuidFromTag(modifier, "uuid");
        if (id != null) {
            return id;
        }
        return ItemEditorContext.parseUuidFromTag(modifier, "UUID");
    }

    private static UUID parseUuidFromTag(class_2487 modifier, String key) {
        if (!modifier.method_10545(key)) {
            return null;
        }
        class_2520 tag = modifier.method_10580(key);
        if (tag == null) {
            return null;
        }
        if (tag.method_10711() == 8) {
            return ItemEditorContext.parseUuidString(((class_2519)tag).method_10714());
        }
        if (tag.method_10711() == 11) {
            return ItemEditorContext.uuidFromIntArray(modifier.method_10561(key));
        }
        return null;
    }

    private static UUID parseUuidString(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String trimmed = value.trim();
        try {
            return UUID.fromString(trimmed);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String candidate = trimmed;
            int underscore = candidate.lastIndexOf(95);
            if (underscore >= 0 && underscore + 1 < candidate.length()) {
                candidate = candidate.substring(underscore + 1);
            } else if (candidate.contains(":")) {
                candidate = candidate.substring(candidate.lastIndexOf(58) + 1);
            }
            candidate = candidate.replace("-", "");
            return ItemEditorContext.parseUuidFromHex(candidate);
        }
    }

    private static UUID parseUuidFromHex(String value) {
        if (value == null) {
            return null;
        }
        String hex = value.trim();
        if (hex.length() != 32) {
            return null;
        }
        try {
            long most = Long.parseUnsignedLong(hex.substring(0, 16), 16);
            long least = Long.parseUnsignedLong(hex.substring(16), 16);
            return new UUID(most, least);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static UUID uuidFromIntArray(int[] data) {
        if (data.length != 4) {
            return null;
        }
        long most = (long)data[0] << 32 | (long)data[1] & 0xFFFFFFFFL;
        long least = (long)data[2] << 32 | (long)data[3] & 0xFFFFFFFFL;
        return new UUID(most, least);
    }

    private static String formatTagValue(String key, class_2520 tag) {
        return switch (tag.method_10711()) {
            case 10 -> ItemEditorContext.formatCompound((class_2487)tag);
            case 9 -> ItemEditorContext.formatList((class_2499)tag);
            case 8 -> ItemEditorContext.formatString(((class_2519)tag).method_10714());
            case 1 -> ItemEditorContext.formatByte(key, ((class_2481)tag).method_10698());
            case 2 -> Integer.toString(((class_2516)tag).method_10696());
            case 3 -> Integer.toString(((class_2497)tag).method_10701());
            case 4 -> Long.toString(((class_2503)tag).method_10699());
            case 5 -> ItemEditorContext.formatFloating(((class_2494)tag).method_10700());
            case 6 -> ItemEditorContext.formatFloating(((class_2489)tag).method_10697());
            case 7, 11, 12 -> tag.toString();
            default -> tag.toString();
        };
    }

    private static String formatCompound(class_2487 tag) {
        if (tag.method_33133()) {
            return "{}";
        }
        ArrayList keys = new ArrayList(tag.method_10541());
        Collections.sort(keys);
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        for (String key : keys) {
            class_2520 value = tag.method_10580(key);
            if (value == null || value.method_10711() == 0) continue;
            String formattedKey = SIMPLE_KEY.matcher(key).matches() ? key : class_2519.method_10706((String)key);
            String formattedValue = ItemEditorContext.formatTagValue(key, value);
            joiner.add(formattedKey + ":" + formattedValue);
        }
        return joiner.toString();
    }

    private static String formatList(class_2499 list) {
        if (list.isEmpty()) {
            return "[]";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (class_2520 tag : list) {
            joiner.add(ItemEditorContext.formatTagValue(null, tag));
        }
        return joiner.toString();
    }

    private static String formatString(String value) {
        return SIMPLE_KEY.matcher(value).matches() ? value : class_2519.method_10706((String)value);
    }

    private static String formatByte(String key, byte value) {
        if (ItemEditorContext.isBooleanKey(key) && (value == 0 || value == 1)) {
            return value == 1 ? "true" : "false";
        }
        return Byte.toString(value);
    }

    private static boolean isBooleanKey(String key) {
        String bare;
        if (key == null || key.isEmpty()) {
            return false;
        }
        String string = bare = key.contains(":") ? key.substring(key.indexOf(58) + 1) : key;
        if (BOOLEAN_HINTS.contains(bare)) {
            return true;
        }
        return bare.startsWith("is_") || bare.startsWith("has_") || bare.startsWith("can_") || bare.startsWith("show_") || bare.startsWith("keep_") || bare.startsWith("allow_") || bare.startsWith("use_") || bare.startsWith("enable_") || bare.startsWith("should_") || bare.startsWith("hide_");
    }

    private static String formatFloating(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Double.toString(value);
        }
        double roundedTenth = (double)Math.round(value * 10.0) / 10.0;
        if (Math.abs(value - roundedTenth) < 1.0E-6) {
            return ItemEditorContext.formatFixed(roundedTenth, 1);
        }
        double roundedThousandth = (double)Math.round(value * 1000.0) / 1000.0;
        if (Math.abs(value - roundedThousandth) < 1.0E-7) {
            return ItemEditorContext.trimTrailingZeros(Double.toString(roundedThousandth));
        }
        return ItemEditorContext.trimTrailingZeros(BigDecimal.valueOf(value).stripTrailingZeros().toPlainString());
    }

    private static String formatFixed(double value, int decimals) {
        BigDecimal bd = BigDecimal.valueOf(value).setScale(decimals, RoundingMode.HALF_UP);
        return ItemEditorContext.trimTrailingZeros(bd.toPlainString());
    }

    private static String trimTrailingZeros(String value) {
        int end;
        if (!value.contains(".")) {
            return value;
        }
        for (end = value.length(); end > 0 && value.charAt(end - 1) == '0'; --end) {
        }
        if (end > 0 && value.charAt(end - 1) == '.') {
            ++end;
        }
        if (end > value.length()) {
            end = value.length();
        }
        return value.substring(0, end);
    }

    @Override
    protected class_5250 getCopySuccessMessage() {
        if ("/give".equals(this.getCommandName())) {
            return ModTexts.Messages.successCopyGiveCommand();
        }
        return super.getCopySuccessMessage();
    }
}

