/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller;

import com.github.franckyi.databindings.api.event.ObservableListChangeEvent;
import com.github.franckyi.databindings.api.event.ObservableListChangeListener;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.UpdateLogRegistry;
import com.github.rinorsi.cadeditor.client.screen.model.UpdateLogScreenModel;
import com.github.rinorsi.cadeditor.client.screen.view.UpdateLogScreenView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Collection;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class UpdateLogScreenController
extends AbstractController<UpdateLogScreenModel, UpdateLogScreenView> {
    private static final int DETAIL_LIST_CELL_PADDING = 8;
    private final ObservableListChangeListener<UpdateLogScreenModel.SectionLine> lineListener = this::refreshDetailList;

    public UpdateLogScreenController(UpdateLogScreenModel model, UpdateLogScreenView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        ((UpdateLogScreenView)this.view).getIntroLabel().setLabel((class_2561)GuapiHelper.EMPTY_TEXT);
        ((UpdateLogScreenView)this.view).getDoneButton().setLabel((class_2561)ModTexts.CLOSE);
        ((UpdateLogScreenView)this.view).getCancelButton().setVisible(false);
        ((UpdateLogScreenView)this.view).getDoneButton().onAction(Guapi.getScreenHandler()::hideScene);
        ((UpdateLogScreenView)this.view).getMarkReadButton().onAction(() -> {
            ((UpdateLogScreenModel)this.model).markSelectedAsRead();
            this.updateMarkReadState();
        });
        ((UpdateLogScreenView)this.view).getMarkAllReadButton().onAction(() -> {
            ((UpdateLogScreenModel)this.model).markAllAsRead();
            this.updateMarkReadState();
        });
        ((UpdateLogScreenView)this.view).getCopyButton().onAction(() -> {
            String payload = ((UpdateLogScreenModel)this.model).buildClipboardText();
            if (!payload.isEmpty()) {
                class_310.method_1551().field_1774.method_1455(payload);
                ClientUtil.showMessage((class_2561)ModTexts.Messages.successCopyClipboard(ModTexts.UPDATE_LOG.getString()));
            }
        });
        ((UpdateLogScreenView)this.view).resetVersionIndicators();
        ((UpdateLogScreenView)this.view).getVersionList().getItems().setAll((Collection<UpdateLogRegistry.UpdateLogEntry>)((UpdateLogScreenModel)this.model).getVersions());
        ((UpdateLogScreenModel)this.model).getVersions().addListener(event -> {
            ((UpdateLogScreenView)this.view).resetVersionIndicators();
            ((UpdateLogScreenView)this.view).getVersionList().getItems().setAll((Collection<UpdateLogRegistry.UpdateLogEntry>)((UpdateLogScreenModel)this.model).getVersions());
        });
        if (!((UpdateLogScreenModel)this.model).getVersions().isEmpty()) {
            ((UpdateLogScreenView)this.view).getVersionList().setFocusedElement((UpdateLogRegistry.UpdateLogEntry)((UpdateLogScreenModel)this.model).getVersions().get(0));
            ((UpdateLogScreenModel)this.model).select((UpdateLogRegistry.UpdateLogEntry)((UpdateLogScreenModel)this.model).getVersions().get(0));
        }
        ((UpdateLogScreenView)this.view).getVersionList().focusedElementProperty().addListener((oldValue, newValue) -> {
            if (newValue != null) {
                ((UpdateLogScreenModel)this.model).select((UpdateLogRegistry.UpdateLogEntry)newValue);
            }
        });
        ((UpdateLogScreenModel)this.model).selectedVersionProperty().addListener((oldValue, newValue) -> {
            ((UpdateLogScreenView)this.view).renderEntry((UpdateLogRegistry.UpdateLogEntry)newValue);
            this.updateMarkReadState();
        });
        this.refreshDetailList(null);
        ((UpdateLogScreenModel)this.model).getDisplayedLines().addListener(this.lineListener);
        this.updateMarkReadState();
        ((UpdateLogScreenView)this.view).getDetailList().widthProperty().addListener((oldValue, newValue) -> this.updateWrapWidth((Integer)newValue));
        this.updateWrapWidth(((UpdateLogScreenView)this.view).getDetailList().getWidth());
    }

    private void refreshDetailList(ObservableListChangeEvent<? extends UpdateLogScreenModel.SectionLine> event) {
        ((UpdateLogScreenView)this.view).getDetailList().getItems().setAll((Collection<UpdateLogScreenModel.SectionLine>)((UpdateLogScreenModel)this.model).getDisplayedLines());
    }

    private void updateWrapWidth(Integer width) {
        if (width == null) {
            return;
        }
        int padding = ((UpdateLogScreenView)this.view).getDetailList().getPadding().getHorizontal();
        int available = Math.max(0, width - padding - 8);
        ((UpdateLogScreenModel)this.model).setWrapWidth(available);
    }

    private void updateMarkReadState() {
        boolean canMark = ((UpdateLogScreenModel)this.model).canMarkSelectedAsRead();
        ((UpdateLogScreenView)this.view).getMarkReadButton().setDisable(!canMark);
        ((UpdateLogScreenView)this.view).getMarkAllReadButton().setDisable(!((UpdateLogScreenModel)this.model).canMarkAllAsRead());
        boolean showBadge = ((UpdateLogScreenModel)this.model).hasUnread() && ((UpdateLogScreenModel)this.model).getSelectedVersion() != null && ((UpdateLogScreenModel)this.model).getSelectedVersion().version().equals(((UpdateLogScreenModel)this.model).getLatestVersion());
        ((UpdateLogScreenView)this.view).setUnreadBadgeVisible(showBadge);
        ((UpdateLogScreenView)this.view).updateUnreadState(((UpdateLogScreenModel)this.model).hasUnread(), ((UpdateLogScreenModel)this.model).getLatestVersion());
    }
}

