/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.ValueEntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntityEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.EntityEntryView;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class EntityEntryController
extends ValueEntryController<EntityEntryModel, EntityEntryView> {
    private static final class_5250 EMPTY_ENTITY_LABEL = GuapiHelper.text("-").method_27692(class_124.field_1063);

    public EntityEntryController(EntityEntryModel model, EntityEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((EntityEntryView)this.view).getEntityField().setPlaceholder((class_2561)ModTexts.ENTITY);
        ((EntityEntryView)this.view).getEntityField().setValidator(value -> {
            if (value == null || value.isEmpty()) {
                return false;
            }
            return ClientUtil.parseResourceLocation(value) != null;
        });
        ((EntityEntryView)this.view).getEntityField().getSuggestions().setAll((Collection<String>)ClientCache.getEntitySuggestions());
        ((EntityEntryView)this.view).getEntityField().textProperty().addListener(this::onEntityChanged);
        ((EntityEntryModel)this.model).entityIdProperty().addListener(value -> {
            String text = ((EntityEntryView)this.view).getEntityField().getText();
            if (!Objects.equals(text, value)) {
                ((EntityEntryView)this.view).getEntityField().setText((String)value);
            }
        });
        ((EntityEntryModel)this.model).entityTypeProperty().addListener(type -> this.updateEntityPreview());
        String initial = ((EntityEntryModel)this.model).getEntityId();
        ((EntityEntryView)this.view).getEntityField().setText(initial == null ? "" : initial);
        ((EntityEntryView)this.view).getEntityField().validProperty().addListener(valid -> {
            if (!valid.booleanValue()) {
                ((EntityEntryModel)this.model).setValid(false);
                ((EntityEntryView)this.view).getEntityField().getTooltip().setAll((class_2561[])new class_2561[]{ModTexts.Messages.errorNoTargetFound(ModTexts.ENTITY)});
            } else {
                ((EntityEntryView)this.view).getEntityField().getTooltip().clear();
            }
            this.updateEntityPreview();
        });
        ((EntityEntryView)this.view).getSelectEntityButton().getTooltip().add((class_2561)ModTexts.choose(ModTexts.ENTITY));
        ((EntityEntryView)this.view).getSelectEntityButton().onAction(this::openSelectionScreen);
        ((EntityEntryView)this.view).getOpenEditorButton().onAction(() -> this.openEditor(EditorType.STANDARD));
        ((EntityEntryView)this.view).getOpenNbtEditorButton().onAction(() -> this.openEditor(EditorType.NBT));
        ((EntityEntryView)this.view).getOpenSnbtEditorButton().onAction(() -> this.openEditor(EditorType.SNBT));
        this.updateEntityPreview();
    }

    private void onEntityChanged(String value) {
        if (((EntityEntryView)this.view).getEntityField().isValid()) {
            ((EntityEntryModel)this.model).setEntityId(value);
        } else {
            ((EntityEntryModel)this.model).setValid(false);
        }
    }

    private void updateEntityPreview() {
        class_1299<?> entityType = ((EntityEntryModel)this.model).getEntityType();
        if (entityType != null) {
            ((EntityEntryView)this.view).getEntityNameLabel().setLabel((class_2561)entityType.method_5897().method_27661().method_27692(class_124.field_1080));
            ((EntityEntryView)this.view).getEntityIconView().setItem(this.createIcon(entityType));
        } else {
            ((EntityEntryView)this.view).getEntityNameLabel().setLabel((class_2561)EMPTY_ENTITY_LABEL);
            ((EntityEntryView)this.view).getEntityIconView().setItem(class_1799.field_8037);
        }
    }

    private class_1799 createIcon(class_1299<?> type) {
        class_1826 egg = class_1826.method_8019(type);
        return egg != null ? new class_1799((class_1935)egg) : class_1799.field_8037;
    }

    private void openSelectionScreen() {
        String current = ((EntityEntryView)this.view).getEntityField().getText();
        class_2960 location = ClientUtil.parseResourceLocation(current);
        String normalized = location != null ? location.toString() : current;
        ModScreenHandler.openListSelectionScreen(ModTexts.ENTITY, normalized, ClientCache.getEntitySelectionItems(), ((EntityEntryModel)this.model)::setEntityId);
    }

    private void openEditor(EditorType editorType) {
        ModScreenHandler.openEditor(editorType, new EntityEditorContext(((EntityEntryModel)this.model).copyValue(), null, false, context -> ((EntityEntryModel)this.model).setValue(context.getTag())));
    }
}

