/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry;

import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.ValueEntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.TextEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.TextEntryView;
import com.github.rinorsi.cadeditor.client.util.texteditor.ColorFormatting;
import com.github.rinorsi.cadeditor.client.util.texteditor.Formatting;
import com.github.rinorsi.cadeditor.client.util.texteditor.StyleFormatting;
import com.github.rinorsi.cadeditor.client.util.texteditor.StyleType;
import com.github.rinorsi.cadeditor.client.util.texteditor.TextEditorActionHandler;
import com.github.rinorsi.cadeditor.client.util.texteditor.TextEditorInputParser;
import com.github.rinorsi.cadeditor.client.util.texteditor.TextEditorOutputFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class TextEntryController
extends ValueEntryController<TextEntryModel, TextEntryView>
implements TextEditorActionHandler {
    private final ObservableList<Formatting> formattings = ObservableList.create();
    private boolean isResettingModel;

    public TextEntryController(TextEntryModel model, TextEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((TextEntryView)this.view).getTextField().setText(((class_5250)((TextEntryModel)this.model).getValue()).getString());
        ((TextEntryView)this.view).getTextField().setTextRenderer(this::renderText);
        ((TextEntryView)this.view).getTextField().focusedProperty().addListener(this::onTextFieldFocus);
        ((TextEntryView)this.view).getTextField().setOnTextUpdate(this::onTextUpdate);
        ((TextEntryView)this.view).getTextField().textProperty().addListener(this::updateModel);
        this.formattings.addListener(this::updateModel);
        ((TextEntryView)this.view).getTextField().validProperty().addListener(((TextEntryModel)this.model)::setValid);
        this.initFormattings((class_5250)((TextEntryModel)this.model).getValue());
        ((TextEntryModel)this.model).resetDefaultValue();
        ((TextEntryModel)this.model).setOnApply(this::updateModel);
    }

    private void updateModel() {
        if (!this.isResettingModel) {
            ((TextEntryModel)this.model).setValue(this.createText());
        }
    }

    @Override
    protected void resetModel() {
        super.resetModel();
        this.isResettingModel = true;
        ((TextEntryView)this.view).getTextField().setText(((class_5250)((TextEntryModel)this.model).getValue()).getString());
        this.initFormattings((class_5250)((TextEntryModel)this.model).getValue());
        this.isResettingModel = false;
    }

    private void onTextUpdate(int oldCursorPos, int oldHighlightPos, String oldText, int newCursorPos, String newText) {
        int oldLength = oldText.length();
        int newLength = newText.length();
        int amount = newLength - oldLength;
        if (amount != 0) {
            if (oldCursorPos == oldHighlightPos && oldCursorPos != newCursorPos) {
                this.formattings.removeIf(formatting -> {
                    if (oldCursorPos <= formatting.getStart()) {
                        formatting.setStart(formatting.getStart() + amount);
                        formatting.setEnd(formatting.getEnd() + amount);
                    } else if (oldCursorPos > formatting.getStart() && oldCursorPos <= formatting.getEnd()) {
                        formatting.setEnd(formatting.getEnd() + amount);
                    }
                    return formatting.getStart() >= formatting.getEnd();
                });
            } else {
                int pos = Math.min(oldCursorPos, oldHighlightPos);
                this.formattings.removeIf(formatting -> {
                    if (pos < formatting.getStart()) {
                        formatting.setStart(formatting.getStart() + amount);
                        formatting.setEnd(formatting.getEnd() + amount);
                    } else if (pos >= formatting.getStart() && pos <= formatting.getEnd()) {
                        formatting.setEnd(formatting.getEnd() + amount);
                    }
                    return formatting.getStart() >= formatting.getEnd();
                });
            }
        }
    }

    private class_2561 renderText(String str, int firstCharacterIndex) {
        if (!str.isEmpty()) {
            TextEditorOutputFormatter formatter = new TextEditorOutputFormatter(GuapiHelper.text().method_10852((class_2561)GuapiHelper.text("")));
            formatter.format(str, firstCharacterIndex, this.formattings);
            return formatter.getText();
        }
        return GuapiHelper.EMPTY_TEXT;
    }

    private class_5250 createText() {
        TextEditorOutputFormatter formatter = new TextEditorOutputFormatter(GuapiHelper.text().method_10852((class_2561)GuapiHelper.text("")));
        formatter.format(((TextEntryView)this.view).getTextField().getText(), 0, this.formattings);
        return formatter.getText();
    }

    private void initFormattings(class_5250 text) {
        TextEditorInputParser parser = new TextEditorInputParser();
        parser.parse(text);
        this.formattings.setAll((Collection<Formatting>)parser.getFormattings());
    }

    private void onTextFieldFocus(boolean focused) {
        if (focused) {
            ((TextEntryModel)this.model).getCategory().getParent().setActiveTextEditor(this);
        } else if (((TextEntryModel)this.model).getCategory().getParent().getActiveTextEditor() == this) {
            ((TextEntryModel)this.model).getCategory().getParent().setActiveTextEditor(null);
        }
    }

    @Override
    public void removeColorFormatting() {
        int j;
        int i = ((TextEntryView)this.view).getTextField().getCursorPosition();
        if (i == (j = ((TextEntryView)this.view).getTextField().getHighlightPosition())) {
            return;
        }
        this.resizeOtherColorFormattings(new ColorFormatting(Math.min(i, j), Math.max(i, j), null), false);
    }

    @Override
    public void addColorFormatting(String color) {
        int j;
        int i = ((TextEntryView)this.view).getTextField().getCursorPosition();
        if (i == (j = ((TextEntryView)this.view).getTextField().getHighlightPosition())) {
            return;
        }
        ColorFormatting formatting = new ColorFormatting(Math.min(i, j), Math.max(i, j), color);
        if (this.formattings.contains(formatting)) {
            return;
        }
        this.mergeIdenticalFormattings(ColorFormatting.class, other -> other.getColor().equals(color), formatting);
        this.resizeOtherColorFormattings(formatting, true);
    }

    @Override
    public void addStyleFormatting(StyleType target) {
        int j;
        int i = ((TextEntryView)this.view).getTextField().getCursorPosition();
        if (i == (j = ((TextEntryView)this.view).getTextField().getHighlightPosition())) {
            return;
        }
        StyleFormatting formatting = new StyleFormatting(Math.min(i, j), Math.max(i, j), target);
        if (this.formattings.contains(formatting)) {
            this.formattings.remove(formatting);
            return;
        }
        Optional<StyleFormatting> surrounding = this.getSurroundingStyleFormatting(formatting);
        if (surrounding.isPresent()) {
            this.removeStyleFormatting(formatting, surrounding.get());
        } else {
            this.mergeIdenticalFormattings(StyleFormatting.class, other -> other.getType().equals((Object)target), formatting);
            this.formattings.add(formatting);
        }
    }

    private <T extends Formatting> void mergeIdenticalFormattings(Class<T> formattingClass, Predicate<T> identicalPredicate, T formatting) {
        Iterator it = this.formattings.iterator();
        while (it.hasNext()) {
            Formatting other;
            Formatting f = (Formatting)it.next();
            if (!formattingClass.isInstance(f) || !identicalPredicate.test(other = (Formatting)formattingClass.cast(f))) continue;
            boolean remove = false;
            if (other.getEnd() >= formatting.getStart() && other.getEnd() <= formatting.getEnd()) {
                remove = true;
                if (other.getStart() < formatting.getStart()) {
                    formatting.setStart(other.getStart());
                }
            }
            if (other.getStart() >= formatting.getStart() && other.getStart() <= formatting.getEnd()) {
                remove = true;
                if (other.getEnd() > formatting.getEnd()) {
                    formatting.setEnd(other.getEnd());
                }
            }
            if (!remove) continue;
            it.remove();
        }
    }

    private void resizeOtherColorFormattings(ColorFormatting formatting, boolean add) {
        ArrayList<ColorFormatting> addedFormattings = new ArrayList<ColorFormatting>();
        if (add) {
            addedFormattings.add(formatting);
        }
        Iterator it = this.formattings.iterator();
        while (it.hasNext()) {
            ColorFormatting other;
            Formatting f = (Formatting)it.next();
            if (!(f instanceof ColorFormatting) || (other = (ColorFormatting)f).getColor().equals(formatting.getColor())) continue;
            if (formatting.getStart() <= other.getStart() && formatting.getEnd() >= other.getEnd()) {
                it.remove();
                continue;
            }
            if (formatting.getStart() <= other.getStart() && formatting.getEnd() > other.getStart() && formatting.getEnd() <= other.getEnd()) {
                other.setStart(formatting.getEnd());
            }
            if (formatting.getEnd() >= other.getEnd() && formatting.getStart() < other.getEnd() && formatting.getStart() >= other.getStart()) {
                other.setEnd(formatting.getStart());
            }
            if (formatting.getStart() >= other.getStart() && formatting.getEnd() > other.getStart() && formatting.getEnd() <= other.getEnd()) {
                addedFormattings.add(new ColorFormatting(formatting.getEnd(), other.getEnd(), other.getColor()));
                other.setEnd(formatting.getStart());
            }
            if (other.getStart() < other.getEnd()) continue;
            it.remove();
        }
        this.formattings.addAll((Collection<Formatting>)addedFormattings);
    }

    private Optional<StyleFormatting> getSurroundingStyleFormatting(StyleFormatting formatting) {
        return this.formattings.stream().filter(StyleFormatting.class::isInstance).map(StyleFormatting.class::cast).filter(other -> other.getType().equals((Object)formatting.getType())).filter(other -> formatting.getStart() >= other.getStart() && formatting.getEnd() <= other.getEnd()).findFirst();
    }

    private void removeStyleFormatting(StyleFormatting formatting, StyleFormatting other) {
        if (formatting.getStart() == other.getStart()) {
            other.setStart(formatting.getEnd());
        } else if (formatting.getEnd() == other.getEnd()) {
            other.setEnd(formatting.getStart());
        } else {
            int otherEnd = other.getEnd();
            other.setEnd(formatting.getStart());
            formatting.setStart(formatting.getEnd());
            formatting.setEnd(otherEnd);
            this.formattings.add(formatting);
        }
    }
}

