/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.entity;

import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.EntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.EntityEquipmentEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.VaultItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.entity.EntityEquipmentEntryView;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class EntityEquipmentEntryController
extends EntryController<EntityEquipmentEntryModel, EntityEquipmentEntryView> {
    private boolean placeholder;

    public EntityEquipmentEntryController(EntityEquipmentEntryModel model, EntityEquipmentEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((EntityEquipmentEntryView)this.view).setListButtonsVisible(false);
        ((EntityEquipmentEntryView)this.view).getDeleteButton().setVisible(false);
        ((EntityEquipmentEntryView)this.view).getUpButton().setVisible(false);
        ((EntityEquipmentEntryView)this.view).getDownButton().setVisible(false);
        ((EntityEquipmentEntryView)this.view).getChooseItemButton().onAction(() -> this.openItemSelection(null));
        ((EntityEquipmentEntryView)this.view).getLoadVaultButton().onAction(this::openVaultSelection);
        ((EntityEquipmentEntryView)this.view).getChooseItemButton().setDisable(false);
        ((EntityEquipmentEntryView)this.view).getSlotLabel().setLabel((class_2561)((EntityEquipmentEntryModel)this.model).getSlotLabel());
        ((EntityEquipmentEntryView)this.view).getItemView().itemProperty().bind(((EntityEquipmentEntryModel)this.model).itemStackProperty());
        ((EntityEquipmentEntryModel)this.model).itemStackProperty().addListener(stack -> this.updateItemName());
        this.updateItemName();
        ((EntityEquipmentEntryView)this.view).getDropChanceField().setValidator(((EntityEquipmentEntryModel)this.model)::isDropChanceTextValid);
        ((EntityEquipmentEntryView)this.view).getDropChanceField().setText(((EntityEquipmentEntryModel)this.model).formatDropChance());
        ((EntityEquipmentEntryView)this.view).getDropChanceField().textProperty().addListener(value -> {
            if (!((EntityEquipmentEntryView)this.view).getDropChanceField().isValid()) {
                ((EntityEquipmentEntryModel)this.model).setValid(false);
                return;
            }
            if (!Objects.equals(value, ((EntityEquipmentEntryModel)this.model).formatDropChance())) {
                ((EntityEquipmentEntryModel)this.model).setDropChanceFromText((String)value);
            }
        });
        ((EntityEquipmentEntryModel)this.model).dropChanceProperty().addListener(value -> {
            String formatted = ((EntityEquipmentEntryModel)this.model).formatDropChance();
            if (!Objects.equals(formatted, ((EntityEquipmentEntryView)this.view).getDropChanceField().getText())) {
                ((EntityEquipmentEntryView)this.view).getDropChanceField().setText(formatted);
            }
        });
        ((EntityEquipmentEntryView)this.view).getDropChanceField().validProperty().addListener(((EntityEquipmentEntryModel)this.model)::setValid);
        ((EntityEquipmentEntryView)this.view).getDropChanceField().onKeyPress(event -> {
            float next;
            if (event.isConsumed()) {
                return;
            }
            int key = event.getKeyCode();
            if (key != 265 && key != 264) {
                return;
            }
            String text = ((EntityEquipmentEntryView)this.view).getDropChanceField().getText();
            if (!((EntityEquipmentEntryModel)this.model).isDropChanceTextValid(text)) {
                return;
            }
            float current = Float.parseFloat(text);
            float step = 0.05f;
            if (event.isShiftKeyDown()) {
                step = 0.1f;
            } else if (event.isControlKeyDown()) {
                step = 0.01f;
            }
            if (key == 264) {
                step = -step;
            }
            if (Math.abs((next = Math.max(0.0f, Math.min(1.0f, current + step))) - current) < 1.0E-4f) {
                return;
            }
            ((EntityEquipmentEntryModel)this.model).setDropChance(next);
            event.consume();
        });
        ((EntityEquipmentEntryView)this.view).getOpenEditorButton().onAction(() -> this.openEditor(EditorType.STANDARD));
        ((EntityEquipmentEntryView)this.view).getOpenSnbtEditorButton().onAction(() -> this.openEditor(EditorType.SNBT));
        ((EntityEquipmentEntryView)this.view).getClearButton().onAction(() -> {
            this.placeholder = false;
            ((EntityEquipmentEntryModel)this.model).setItemStack(class_1799.field_8037);
        });
    }

    private void updateItemName() {
        class_1799 stack = ((EntityEquipmentEntryModel)this.model).getItemStack();
        class_5250 name = stack.method_7960() ? class_2561.method_43470((String)"-").method_27694(style -> style.method_36139(0xA0A0A0)) : stack.method_7964().method_27661();
        ((EntityEquipmentEntryView)this.view).getItemNameLabel().setLabel((class_2561)name);
        boolean empty = stack.method_7960();
        ((EntityEquipmentEntryView)this.view).getOpenSnbtEditorButton().setDisable(empty);
    }

    private void openEditor(EditorType type) {
        if (((EntityEquipmentEntryModel)this.model).getItemStack().method_7960()) {
            this.placeholder = true;
            ((EntityEquipmentEntryModel)this.model).setItemStack(new class_1799((class_1935)class_1802.field_8600));
            this.openEditorNow(type);
            return;
        }
        this.placeholder = false;
        this.ensureItemStack(() -> this.openEditorNow(type));
    }

    private void openEditorNow(EditorType type) {
        class_1799 initial = ((EntityEquipmentEntryModel)this.model).getItemStack().method_7972();
        ItemEditorContext context = new ItemEditorContext(initial, null, false, ctx -> {
            class_1799 result = ctx.getItemStack().method_7972();
            ((EntityEquipmentEntryModel)this.model).setItemStack(result);
            if (this.placeholder) {
                if (result.method_31574(class_1802.field_8600)) {
                    ((EntityEquipmentEntryModel)this.model).setItemStack(class_1799.field_8037);
                }
                this.placeholder = false;
            }
            this.placeholder = false;
        });
        ModScreenHandler.openEditor(type, context);
    }

    private void ensureItemStack(Runnable onReady) {
        if (!((EntityEquipmentEntryModel)this.model).getItemStack().method_7960()) {
            onReady.run();
            return;
        }
        this.openItemSelection(onReady);
    }

    private void openItemSelection(Runnable afterSelection) {
        ModScreenHandler.openListSelectionScreen(ModTexts.ITEM, "equipment", ClientCache.getItemSelectionItems(), selection -> {
            if (selection == null || selection.isEmpty()) {
                return;
            }
            try {
                class_2960 id = class_2960.method_60654((String)selection);
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                if (item != null) {
                    ((EntityEquipmentEntryModel)this.model).setItemStack(new class_1799((class_1935)item));
                    this.placeholder = false;
                    if (afterSelection != null) {
                        afterSelection.run();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void openVaultSelection() {
        ArrayList<VaultItemListSelectionElementModel> elements = new ArrayList<VaultItemListSelectionElementModel>();
        LinkedHashMap<String, class_1799> stacksById = new LinkedHashMap<String, class_1799>();
        List<class_2487> storedItems = Vault.getInstance().getItems();
        for (int i = 0; i < storedItems.size(); ++i) {
            class_1799 stack = class_1799.method_57359((class_7225.class_7874)ClientUtil.registryAccess(), (class_2487)storedItems.get(i));
            if (stack.method_7960()) continue;
            class_2960 id = class_2960.method_60655((String)"cadeditor", (String)("equipment_vault_item_" + i));
            elements.add(new VaultItemListSelectionElementModel(id, stack));
            stacksById.put(id.toString(), stack.method_7972());
        }
        if (elements.isEmpty()) {
            return;
        }
        ModScreenHandler.openListSelectionScreen(ModTexts.VAULT, "vault_item_equipment", elements, selectedId -> {
            class_1799 chosen = (class_1799)stacksById.get(selectedId);
            if (chosen == null) {
                return;
            }
            ((EntityEquipmentEntryModel)this.model).setItemStack(chosen.method_7972());
            this.placeholder = false;
        });
    }
}

