/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.guapi.api.mvc.Model;
import com.github.franckyi.guapi.api.node.TreeView;
import com.github.rinorsi.cadeditor.mixin.CompoundTagMixin;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagModel
implements TreeView.TreeItem<NBTTagModel>,
Model {
    private final ObservableList<NBTTagModel> children = ObservableList.create();
    private final BooleanProperty expandedProperty = BooleanProperty.create();
    private final ObjectProperty<NBTTagModel> parentProperty;
    private final BooleanProperty childrenChangedProperty = BooleanProperty.create();
    private final StringProperty nameProperty;
    private final StringProperty valueProperty;
    private final BooleanProperty validProperty = BooleanProperty.create();
    protected final class_2520 tag;
    protected byte forcedTagType;

    public NBTTagModel(class_2520 tag) {
        this(tag, null, null, null);
        this.setExpanded(true);
    }

    public NBTTagModel(byte forcedTagType, NBTTagModel parent, String value) {
        this(null, parent, null, value);
        this.forcedTagType = forcedTagType;
    }

    public NBTTagModel(class_2520 tag, NBTTagModel parent, String name, String value) {
        this.tag = tag;
        this.parentProperty = ObjectProperty.create(parent);
        this.nameProperty = StringProperty.create(name);
        this.valueProperty = StringProperty.create(value);
        if (tag != null) {
            switch (tag.method_10711()) {
                case 10: {
                    this.children.setAll((Collection<NBTTagModel>)((CompoundTagMixin)tag).getEntries().stream().map(entry -> new NBTTagModel((class_2520)entry.getValue(), this, (String)entry.getKey(), null)).toList());
                    break;
                }
                case 9: {
                    this.children.setAll((Collection<NBTTagModel>)((class_2499)tag).stream().map(tag1 -> new NBTTagModel((class_2520)tag1, this, null, null)).toList());
                    break;
                }
                case 7: {
                    this.children.setAll((Collection<NBTTagModel>)Stream.of(ArrayUtils.toObject((byte[])((class_2479)tag).method_10521())).map(b -> new NBTTagModel(1, this, Byte.toString(b))).toList());
                    break;
                }
                case 11: {
                    this.children.setAll((Collection<NBTTagModel>)Stream.of(ArrayUtils.toObject((int[])((class_2495)tag).method_10588())).map(i -> new NBTTagModel(3, this, Integer.toString(i))).toList());
                    break;
                }
                case 12: {
                    this.children.setAll((Collection<NBTTagModel>)Stream.of(ArrayUtils.toObject((long[])((class_2501)tag).method_10615())).map(l -> new NBTTagModel(4, this, Long.toString(l))).toList());
                    break;
                }
                case 1: {
                    this.setValue(Byte.toString(((class_2481)tag).method_10698()));
                    break;
                }
                case 2: {
                    this.setValue(Short.toString(((class_2516)tag).method_10696()));
                    break;
                }
                case 3: {
                    this.setValue(Integer.toString(((class_2497)tag).method_10701()));
                    break;
                }
                case 4: {
                    this.setValue(Long.toString(((class_2503)tag).method_10699()));
                    break;
                }
                case 5: {
                    this.setValue(Float.toString(((class_2494)tag).method_10700()));
                    break;
                }
                case 6: {
                    this.setValue(Double.toString(((class_2489)tag).method_10697()));
                    break;
                }
                default: {
                    this.setValue(tag.method_10714());
                }
            }
        }
        this.getChildren().addListener(() -> ((NBTTagModel)this.getRoot()).setChildrenChanged(true));
        this.validProperty().bind(this.getChildren().allMatch(NBTTagModel::isValid, NBTTagModel::validProperty));
    }

    @Override
    public ObservableList<NBTTagModel> getChildren() {
        return this.children;
    }

    @Override
    public BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    @Override
    public ObjectProperty<NBTTagModel> parentProperty() {
        return this.parentProperty;
    }

    @Override
    public BooleanProperty childrenChangedProperty() {
        return this.childrenChangedProperty;
    }

    public String getName() {
        return (String)this.nameProperty().getValue();
    }

    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    public void setName(String value) {
        this.nameProperty().setValue(value);
    }

    public String getValue() {
        return (String)this.valueProperty().getValue();
    }

    public StringProperty valueProperty() {
        return this.valueProperty;
    }

    public void setValue(String value) {
        this.valueProperty().setValue(value);
    }

    public boolean isValid() {
        return this.validProperty().getValue();
    }

    public BooleanProperty validProperty() {
        return this.validProperty;
    }

    public void setValid(boolean value) {
        this.validProperty().setValue(value);
    }

    public byte getTagType() {
        return this.tag != null ? this.tag.method_10711() : this.forcedTagType;
    }

    public boolean canBuild() {
        return this.tag != null;
    }

    public class_2520 build() {
        if (this.canBuild()) {
            switch (this.tag.method_10711()) {
                case 1: {
                    return class_2481.method_23233((byte)Byte.parseByte(this.getValue()));
                }
                case 2: {
                    return class_2516.method_23254((short)Short.parseShort(this.getValue()));
                }
                case 3: {
                    return class_2497.method_23247((int)Integer.parseInt(this.getValue()));
                }
                case 4: {
                    return class_2503.method_23251((long)Long.parseLong(this.getValue()));
                }
                case 5: {
                    return class_2494.method_23244((float)Float.parseFloat(this.getValue()));
                }
                case 6: {
                    return class_2489.method_23241((double)Double.parseDouble(this.getValue()));
                }
                case 7: {
                    return new class_2479(this.getChildren().stream().map(NBTTagModel::getValue).map(Byte::parseByte).toList());
                }
                case 8: {
                    return class_2519.method_23256((String)this.getValue());
                }
                case 9: {
                    class_2499 listTag = new class_2499();
                    listTag.addAll(this.getChildren().stream().map(NBTTagModel::build).toList());
                    return listTag;
                }
                case 10: {
                    class_2487 compoundTag = new class_2487();
                    this.getChildren().forEach(childTag -> compoundTag.method_10566(childTag.getName(), childTag.build()));
                    return compoundTag;
                }
                case 11: {
                    return new class_2495(this.getChildren().stream().map(NBTTagModel::getValue).map(Integer::parseInt).toList());
                }
                case 12: {
                    return new class_2501(this.getChildren().stream().map(NBTTagModel::getValue).map(Long::parseLong).toList());
                }
            }
        }
        return null;
    }

    public NBTTagModel createClipboardTag() {
        return this.canBuild() ? new NBTTagModel(this.build(), null, this.getName(), this.getValue()) : new NBTTagModel(this.getTagType(), null, this.getValue());
    }
}

