/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.entity;

import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.entity.EntityCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class EntitySpawnSettingsCategoryModel
extends EntityCategoryModel {
    public EntitySpawnSettingsCategoryModel(EntityEditorModel editor) {
        super((class_2561)ModTexts.ENTITY_SPAWN, editor);
    }

    @Override
    protected void setupEntries() {
        class_2487 data = this.getData();
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.CAN_PICK_UP_LOOT, data.method_10577("CanPickUpLoot"), value -> this.setBoolean("CanPickUpLoot", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.PERSISTENCE_REQUIRED, data.method_10577("PersistenceRequired"), value -> this.setBoolean("PersistenceRequired", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.NO_AI, data.method_10577("NoAI"), value -> this.setBoolean("NoAI", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.LEFT_HANDED, data.method_10577("LeftHanded"), value -> this.setBoolean("LeftHanded", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.CAN_JOIN_RAID, data.method_10577("CanJoinRaid"), value -> this.setBoolean("CanJoinRaid", (boolean)value)));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.PATROL_LEADER, data.method_10577("PatrolLeader"), value -> this.setBoolean("PatrolLeader", (boolean)value)));
        String team = data.method_10573("Team", 8) ? data.method_10558("Team") : "";
        this.getEntries().add(new StringEntryModel((CategoryModel)this, ModTexts.TEAM, team, this::setTeam));
        float reinforcements = data.method_10573("SpawnReinforcementsChance", 5) ? data.method_10583("SpawnReinforcementsChance") : 0.0f;
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, ModTexts.SPAWN_REINFORCEMENTS_CHANCE, reinforcements, this::setSpawnReinforcementsChance, value -> value.floatValue() >= 0.0f && value.floatValue() <= 1.0f));
    }

    private void setBoolean(String key, boolean value) {
        if (value) {
            this.getData().method_10556(key, true);
        } else {
            this.getData().method_10551(key);
        }
    }

    private void setTeam(String value) {
        String trimmed;
        String string = trimmed = value == null ? "" : value.trim();
        if (trimmed.isEmpty()) {
            this.getData().method_10551("Team");
        } else {
            this.getData().method_10582("Team", trimmed);
        }
    }

    private void setSpawnReinforcementsChance(float value) {
        float clamped = Math.max(0.0f, Math.min(1.0f, value));
        if (clamped > 0.0f) {
            this.getData().method_10548("SpawnReinforcementsChance", clamped);
        } else {
            this.getData().method_10551("SpawnReinforcementsChance");
        }
    }
}

